/**
 * Class Name	: IMGFileInfo
 * Description	: File õ ƿƼ Ŭ
 * Date 				: 2003/08/07
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/08/07 first created.
 */

package com.conv2.imageGS.Util;

import java.io.File;
import java.util.Date;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.FormatMatch;

/**
 *    Ŭ .
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class IMGFileInfo
{
	/**
	 * ش  ϸ
	 */
	private String fname = null;
	
	/**
	 * ش   θ 丮
	 */
	private String parentPath = null;
	
	/**
	 * ش    (, RAW   .)
	 */
	private String format = null;
	
	/**
	 * ش   ֱ  ¥ - long 
	 */
	private long lastModifiedTime = -1;
	
	/**
	 * ش   ֱ  ¥ - Date
	 */
	private Date lastModifiedDate = null;
	
	/**
	 * imageGS ϴ   (, RAW )
	 */
	private boolean isApplyImageFormat = false;
	
	/**
	 * ش     
	 */
	private boolean isExist = false;
	
	/**
	 * ش   ü θ
	 */
	private String absolutePath = null;

	/**
	 * ش     
	 */
	private boolean isFile = false;
	
	/**
	 * ش   
	 */
	private long fileSize = -1;
	
	/**
	 *  
	 * 
	 * @param fname ش ϸ
	 */
	public IMGFileInfo( String fname ) throws ImageGSException
	{
		try
		{
			init(fname);
		} 
		catch(Exception e)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + e);	
		}
	}
	
	private void init( String fname ) throws Exception
	{
		File fp = new File(fname);
		
		if(fp.exists() && fp.isDirectory())
		{
			this.isFile = false;
		}
		else if(!fp.exists())
		{
			this.isExist = false;	
		}
		else if(fp.exists())
		{
			this.isFile = true;
			this.isExist = true;
			this.fname = fp.getName();	
			this.parentPath = fp.getParent();	
			this.absolutePath = fp.getAbsolutePath();
				
			this.lastModifiedTime = fp.lastModified();	
			this.lastModifiedDate = new Date(fp.lastModified());
			
			FormatMatch formatCheck = new FormatMatch();
			int formatType = formatCheck.match(fname);

			switch(formatType)
			{
				case 1 : 
					format = "JPEG";
					break;
				case 2 :
					format = "BMP";
					break;
				case 3 :
					format = "PPM";
				case 4 :
					format = "PNG";
					break;
				case 5 :
					format = "GIF";
					break;
				case -1 :
					format = "UNKNOWN FOMRAT or RAW?";
					break;
			}

			if(formatType != -1) isApplyImageFormat = true;
			
			fileSize = fp.length();
			
			fp = null;
					
		}	
	}
	
	/**
	 * ش   ü θ ȯѴ.
	 */
	public String getAbsolutePath()
	{
		return absolutePath;
	}

	/**
	 * ش   ũ⸦ ȯѴ.
	 */
	public long getFileSize()
	{
		return fileSize;
	}

	/**
	 * ش  ϸ ȯѴ.
	 */
	public String getFname()
	{
		return fname;
	}

	/**
	 * ش   ˸ ȯѴ.
	 */
	public String getFormat()
	{
		return format;
	}

	/**
	 * ش   imageGS API ϴ θ ȯѴ. .(, RAW  false̴)
	 */
	public boolean isApplyImageFormat()
	{
		return isApplyImageFormat;
	}

	/**
	 * ش   ϴ θ ȯѴ.
	 */
	public boolean isExist()
	{
		return isExist;
	}

	/**
	 * ش   Ÿ ȯѴ. ⼭  ϶ ̰, ϶ 丮̴.
	 */
	public boolean isFile()
	{
		return isFile;
	}

	/**
	 * ش   ֱ  ¥ Date Ÿ ȯѴ.
	 */
	public Date getLastModifiedDate()
	{
		return lastModifiedDate;
	}

	/**
	 * ش   ֱ  ¥ long Ÿ ȯѴ.
	 */
	public long getLastModifiedTime()
	{
		return lastModifiedTime;
	}

	/**
	 * ش   θ 丮 ȯѴ.
	 */
	public String getParentPath()
	{
		return parentPath;
	}
	
	/**
	 * ش     String · ȯѴ. , ش   Ҷ Ѵ.
	 */
	public String toString()
	{
		StringBuffer _buffer = new StringBuffer();
		
		if(!this.isExist())
		{
			_buffer.append(this.getAbsolutePath() + " is not exists!");
			return _buffer.toString();
		}
		
		//
		// C sprintf    ϰ ش.
		// 
		
		PrintfFormat _pf = new PrintfFormat("[%2s]  %-20s : %s\n");
		String format[]  = new String[3]; 
		
		_buffer.append("==============================================================\n");	
		_buffer.append("\t\t Information by imageGS java API  \n");
		_buffer.append("==============================================================\n");
		
		format[0] = "1"; format[1] = "fname"; format[2] = this.getFname();
		_buffer.append(_pf.sprintf(format));
		
		format[0] = "2"; format[1] = "absolute path"; format[2] = this.getAbsolutePath();
		_buffer.append(_pf.sprintf(format));

		format[0] = "3"; format[1] = "parent path"; format[2] = this.getParentPath();
		_buffer.append(_pf.sprintf(format));

		format[0] = "4"; format[1] = "isExist"; format[2] = String.valueOf(this.isExist());
		_buffer.append(_pf.sprintf(format));					

		format[0] = "5"; format[1] = "isFile"; format[2] = String.valueOf(this.isFile());
		_buffer.append(_pf.sprintf(format));

		format[0] = "6"; format[1] = "lastModified(long)"; format[2] = String.valueOf(this.getLastModifiedTime());
		_buffer.append(_pf.sprintf(format));

		format[0] = "7"; format[1] = "lastModified(date)"; format[2] = String.valueOf(this.getLastModifiedDate());
		_buffer.append(_pf.sprintf(format));

		format[0] = "8"; format[1] = "format"; format[2] = this.getFormat();
		_buffer.append(_pf.sprintf(format));

		format[0] = "9"; format[1] = "isApplayImageFormat"; format[2] = String.valueOf(this.isApplyImageFormat());
		_buffer.append(_pf.sprintf(format));

		format[0] = "10"; format[1] = "size"; format[2] = String.valueOf(this.getFileSize()) + " bytes";
		_buffer.append(_pf.sprintf(format));
								
		_buffer.append("==============================================================\n");
									
		return _buffer.toString();
	}
}
