/**
 * Class Name	: GetSystemProperties
 * Description	:  ڹ ý Ӽ ش.
 * Date 				: 2003/01/18
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/12/21 first created.
 */

package com.conv2.imageGS.Util;

import java.util.*; // using Properties
import java.io.*;

import com.conv2.imageGS.Exception.*;

/**
 *  ý۳ ġ ڹٿ õ ȯ  ְų Ϸ Ѵ.<p>
 *
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public final class GetSystemProperties 
{
	private GetSystemProperties() {}
	
	/**
	 *  ޸ ¸ String · ȯѴ.
	 * 
	 * <xmp>
	 * [Programming Tip] 
	 * 
	 * ޸  ϴ  ø̼  -Xms64M -Xmx256M  ߰ϸ ȴ.
	 *   Ŭ test ϸ, java -Xms64M -Xmx256M test ָ ȴ.
	 * ̰ tomcat̳ ü ø̼   -Xms64M -Xmx256M  ָ߰,
	 *   õ κ    ִ.
	 * 
	 * -Xms64M -Xmx256M  ּ 64ްƮ ִ 256ް Ʈ Ҵϰڴٴ ̴.
	 * ⼭ ý ϴ ѿ ޸𸮷   ִ.
	 * 
	 * </xmp>
	 * 
	 */
	public static String getMemoryStatus()
	{
		StringBuffer sb = new StringBuffer();
		
		Runtime runtime = Runtime.getRuntime();
		
		long totalMemory = runtime.totalMemory(); // the total amount of memory in the Java virtual machine
		long freeMemory = runtime.freeMemory(); // the amount of free memory in the Java Virtual Machine
		long usedMemory = totalMemory - freeMemory;
		
		sb.append("Total memory : " + totalMemory + " bytes \n");
		sb.append("Free memory : " + freeMemory  + " bytes \n");
		sb.append("Used memory : " + usedMemory + " bytes \n");
		
		return sb.toString();
	}
	
	/**
	 *  ý۳ ġ ڹٿ õ  ȯ ߿ Ӽ ϴ  String · ȯѴ.
	 * 
	 * @param key	Ű
	 * @return String type ڹ  
	 */
	public static String getValue(String key)
	{
	    Properties prop = System.getProperties();
		
	    return prop.getProperty(key);
	}

	/**
	 *  ý۳ ġ ڹٿ õ ȯ  String Ÿ ȯѴ. <br>
	 * ȯ : key1=value1\nkey2=value2\n...... <p>
	 * 
	 * [] <br>
	 * windows unix/linux '\n' '\r\n' ̰ Ƿ line.separator  ϱ Ѵ.<p>
	 * 
	 */
	public static String getString()
	{
		StringBuffer sb = new StringBuffer();
		String key;
		String value;
		
		Properties props = System.getProperties();
		String line_separter = getValue("line.separator");
		
		Enumeration enum = props.propertyNames();
		for ( ; enum.hasMoreElements(); ) 
		{
			key = (String)enum.nextElement();
			value = (String)props.get(key);
			sb.append(key).append("=").append(value).append(line_separter);
		}
		
		return sb.toString();	
	}
			
	/**
	 *  ý۳ ġ ڹٿ õ ȯ  System console  Ѹ.
	 */
	public static void print()
	{
		System.getProperties().list( System.out );	
	}
	
	/**
	 *  ý۳ ġ ڹٿ õ ȯ  Ϸ Ѵ.
	 * 
	 * @param	fname	 ϸ
	 * @exception fname   
	 */
	public static void save(String fname) throws ImageGSException 
	{
		FileOutputStream out = null;
		PrintWriter pw = null; 

		try
		{
			out = new FileOutputStream(fname);
			pw = new PrintWriter(out);

			System.getProperties().list( pw );	
			
			pw.close(); 
			out.close();
		} 
		catch (Exception e) 
		{
			try
			{
				if(pw != null) pw.close();
				if(out != null) out.close();
			} 
			catch (IOException es) {}
			
			throw new ImageGSException("GetSystemProperties.save()  >>"  + e.getMessage());			
		}

	}
}
