/**
 * Class Name	: GetStatisticsGrayIMG
 * Description	: հ, ǥ ϴ Ŭ
 * Date 				: 2002/09/15
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/09/15 first created.
 */
package com.conv2.imageGS.Util;

/**
 * հ, ǥ Ѵ. ⼭ StatisticsIMG class  ٸ. 
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public final class GetStatisticsGrayIMG
{
	private GetStatisticsGrayIMG() {}

	/**
	 * short type ϵ  հ Ѵ.
	 * 
	 * @param	GrayIMG	ϵ  
	 * @param	GrayIMG_height	
	 * @param	GrayIMG_width	ʺ
	 * @return	հ
	 */
	public static double getMean2(short [][] GrayIMG, int GrayIMG_height, int GrayIMG_width)
	{
		double mean2 = 0.0;
		double sum = 0.0;
		int i, j;
		
		for(i=0; i<GrayIMG_height; i++)
		{
			for(j=0; j<GrayIMG_width; j++)
			{
				sum += (double)GrayIMG[i][j];	
			}			
		}

		mean2 = sum / (double)(GrayIMG_height * GrayIMG_width);
		
		return mean2;	
	} 

	/**
	 * double type ϵ  հ Ѵ.
	 * 
	 * @param	GrayIMG	ϵ  
	 * @param	GrayIMG_height	
	 * @param	GrayIMG_width	ʺ
	 * @return	հ
	 */	
	public static double getMean2(double [][] GrayIMG, int GrayIMG_height, int GrayIMG_width)
	{
		double mean2 = 0.0;
		double sum = 0.0;
		int i, j;
		
		for(i=0; i<GrayIMG_height; i++)
		{
			for(j=0; j<GrayIMG_width; j++)
			{
				sum += GrayIMG[i][j];	
			}			
		}

		mean2 = sum / (double)(GrayIMG_height * GrayIMG_width);
		
		return mean2;	
	} 

	/**
	 * short type ϵ  ǥ Ѵ.
	 * 
	 * @param	GrayIMG	ϵ  
	 * @param	GrayIMG_height	
	 * @param	GrayIMG_width	ʺ
	 * @return	ǥ
	 */	
	public static double getStd2(short [][] GrayIMG, int GrayIMG_height, int GrayIMG_width)
	{
		double std2 = 0.0;
		double variance = 0.0;
		
		int i, j;
				
		double mean2 = GetStatisticsGrayIMG.getMean2(GrayIMG, GrayIMG_height, GrayIMG_width);
		
		for(i=0; i<GrayIMG_height; i++)
		{
			for(j=0; j<GrayIMG_width; j++)
			{
				variance += Math.pow(((double)GrayIMG[i][j] - mean2), 2.0);
			}	
		}	
		
		std2 = Math.sqrt( variance / (double)(GrayIMG_height * GrayIMG_width));	
		
		return std2;
	}

	/**
	 * double type ϵ  ǥ Ѵ.
	 * 
	 * @param	GrayIMG	ϵ  
	 * @param	GrayIMG_height	
	 * @param	GrayIMG_width	ʺ
	 * @return	ǥ
	 */	
	public static double getStd2(double [][] GrayIMG, int GrayIMG_height, int GrayIMG_width)
	{
		double std2 = 0.0;
		double variance = 0.0;
		
		int i, j;
				
		double mean2 = GetStatisticsGrayIMG.getMean2(GrayIMG, GrayIMG_height, GrayIMG_width);
		
		for(i=0; i<GrayIMG_height; i++)
		{
			for(j=0; j<GrayIMG_width; j++)
			{
				variance += Math.pow((GrayIMG[i][j] - mean2), 2.0);
			}	
		}	
		
		std2 = Math.sqrt( variance / (double)(GrayIMG_height * GrayIMG_width));	
		
		return std2;
	}
}
