/**
 * Class Name	: GetSizeGrayIMG
 * Description	: ش  ũ(,ʺ)  Ŭ
 * Date 				: 2003/01/17
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/09/03 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * ش ϵ  /ʺ ´. <p>
 * 
 * [] <p>
 * 
 * ޼ҵ ʹ ƴٴ ǰ߿ ,   ϴ getHeight(), getWidth() ޼ҵ ߰. <p>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.2
 */
public class GetSizeIMG
{
	/**
	 * 
	 */
	private GetSizeIMG() {}

   /**
     * HeightFromGrayIMG : short type  argument  height ȯ.
	 *
     * @return    height ȯ
     * @exception ImageGSException GrayIMG ϶
     */
	public static int HeightFromGrayIMG(short[][] GrayIMG) throws ImageGSException
	{
		int height;
		
		if(GrayIMG == null) {
			throw new ImageGSException ("GetSizeIMG.HeightFromGrayIMG()  >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}	
		
		height = GrayIMG.length;
		
		return height;
	}

   /**
     * WidthFromGrayIMG : short type  argument  Width ȯ.
	 *
     * @return    width ȯ
     * @exception ImageGSException GrayIMG ϶
     */
	public static int WidthFromGrayIMG(short[][] GrayIMG) throws ImageGSException
	{
		int width;
		
		if(GrayIMG == null) {
			throw new  ImageGSException ("GetSizeIMG.WidthFromGrayIMG >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}	
		
		int height = GrayIMG.length;
		width = GrayIMG[height-1].length;
		return width;
	}
	
   /**
     * HeightFromGrayIMG : double type  argument  height ȯ.
	 *
     * @return    height ȯ
     * @exception ImageGSException GrayIMG ϶
     */
	public static int HeightFromGrayIMG(double[][] GrayIMG) throws ImageGSException
	{
		int height;
		
		if(GrayIMG == null) {
			throw new ImageGSException ("GetSizeIMG.HeightFromGrayIMG() >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}	
		
		height = GrayIMG.length;
		
		return height;
	}


   /**
     * WidthFromGrayIMG : double type  argument  Width ȯ.
	 *
     * @return    width ȯ
     * @exception ImageGSException GrayIMG ϶
     */
	public static int WidthFromGrayIMG(double[][] GrayIMG) throws ImageGSException
	{
		int width;
		
		if(GrayIMG == null) {
			throw new  ImageGSException ("GetSizeIMG.WidthFromGrayIMG  >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}	
		
		int height = GrayIMG.length;
		width = GrayIMG[height-1].length;
		return width;
	}

   /**
     * HeightFromGrayIMG : integer type  argument  height ȯ.
	 *
     * @return    height ȯ
     * @exception ImageGSException GrayIMG ϶
     */
	public static int HeightFromGrayIMG(int[][] GrayIMG) throws ImageGSException
	{
		int height;
		
		if(GrayIMG == null) {
			throw new ImageGSException ("GetSizeIMG.HeightFromGrayIMG() >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 	
		}	
		
		height = GrayIMG.length;
		
		return height;
	}

   /**
     * WidthFromGrayIMG : integer type  argument  Width ȯ.
	 *
     * @return    width ȯ
     * @exception ImageGSException GrayIMG ϶
     */
	public static int WidthFromGrayIMG(int[][] GrayIMG) throws ImageGSException
	{
		int width;
		
		if(GrayIMG == null) {
			throw new  ImageGSException ("GetSizeIMG.WidthFromGrayIMG  >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 	
		}	
		
		int height = GrayIMG.length;
		width = GrayIMG[height-1].length;
		return width;
	}


	// == 2003/01/17 ڵ ߰.
	/**
	 * getHeight : short type  argument  height ȯ. <p>
	 * 
	 * [] : HeightFromGrayIMG()    ϸ ޼ҵ ̰ ִ. <p>
	 *
	 * @return    height ȯ
	 * @exception ImageGSException GrayIMG ϶
	 */
	public static int getHeight(short[][] GrayIMG) throws ImageGSException
	{
		if(GrayIMG == null) 
		{
			throw new ImageGSException ("GetSizeIMG.getHeight()  >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}	
		
		return GrayIMG.length;
	}

	/**
	 * getHeight : integer type  argument  height ȯ. <p>
	 * 
	 * [] : HeightFromGrayIMG()    ϸ ޼ҵ ̰ ִ. <p>
	 *
	 * @return    height ȯ
	 * @exception ImageGSException GrayIMG ϶
	 */
	public static int getHeight(int[][] GrayIMG) throws ImageGSException
	{
		if(GrayIMG == null) 
		{
			throw new ImageGSException ("GetSizeIMG.getHeight()  >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}	
		
		return GrayIMG.length;
	}

	/**
	 * getHeight : double type  argument  height ȯ. <p>
	 * 
	 * [] : HeightFromGrayIMG()    ϸ ޼ҵ ̰ ִ. <p>
	 *
	 * @return    height ȯ
	 * @exception ImageGSException GrayIMG ϶
	 */
	public static int getHeight(double[][] GrayIMG) throws ImageGSException
	{
		if(GrayIMG == null) 
		{
			throw new ImageGSException ("GetSizeIMG.getHeight()  >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}	
		
		return GrayIMG.length;
	}


	/**
	 * getWidth : short type  argument  width ȯ. <p>
	 * 
	 * [] : WidthFromGrayIMG()    ϸ ޼ҵ ̰ ִ. <p>
	 *
	 * @return    width ȯ
	 * @exception ImageGSException GrayIMG ϶
	 */
	public static int getWidth(short[][] GrayIMG) throws ImageGSException
	{
		if(GrayIMG == null) 
		{
			throw new ImageGSException ("GetSizeIMG.getWidth()  >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}	
		
		int height = GrayIMG.length;
		int width = GrayIMG[height-1].length;
		
		return width;
	}

	/**
	 * getWidth : integer type  argument  width ȯ. <p>
	 * 
	 * [] : WidthFromGrayIMG()    ϸ ޼ҵ ̰ ִ. <p>
	 *
	 * @return    width ȯ
	 * @exception ImageGSException GrayIMG ϶
	 */
	public static int getWidth(int[][] GrayIMG) throws ImageGSException
	{
		if(GrayIMG == null) 
		{
			throw new ImageGSException ("GetSizeIMG.getWidth()  >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}	
		
		int height = GrayIMG.length;
		int width = GrayIMG[height-1].length;
		
		return width;
	}	

	/**
	 * getWidth : double type  argument  width ȯ. <p>
	 * 
	 * [] : WidthFromGrayIMG()    ϸ ޼ҵ ̰ ִ. <p>
	 *
	 * @return    width ȯ
	 * @exception ImageGSException GrayIMG ϶
	 */
	public static int getWidth(double[][] GrayIMG) throws ImageGSException
	{
		if(GrayIMG == null) 
		{
			throw new ImageGSException ("GetSizeIMG.getWidth()  >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}	
		
		int height = GrayIMG.length;
		int width = GrayIMG[height-1].length;
		
		return width;
	}	
	
}