/**
 * Class Name	: FileOperation
 * Description	:  copy, move ϴ Ŭ 
 * Date 				: 2002/12/03
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/12/03 first created.
 */

package com.conv2.imageGS.Util;

import java.io.*;

import com.conv2.imageGS.Exception.*;

/**
 *  copy Ǵ move Ѵ. 
 *  
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class FileOperation
{

    /**
     *  Ѵ.  <p>
     * 
     * , src_fname, dest_fname 丮̸  ʴ´.<br>
     * src_fname dest_fname   ʴ´.<p>
     * 
     * @param	src_fname 	  
     * @param	dest_fname	  
     * @exception ImageGSException 
     */	
	public static void copy(String src_fname, String dest_fname) throws ImageGSException
	{
		File src = new File(src_fname);
		File dest = new File(dest_fname);

		if(src.isDirectory() == true || dest.isDirectory() == true) return;

		try 
		{
			copy(src, dest);
		}
		catch (IOException e)
		{
			throw new ImageGSException("FileOperation.copy() >> "  + e.getMessage());			
		}
	}
		
    private static void copy(File src, File dest) throws IOException
    {
    	// src dest  copy  ʴ´.
        if (src.getCanonicalPath().equals(dest.getCanonicalPath())) 
        {
            return;
        }

        FileInputStream fin = new FileInputStream(src);
        FileOutputStream fout = new FileOutputStream(dest);
		
        StreamCopy(fin, fout);

        fin.close();
        fout.close();
    }
    
    /**
     *  ű.
     * 
     * @param	src_fname 	ű  
     * @param	dest_fname	ű   Ǵ  丮
     * @param	overwrite		  Ǵϴ flag (true/false)
     * @exception ImageGSException 
     */	
	public static void move(String src_fname, String dest_fname, boolean overwrite) throws ImageGSException
	{
		File src = new File(src_fname);
		File dest = new File(dest_fname);
		
		try 
		{
			move(src, dest, overwrite);
		}
		catch (IOException e)
		{
			throw new ImageGSException("FileOperation.move() >> "  + e.getMessage());			
		}
	}

    private static void move(File src, File dest, boolean overwrite) throws IOException 
   	{
        if(src.getCanonicalPath().equals(dest.getCanonicalPath())) return;

        if (src.isDirectory()) 
        {
            throw new IOException("Can't move directories");
        }

        if (!dest.isFile())
        {
        	move(src, dest);
        }
        else if (dest.isFile() && overwrite) 
        {
            move(src, dest);
        } 
        else if (dest.isFile() && !overwrite) 
        {
            throw new IOException(dest + " exists");
        } 
        else if (dest.isDirectory()) 
        {
            move(src, new File(dest, src.getName()));
        } 
        else if (dest.getPath().endsWith(System.getProperty("file.separator"))) 
        {
            if (!dest.mkdirs()) 
            {
                throw new IOException("Could not create " + dest);
            }

            move(src, new File(dest, src.getName()));
        } 
        else
        {
            String dir = dest.getParent();
            String name = dest.getName();
            if (dir != null) 
            {
                if (!(new File(dir)).mkdirs()) 
                {
                    throw new IOException("Could not create " + dir);
                }
            }
            move(src, dest);
        }
    }

    private static void move(File src, File dest) throws IOException 
    {
        FileInputStream fin = new FileInputStream(src);
        FileOutputStream fout = new FileOutputStream(dest);
        StreamCopy(fin, fout);
        fout.close();
        fin.close();
        src.delete();
    }
    
    private static void StreamCopy(InputStream in, OutputStream out) throws IOException
    {
        synchronized (in) 
        {
            synchronized (out) 
            {
                byte[] buffer = new byte[256];
                int bytesRead;
                while (true) 
                {
                    bytesRead = in.read(buffer);
                    if (bytesRead == -1) 
                    {
                    	break;
                    }
                    out.write(buffer, 0, bytesRead);
                }
            }
        }   	
    }
}
