/**
 * Class Name	: CreateFileName
 * Description	: ־ ϸ  ο ϸ Ͽ ǵش.
 * Date 				: 2002/10/28
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/28 first created.
 */

package com.conv2.imageGS.Util;

/**
 * ־ ϸ  ο ϸ Ͽ ǵش.
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */

public class CreateFileName
{
	private CreateFileName() {}

	/**
	 * Ȯڸ Ͽ ǵش.<p>
	 * 
	 * ) filename = "1.jpg", Ȯڰ "png"̸ "1.png" ȯ<p>
	 * 
	 * @param filename  ϸ
	 * @param fmt		  Ȯ
	 * @return  Ȯڸ  ο ϸ ȯ, н  ȯ
	 */
	public static String changeExt(String filename, String fmt)
	{
		String newFileName = "";
		String extName = "";
		int extName_start = 0;
		
		if(filename == null) return "";
		
		try
		{		
			// fmt ϶  ǵش.
			if(fmt == null)
			{ 
				newFileName = "";
			}
			else 
			{
				extName_start = filename.lastIndexOf(".");
				newFileName = filename.substring(0, extName_start);
				newFileName = newFileName + "_" +  "." + fmt;			
			}
		} 
		catch (IndexOutOfBoundsException  e) 
		{
			newFileName = "";		
		}

		return newFileName;
	}

	/**
	 * ش ϸ  ̻(ڷ ) ٿ ǵش.<br>
	 *  ̻ ̴ ִ 5ڸ̴.<br>
	 * 
	 * ) filename = "test.jpg"϶ "test12345.jpg" ȯ.<p>
	 * 
	 * @param filename	 ϸ
	 * @return    ϸ ȯ, н  ȯ
	 */
	public static String getSuffixRandom(String filename)
	{
		String newFileName = getSuffixRandom(filename, null);
		
		return newFileName;
	}

	/**
	 * ش ϸ  ̻(ڷ ), Ȯڸ ٿ ǵش.<br>
	 *  ̻ ̴ ִ 5ڸ̴.<br>
	 * 
	 * ) filename = "test.jpg"̰, Ȯڰ "png" ,  "test12345.png" ȯ.<p>
	 * 
	 * @param filename	 ϸ
	 * @param fmt			Ȯ
	 * @return    ϸ ȯ, н  ȯ
	 */
	public static String getSuffixRandom(String filename, String fmt)
	{
		// ִ 5ڸ Ѵ.
		int random_integer = (int)(Math.random() * 100000.0);
		String  random_str = String.valueOf( random_integer );

		String newFileName = getSuffix(filename, random_str, fmt);
		
		return newFileName;
	}
				
	/**
	 *  ̻縦 ٿ ǵش. <p>
	 * 
	 *  ) filename = "1.jpg", ̻簡 "test"̸ "1_test.jpg" ȯ.<p>
	 * 
	 * @param filename	 ϸ
	 * @param suffix		̻
	 * @param fmt 			Ȯ
	 * @return    ϸ ȯ, н  ȯ
	 */
	public static String getSuffix(String filename, String suffix) 
	{
		String newFileName = getSuffix(filename, suffix, null);

		return newFileName;	
	}
	
	/**
	 *  ̻, Ȯڸ ٿ ǵش. <p>
	 *  ) filename = "1.jpg", ̻簡 "test", Ȯڰ "png"̸ "1_test.png" ȯ.<p>
	 * 
	 * @param filename	 ϸ
	 * @param suffix		̻
	 * @param fmt			Ȯ
	 * @return    ϸ ȯ, н  ȯ
	 */	
	public static String getSuffix(String filename, String suffix, String fmt) 
	{
		int extName_start; // Ȯڸ ۵Ǵ ġ
		String newFileName = ""; // Ȯڸ   ϸ
		String extName = "";

		if(filename == null) return "";
		
		try
		{
			// fmt ϶  ǵش.
			if(filename != null && fmt == null)
			{ 
				// Ȯڸ ν
				extName_start = filename.lastIndexOf(".");
				extName = filename.substring(extName_start+1);
			} 
			else 
			{
				extName_start = filename.lastIndexOf(".");
				extName = fmt;	
			}
			
			newFileName = filename.substring(0, extName_start);
			newFileName = newFileName + "_" + relpaceSpace(suffix, "_") + "." + extName;
		} 
		catch (IndexOutOfBoundsException  e) 
		{
			newFileName = "";		
		}
		
		return newFileName;
	}
	
	// suffix ȿ    rep_str ġѴ. 
	private static String relpaceSpace(String str, String rep_str)
	{
		if(str == null) return null;
		
		StringBuffer sb = new StringBuffer();
		
		for(int i=0; i<str.length(); i++)
		{
			if(str.charAt(i) == ' ') sb.append(rep_str);
			else sb.append(str.charAt(i));			
		}	
		
		return sb.toString();
	}
}
