/**
 * Class Name	: CopyIMGBuf
 * Description	:    Ŭ
 * Date 				: 2003/01/25
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/09/05 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 *   Ѵ.  ȯ  Բ Ѵ. (TypeConv2GrayIMG   Եȴ.).<p>
 * 
 * 1) short type -> short type <br>
 * 2) short type -> integer type <br>
 * 3) short type -> double type <p>
 * 
 * 4) integer type -> short type <br>
 * 5) integer type -> integer type <br>
 * 6) integer type -> double type <p>
 * 
 * 7) double type -> short type <br>
 * 8) double type -> integer type <br>
 * 9) double type -> double type <p>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.2
 */
public class CopyIMGBuf
{
	/**
	 * 
	 */
	private CopyIMGBuf() {}	
	
    /**
     * Copy to Source GrayIMGBuf  from Target GrayIMGBuf, both short type. (short -> short).<p>
     * 
     * short Ÿ   GrayIMGBuf  short Ÿ   GrayIMGBuf Ѵ. <p>
     * 
     * @param	SourceGrayIMG	 GrayIMG  for short type
     * @return    SourceGrayIMG   for short type
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static short [][] CopyShortGrayIMGBuf (short[][] SourceGrayIMGBuf) throws  ImageGSException	
	{
		short[][] TargetGrayIMGBuf = null;
		int SourceGrayIMGBuf_height;
		int SourceGrayIMGBuf_width;
		int i, j;
		
		if(SourceGrayIMGBuf == null) {
			throw new ImageGSException("CopyIMGBuf.CopyShortGrayIMGBuf >> "
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}
		
		try {
			SourceGrayIMGBuf_height = GetSizeIMG.getHeight(SourceGrayIMGBuf);
			SourceGrayIMGBuf_width = GetSizeIMG.getWidth(SourceGrayIMGBuf);
			TargetGrayIMGBuf = InitIMGBuf.ShortIMGBuf(SourceGrayIMGBuf_height, SourceGrayIMGBuf_width);
			
			//copy
			for(i=0; i<SourceGrayIMGBuf_height; i++)
			{
				System.arraycopy(SourceGrayIMGBuf[i], 0, TargetGrayIMGBuf[i], 0, SourceGrayIMGBuf_width);
			}
		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("CopyIMGBuf.CopyShortGrayIMGBuf >> "
				+ e.getMessage() ); 			
		}
		
		return TargetGrayIMGBuf;
	}

    /**
     * Copy to Source GrayIMGBuf  from Target GrayIMGBuf (short -> integer).<p>
     * 
     * short Ÿ   GrayIMGBuf  short Ÿ   GrayIMGBuf Ѵ. <p>
     * 
     * @param	SourceGrayIMG	 GrayIMG  for short type
     * @return    SourceGrayIMG   for integer type
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static int [][] CopyShort2IntegerGrayIMGBuf (short[][] SourceGrayIMGBuf) throws  ImageGSException	
	{
		int[][] TargetGrayIMGBuf = null;
		int SourceGrayIMGBuf_height;
		int SourceGrayIMGBuf_width;
		int i, j;
		
		if(SourceGrayIMGBuf == null) {
			throw new ImageGSException("CopyIMGBuf.CopyShort2IntegerGrayIMGBuf >>  " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}
		
		try {
			SourceGrayIMGBuf_height = GetSizeIMG.getHeight(SourceGrayIMGBuf);
			SourceGrayIMGBuf_width = GetSizeIMG.getWidth(SourceGrayIMGBuf);
			TargetGrayIMGBuf = InitIMGBuf.IntegerIMGBuf(SourceGrayIMGBuf_height, SourceGrayIMGBuf_width);
			
			//copy
			for(i=0; i<SourceGrayIMGBuf_height; i++)
			{
				for(j=0; j<SourceGrayIMGBuf_width; j++)
				{
					TargetGrayIMGBuf[i][j] = (int)SourceGrayIMGBuf[i][j];	
				}	
			}
		} 
		catch (Exception e)
		{
			throw new ImageGSException("CopyIMGBuf.CopyShort2IntegerGrayIMGBuf >> "
				+ e.getMessage() ); 			
		}		
		
		return TargetGrayIMGBuf;
	}
	
    /**
     * Copy to Source GrayIMGBuf  from Target GrayIMGBuf (short -> double).<p>
     * 
     * short Ÿ   GrayIMGBuf  short Ÿ   GrayIMGBuf Ѵ. <p>
     * 
     * @param	SourceGrayIMG	 GrayIMG  for short type
     * @return    SourceGrayIMG   for double type
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static double [][] CopyShort2DoubleGrayIMGBuf (short[][] SourceGrayIMGBuf) throws  ImageGSException	
	{
		double[][] TargetGrayIMGBuf = null;
		int SourceGrayIMGBuf_height;
		int SourceGrayIMGBuf_width;
		int i, j;
		
		if(SourceGrayIMGBuf == null) {
			throw new ImageGSException("CopyIMGBuf.CopyShort2DoubleGrayIMGBuf >>  " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}
		
		try {
			SourceGrayIMGBuf_height = GetSizeIMG.getHeight(SourceGrayIMGBuf);
			SourceGrayIMGBuf_width = GetSizeIMG.getWidth(SourceGrayIMGBuf);
			TargetGrayIMGBuf = InitIMGBuf.DoubleIMGBuf(SourceGrayIMGBuf_height, SourceGrayIMGBuf_width);
			
			//copy
			for(i=0; i<SourceGrayIMGBuf_height; i++)
			{
				for(j=0; j<SourceGrayIMGBuf_width; j++)
				{
					TargetGrayIMGBuf[i][j] = (double)SourceGrayIMGBuf[i][j];	
				}	
			}
		} 
		catch (Exception e)
		{
			throw new ImageGSException("CopyIMGBuf.CopyShortGrayIMGBuf >> "
				+ e.getMessage() ); 			
		}		
		
		return TargetGrayIMGBuf;
	}
	
    /**
     * Copy to Source GrayIMGBuf  from Target GrayIMGBuf, both double type. (double -> double).<p>
     * 
     * double Ÿ   GrayIMGBuf  double Ÿ   GrayIMGBuf Ѵ. <p>
     * 
     * @param	SourceGrayIMG	 GrayIMG  for double type
     * @return    SourceGrayIMG   for double type
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static double [][] CopyDoubleGrayIMGBuf (double[][] SourceGrayIMGBuf) throws  ImageGSException	
	{
		double[][] TargetGrayIMGBuf = null;
		int SourceGrayIMGBuf_height;
		int SourceGrayIMGBuf_width;
		int i, j;
		
		if(SourceGrayIMGBuf == null) {
			throw new ImageGSException("CopyIMGBuf.CopyDoubleGrayIMGBuf >> "
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}
		
		try {
			SourceGrayIMGBuf_height = GetSizeIMG.getHeight(SourceGrayIMGBuf);
			SourceGrayIMGBuf_width = GetSizeIMG.getWidth(SourceGrayIMGBuf);
			TargetGrayIMGBuf = InitIMGBuf.DoubleIMGBuf(SourceGrayIMGBuf_height, SourceGrayIMGBuf_width);
			
			//copy
			for(i=0; i<SourceGrayIMGBuf_height; i++)
			{
				System.arraycopy(SourceGrayIMGBuf[i], 0, TargetGrayIMGBuf[i], 0, SourceGrayIMGBuf_width);
			}	
		} 
		catch (Exception e) 
		{
			throw new ImageGSException("CopyIMGBuf.CopyShortGrayIMGBuf >> "
				+ e.getMessage() ); 			
		}		
		return TargetGrayIMGBuf;
	
	}

   /**
     * Copy to Source GrayIMGBuf  from Target GrayIMGBuf (double -> integer).<p>
     * 
     * short Ÿ   GrayIMGBuf  short Ÿ   GrayIMGBuf Ѵ. <p>
     * 
     * @param	SourceGrayIMG	 GrayIMG  for double type
     * @return    SourceGrayIMG   for integer type
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static int [][] CopyDouble2IntegerGrayIMGBuf (double[][] SourceGrayIMGBuf) throws  ImageGSException	
	{
		int[][] TargetGrayIMGBuf = null;
		int SourceGrayIMGBuf_height;
		int SourceGrayIMGBuf_width;
		int i, j;
		
		if(SourceGrayIMGBuf == null) {
			throw new ImageGSException("CopyIMGBuf.CopyDouble2IntegerGrayIMGBuf >>  " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}
		
		try {
			SourceGrayIMGBuf_height = GetSizeIMG.getHeight(SourceGrayIMGBuf);
			SourceGrayIMGBuf_width = GetSizeIMG.getWidth(SourceGrayIMGBuf);
			TargetGrayIMGBuf = InitIMGBuf.IntegerIMGBuf(SourceGrayIMGBuf_height, SourceGrayIMGBuf_width);
			
			//copy
			for(i=0; i<SourceGrayIMGBuf_height; i++)
			{
				for(j=0; j<SourceGrayIMGBuf_width; j++)
				{
					TargetGrayIMGBuf[i][j] = (int)SourceGrayIMGBuf[i][j];	
				}	
			}
		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("CopyIMGBuf.CopyDouble2IntegerGrayIMGBuf >> "
					+ e.getMessage() ); 			
		}
		
		return TargetGrayIMGBuf;
	}
	
    /**
     * Copy to Source GrayIMGBuf  from Target GrayIMGBuf (double -> short).<p>
     * 
     * short Ÿ   GrayIMGBuf  short Ÿ   GrayIMGBuf Ѵ. <p>
     * 
     * @param	SourceGrayIMG	 GrayIMG  for double type
     * @return    SourceGrayIMG   for short type
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static short [][] CopyDouble2ShortGrayIMGBuf (double[][] SourceGrayIMGBuf) throws  ImageGSException	
	{
		short[][] TargetGrayIMGBuf = null;
		int SourceGrayIMGBuf_height;
		int SourceGrayIMGBuf_width;
		int i, j;
		
		if(SourceGrayIMGBuf == null) {
			throw new ImageGSException("CopyIMGBuf.CopyDouble2ShortGrayIMGBuf >>  " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}
		
		try {
			SourceGrayIMGBuf_height = GetSizeIMG.getHeight(SourceGrayIMGBuf);
			SourceGrayIMGBuf_width = GetSizeIMG.getWidth(SourceGrayIMGBuf);
			TargetGrayIMGBuf = InitIMGBuf.ShortIMGBuf(SourceGrayIMGBuf_height, SourceGrayIMGBuf_width);
			
			//copy
			for(i=0; i<SourceGrayIMGBuf_height; i++)
			{
				for(j=0; j<SourceGrayIMGBuf_width; j++)
				{
					TargetGrayIMGBuf[i][j] = (short)SourceGrayIMGBuf[i][j];	
				}	
			}
		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("CopyIMGBuf.CopyShortGrayIMGBuf >> "
				+ e.getMessage() ); 			
		}
		
		return TargetGrayIMGBuf;
	}

    /**
     * Copy to Source GrayIMGBuf  from Target GrayIMGBuf, both short type. (integer -> integer).<p>
     * 
     * integer Ÿ   GrayIMGBuf  integer Ÿ   GrayIMGBuf Ѵ. <p>
     * 
     * @param	SourceGrayIMG	 GrayIMG  for integer type
     * @return    SourceGrayIMG   for integer type
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static int [][] CopyIntegerGrayIMGBuf (int[][] SourceGrayIMGBuf) throws  ImageGSException	
	{
		int[][] TargetGrayIMGBuf = null;
		int SourceGrayIMGBuf_height;
		int SourceGrayIMGBuf_width;
		int i, j;
		
		if(SourceGrayIMGBuf == null) {
			throw new ImageGSException("CopyIMGBuf.CopyIntegerGrayIMGBuf >> "
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}
		
		try {
			SourceGrayIMGBuf_height = GetSizeIMG.getHeight(SourceGrayIMGBuf);
			SourceGrayIMGBuf_width = GetSizeIMG.getWidth(SourceGrayIMGBuf);
			TargetGrayIMGBuf = InitIMGBuf.IntegerIMGBuf(SourceGrayIMGBuf_height, SourceGrayIMGBuf_width);
			
			//copy
			for(i=0; i<SourceGrayIMGBuf_height; i++)
			{
				System.arraycopy(SourceGrayIMGBuf[i], 0, TargetGrayIMGBuf[i], 0, SourceGrayIMGBuf_width);
			}
		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("CopyIMGBuf.CopyIntegerGrayIMGBuf >> "
				+ e.getMessage() ); 			
		}
		
		return TargetGrayIMGBuf;
	}

    /**
     * Copy to Source GrayIMGBuf  from Target GrayIMGBuf (integer -> double).<p>
     * 
     * short Ÿ   GrayIMGBuf  short Ÿ   GrayIMGBuf Ѵ. <p>
     * 
     * @param	SourceGrayIMG	 GrayIMG  for integer type
     * @return    SourceGrayIMG   for double type
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static double [][] CopyInteger2DoubleGrayIMGBuf (int[][] SourceGrayIMGBuf) throws  ImageGSException	
	{
		double[][] TargetGrayIMGBuf = null;
		int SourceGrayIMGBuf_height;
		int SourceGrayIMGBuf_width;
		int i, j;
		
		if(SourceGrayIMGBuf == null) {
			throw new ImageGSException("CopyIMGBuf.CopyInteger2DoubleGrayIMGBuf >>  " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}
		
		try {
			SourceGrayIMGBuf_height = GetSizeIMG.getHeight(SourceGrayIMGBuf);
			SourceGrayIMGBuf_width = GetSizeIMG.getWidth(SourceGrayIMGBuf);
			TargetGrayIMGBuf = InitIMGBuf.DoubleIMGBuf(SourceGrayIMGBuf_height, SourceGrayIMGBuf_width);
			
			//copy
			for(i=0; i<SourceGrayIMGBuf_height; i++)
			{
				for(j=0; j<SourceGrayIMGBuf_width; j++)
				{
					TargetGrayIMGBuf[i][j] = (double)SourceGrayIMGBuf[i][j];	
				}	
			}
		} 
		catch (Exception e)
		{
			throw new ImageGSException("CopyIMGBuf.CopyIntegerGrayIMGBuf >> "
				+ e.getMessage() ); 			
		}		
		
		return TargetGrayIMGBuf;
	}

    /**
     * Copy to Source GrayIMGBuf  from Target GrayIMGBuf (integer -> short).<p>
     * 
     * short Ÿ   GrayIMGBuf  short Ÿ   GrayIMGBuf Ѵ. <p>
     * 
     * @param	SourceGrayIMG	 GrayIMG  for integer type
     * @return    SourceGrayIMG   for short type
     * @exception ImageGSException SourceGrayIMGBuf ϶
     */
	public static short [][] CopyInteger2ShortGrayIMGBuf (int[][] SourceGrayIMGBuf)
											throws  ImageGSException	
	{
		short[][] TargetGrayIMGBuf = null;
		int SourceGrayIMGBuf_height;
		int SourceGrayIMGBuf_width;
		int i, j;
		
		if(SourceGrayIMGBuf == null) {
			throw new ImageGSException("CopyIMGBuf.CopyInteger2ShortGrayIMGBuf >>  " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 
		}
		
		try {
			SourceGrayIMGBuf_height = GetSizeIMG.getHeight(SourceGrayIMGBuf);
			SourceGrayIMGBuf_width = GetSizeIMG.getWidth(SourceGrayIMGBuf);
			TargetGrayIMGBuf = InitIMGBuf.ShortIMGBuf(SourceGrayIMGBuf_height, SourceGrayIMGBuf_width);
			
			//copy
			for(i=0; i<SourceGrayIMGBuf_height; i++)
			{
				for(j=0; j<SourceGrayIMGBuf_width; j++)
				{
					TargetGrayIMGBuf[i][j] = (short)SourceGrayIMGBuf[i][j];	
				}	
			}
		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("CopyIMGBuf.CopyInteger2ShortGrayIMGBuf >> "
				+ e.getMessage() ); 			
		}
		
		return TargetGrayIMGBuf;
	}
	
}
