/**
 * Class Name	: Conv2
 * Description	: ȸ(convolution)  Ŭ
 * Date 				: 2003/06/10
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/09/03 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * ȸ  short[][] Ǵ double[][]  ǵش. <p>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public final class Conv2
{
	
	/**
	 * 
	 */
	private Conv2() {}
	

    /**
     * Convolution Operation for short type, mask is integer type
     *
     * @param	GrayIMG	 GrayIMG  for short type
     * @param	Mask		ũ , integer type
     * @return    ȸ   for short type
     * @exception ImageGSException Method  ùٸ 
     */
	public static short [][] Conv2OP (short[][] GrayIMG, int[][] Mask) throws  ImageGSException
	{
	    /**
	     *    
	     */
		short[][] ResultIMG = null;  //  
	
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2OP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = (Mask[Mask_height-1]).length;
				
		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		//   ResultIMG  ޸ Ҵ
		ResultIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height, GrayIMG_width);
		
		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;

				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var += (double)GrayIMG[i+m][j+n]*(double)Mask[m][n];
					}
				}
				
				// clamping with Saturation
                ResultIMG[i][j] = Clamping.ShortSaturation(var);
				
			}
		}					

		return ResultIMG;
	}

   /**
     * convolution Operation for short type, mask is double type
     *
     * @param	GrayIMG	 GrayIMG  for short type
     * @param	Mask		ũ , double type
     * @return    ȸ  
     * @exception ImageGSException Method  ùٸ 
     */
	public static short [][] Conv2OP (short[][] GrayIMG, double[][] Mask) throws ImageGSException
	{

	    /**
	     *    
	     */
		short[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2OP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
				
		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		//   ResultIMG  ޸ Ҵ
		ResultIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height, GrayIMG_width);
	
		// convolution
		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var += (double)GrayIMG[i+m][j+n]*Mask[m][n];
					}
				}
				
				// clamping with Saturation
                ResultIMG[i][j] = Clamping.ShortSaturation(var);	
			}
		}					

		return ResultIMG;
	}

  /**
     * convolution Operation for double type, mask is double type
     *
     * @param	GrayIMG	 GrayIMG  for double type
     * @param	Mask		ũ , double type
     * @return    ȸ  
     * @exception ImageGSException Method  ùٸ 
     */
	public static double[][] Conv2OP (double[][] GrayIMG, double[][] Mask) throws ImageGSException
	{
	    /**
	     *    
	     */
		double[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) {
			throw new ImageGSException("Conv2.Conv2OP() >>  " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
				

		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		//   ResultIMG  ޸ Ҵ
		ResultIMG = InitIMGBuf.DoubleIMGBuf(GrayIMG_height, GrayIMG_width);

		// convolution
		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var += GrayIMG[i+m][j+n]*Mask[m][n];
					}
				}
				
				// clamping with Saturation
                ResultIMG[i][j] = Clamping.DoubleSaturation(var);	
			}
		}					

		return ResultIMG;
	}

    /**
     * Convolution Operation for short type, mask is integer type.<br>
     * ȸ    κ   ȭҰ Ѵ.<p>
     *
     * @param	GrayIMG	 GrayIMG  for short type
     * @param	Mask		ũ , integer type
     * @return    ȸ   for short type
     * @exception ImageGSException Method  ùٸ 
     */
	public static short [][] Conv2CopyOP (short[][] GrayIMG, int[][] Mask) throws  ImageGSException
	{
	    /**
	     *    
	     */
		short[][] ResultIMG = null;  //  
	
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2CopyOP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = (Mask[Mask_height-1]).length;
				
		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		try {
			ResultIMG = CopyIMGBuf.CopyShortGrayIMGBuf(GrayIMG);
		} 
		catch (ImageGSException e)
		{
			throw e;			
		}
		
		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;

				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var += (double)GrayIMG[i+m][j+n]*(double)Mask[m][n];
					}
				}
				
				// clamping with Saturation
                ResultIMG[i][j] = Clamping.ShortSaturation(var);
				
			}
		}					

		return ResultIMG;
	}

   /**
     * convolution Operation for short type, mask is double type. <br>
     * ȸ    κ   ȭҰ Ѵ.<p>
     * 
     * @param	GrayIMG	 GrayIMG  for short type
     * @param	Mask		ũ , double type
     * @return    ȸ  
     * @exception ImageGSException Method  ùٸ 
     */
	public static short [][] Conv2CopyOP (short[][] GrayIMG, double[][] Mask) throws ImageGSException
	{

	    /**
	     *    
	     */
		short[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2CopyOP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
				
		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		try {
			ResultIMG = CopyIMGBuf.CopyShortGrayIMGBuf(GrayIMG);
		} 
		catch (ImageGSException e)
		{
			throw e;		
		}
		
		// convolution
		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var += (double)GrayIMG[i+m][j+n]*Mask[m][n];
					}
				}
				
				// clamping with Saturation
                ResultIMG[i][j] = Clamping.ShortSaturation(var);	
			}
		}					

		return ResultIMG;
	}

  /**
     * convolution Operation for double type, mask is double type.<br>
     * ȸ    κ   ȭҰ Ѵ. <p>
     *
     * @param	GrayIMG	 GrayIMG  for double type
     * @param	Mask		ũ , double type
     * @return    ȸ  
     * @exception ImageGSException Method  ùٸ 
     */
	public static double[][] Conv2CopyOP (double[][] GrayIMG, double[][] Mask) throws ImageGSException
	{

	    /**
	     *    
	     */
		double[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) {
			throw new ImageGSException("Conv2.Conv2CopyOP() >>  " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
				

		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		try {
			ResultIMG = CopyIMGBuf.CopyDoubleGrayIMGBuf(GrayIMG);
		} 
		catch (ImageGSException e)
		{
			throw e;
		}
		
		// convolution
		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var += GrayIMG[i+m][j+n]*Mask[m][n];
					}
				}
				
				// clamping with Saturation
                ResultIMG[i][j] = Clamping.DoubleSaturation(var);	
			}
		}					

		return ResultIMG;
	}
	
  /**
     * convolution Operation for short type, mask is integer type. <br>
     * ȸ  ߾ ̰ Ѵ.<p>
     *
     * @param	GrayIMG	 GrayIMG  for short type
     * @param	Mask		ũ , int type
     * @return    ȸ  
     * @exception ImageGSException Method  ùٸ 
     */
	public static short [][] Conv2CenterOP (short[][] GrayIMG, int[][] Mask) throws ImageGSException
	{

	    /**
	     *    
	     */
		short[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2CenterOP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
		int half_height = (int)Math.round(Mask_height/2.0); 
		int half_width = (int)Math.round(Mask_width/2.0); 
				
		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		//   ResultIMG  ޸ Ҵ
		ResultIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height, GrayIMG_width);
		
		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				// block ´.
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var  += (double)(GrayIMG[i+m][j+n]*Mask[m][n]);
					}
				}
				
				// clamping with Saturation
				ResultIMG[i + half_height][j + half_width] =  Clamping.ShortSaturation(var);	
				
			}	
		}
		
		return ResultIMG;
	}
	
  /**
     * convolution Operation for short type, mask is double type. <br>
     * ȸ  ߾ ̰ Ѵ.<p>
     *
     * @param	GrayIMG	 GrayIMG  for short type
     * @param	Mask		ũ , double type
     * @return    ȸ  
     * @exception ImageGSException Method  ùٸ 
     */
	public static short [][] Conv2CenterOP (short[][] GrayIMG, double[][] Mask) throws ImageGSException
	{

	    /**
	     *    
	     */
		short[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2CenterOP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
		int half_height = (int)Math.round(Mask_height/2.0); 
		int half_width = (int)Math.round(Mask_width/2.0); 

		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		//   ResultIMG  ޸ Ҵ
		ResultIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height, GrayIMG_width);

		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				// block ´.
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var  += (double)GrayIMG[i+m][j+n]*Mask[m][n];
					}
				}
				
				// clamping with Saturation
				ResultIMG[i + half_height][j + half_width] =  Clamping.ShortSaturation(var);	
				
			}	
		}
		
		return ResultIMG;
	}

	/**
     * convolution Operation for double type, mask is double type. <br>
     * ȸ  ߾ ̰ Ѵ.<p>
     *
     * @param	GrayIMG	 GrayIMG  for double type
     * @param	Mask		ũ , double type
     * @return    ȸ  
     * @exception ImageGSException Method  ùٸ 
     */
	public static double [][] Conv2CenterOP (double[][] GrayIMG, double[][] Mask) throws ImageGSException
	{

	    /**
	     *    
	     */
		double[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2CenterOP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
		int half_height = (int)Math.round(Mask_height/2.0); 
		int half_width = (int)Math.round(Mask_width/2.0); 
				
		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		//   ResultIMG  ޸ Ҵ
		ResultIMG = InitIMGBuf.DoubleIMGBuf(GrayIMG_height, GrayIMG_width);

		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				// block ´.
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var  += GrayIMG[i+m][j+n]*Mask[m][n];
					}
				}
				
				// clamping with Saturation
				ResultIMG[i + half_height][j + half_width] =  Clamping.DoubleSaturation(var);	
				
			}	
		}
		
		return ResultIMG;
	}

  /**
     * convolution Operation for short type, mask is integer type. <br>
     * ȸ  ߾ ̰ Ѵ.<br>
     * ⼭, ȸ    κ   ȭҰ Ѵ.<p>
     *
     * @param	GrayIMG	 GrayIMG  for short type
     * @param	Mask		ũ , int type
     * @return    ȸ  
     * @exception ImageGSException Method  ùٸ 
     */
	public static short [][] Conv2CenterCopyOP (short[][] GrayIMG, int[][] Mask) throws ImageGSException
	{

	    /**
	     *    
	     */
		short[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2CenterCopyOP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
		int half_height = (int)Math.round(Mask_height/2.0); 
		int half_width = (int)Math.round(Mask_width/2.0); 
				
		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
		
		try 
		{
			ResultIMG = CopyIMGBuf.CopyShortGrayIMGBuf(GrayIMG);
		} 
		catch (ImageGSException e)
		{
			throw e;		
		}

		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				// block ´.
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var  += (double)(GrayIMG[i+m][j+n]*Mask[m][n]);
					}
				}
				
				// clamping with Saturation
				ResultIMG[i + half_height][j + half_width] =  Clamping.ShortSaturation(var);	
				
			}	
		}
		
		return ResultIMG;
	}
	
  /**
     * convolution Operation for short type, mask is double type. <br>
     * ȸ  ߾ ̰ Ѵ.<br>
     * ⼭, ȸ    κ   ȭҰ Ѵ.<p>
     *
     * @param	GrayIMG	 GrayIMG  for short type
     * @param	Mask		ũ , double type
     * @return    ȸ  
     * @exception ImageGSException Method  ùٸ 
     */
	public static short [][] Conv2CenterCopyOP (short[][] GrayIMG, double[][] Mask) throws ImageGSException
	{

	    /**
	     *    
	     */
		short[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2CenterCopyOP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
		int half_height = (int)Math.round(Mask_height/2.0); 
		int half_width = (int)Math.round(Mask_width/2.0); 

		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		try 
		{
			ResultIMG = CopyIMGBuf.CopyShortGrayIMGBuf(GrayIMG);
	
		} 
		catch (ImageGSException e)
		{
			throw e;		
		}

		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				// block ´.
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var  += (double)GrayIMG[i+m][j+n]*Mask[m][n];
					}
				}
				
				// clamping with Saturation
				ResultIMG[i + half_height][j + half_width] =  Clamping.ShortSaturation(var);	
				
			}	
		}
		
		return ResultIMG;
	}

	/**
     * convolution Operation for double type, mask is double type. <br>
     * ȸ  ߾ ̰ Ѵ.<br>
     * ⼭, ȸ    κ   ȭҰ Ѵ.<p>
     *
     * @param	GrayIMG	 GrayIMG  for double type
     * @param	Mask		ũ , double type
     * @return    ȸ  
     * @exception ImageGSException Method  ùٸ 
     */
	public static double [][] Conv2CenterCopyOP (double[][] GrayIMG, double[][] Mask) throws ImageGSException
	{

	    /**
	     *    
	     */
		double[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2CenterCopyOP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
		int half_height = (int)Math.round(Mask_height/2.0); 
		int half_width = (int)Math.round(Mask_width/2.0); 
				
		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		try 
		{
			ResultIMG = CopyIMGBuf.CopyDoubleGrayIMGBuf(GrayIMG);
		} 
		catch (ImageGSException e)
		{
			throw e;		
		}

		for(i=0; i<GrayIMG_height - Mask_height; i++)
		{
			for(j=0; j<GrayIMG_width - Mask_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				// block ´.
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var  += GrayIMG[i+m][j+n]*Mask[m][n];
					}
				}
				
				// clamping with Saturation
				ResultIMG[i + half_height][j + half_width] =  Clamping.DoubleSaturation(var);	
				
			}	
		}
		
		return ResultIMG;
	}


	/**
	 * Convolution Operation for short type, mask is integer type.<p>
	 * 
	 * ȸ ׵θ ֹ.<p>
	 * 
	 * @param	GrayIMG	 GrayIMG  for short type
	 * @param	Mask		ũ , integer type
	 * @return    ȸ   for short type
	 * @exception ImageGSException Method  ùٸ 
	 */
	public static short [][] Conv2DeleteOP (short[][] GrayIMG, int[][] Mask) throws  ImageGSException
	{
		/**
		 *    
		 */
		short[][] ResultIMG = null;  //  
	
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2OP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = (Mask[Mask_height-1]).length;
				
		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		//   ResultIMG  ޸ Ҵ
		short[][] tmpIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height+Mask_height, GrayIMG_width+Mask_width);
		
		for(i=0; i<GrayIMG_height; i++)
		{
			for(j=0; j<GrayIMG_width; j++)
			{
				tmpIMG[i][j] = GrayIMG[i][j]; 
			}
		}
		
		ResultIMG = InitIMGBuf.ShortIMGBuf( GrayIMG_height, GrayIMG_width );
				
		for(i=0; i<GrayIMG_height; i++)
		{
			for(j=0; j<GrayIMG_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var += (double)tmpIMG[i+m][j+n]*(double)Mask[m][n];
					}
				}
				
				// clamping with Saturation
				ResultIMG[i][j] = Clamping.ShortSaturation(var);
				
			}
		}					

		return ResultIMG;
	}

   /**
	 * convolution Operation for short type, mask is double type. <p>
	 * 
	 * ȸ ׵θ ֹ.<p>
	 * 
	 * @param	GrayIMG	 GrayIMG  for short type
	 * @param	Mask		ũ , double type
	 * @return    ȸ  
	 * @exception ImageGSException Method  ùٸ 
	 */
	public static short [][] Conv2DeleteOP (short[][] GrayIMG, double[][] Mask) throws ImageGSException
	{

		/**
		 *    
		 */
		short[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) 
		{
			throw new ImageGSException("Conv2.Conv2OP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
				
		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		//   ResultIMG  ޸ Ҵ
		short[][] tmpIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height+Mask_height, GrayIMG_width+Mask_width);
		
		for(i=0; i<GrayIMG_height; i++)
		{
			for(j=0; j<GrayIMG_width; j++)
			{
				tmpIMG[i][j] = GrayIMG[i][j]; 
			}
		}
		
		ResultIMG = InitIMGBuf.ShortIMGBuf( GrayIMG_height, GrayIMG_width );
				
		for(i=0; i<GrayIMG_height; i++)
		{
			for(j=0; j<GrayIMG_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var += (double)tmpIMG[i+m][j+n]*Mask[m][n];
					}
				}
				
				// clamping with Saturation
				ResultIMG[i][j] = Clamping.ShortSaturation(var);	
			}
		}					

		return ResultIMG;
	}

  /**
	 * convolution Operation for double type, mask is double type.<p>
	 * 
	 * ȸ ׵θ ֹ.<p>
	 * 
	 * @param	GrayIMG	 GrayIMG  for double type
	 * @param	Mask		ũ , double type
	 * @return    ȸ  
	 * @exception ImageGSException Method  ùٸ 
	 */
	public static double[][] Conv2DeleteOP (double[][] GrayIMG, double[][] Mask) throws ImageGSException
	{

		/**
		 *    
		 */
		double[][] ResultIMG = null;  //  
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;
		
		// null   ܻȲ .
		if(GrayIMG == null || Mask == null) {
			throw new ImageGSException("Conv2.Conv2OP() >>  " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
		
		// Mask ̿ ʺ ˾Ƴ.
		int Mask_height  = Mask.length;		
		int Mask_width = Mask[Mask_height-1].length;
				

		// ش ϵ  , ʺ Ѵ.
		int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
		int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
				
		//   ResultIMG  ޸ Ҵ
		double[][] tmpIMG = InitIMGBuf.DoubleIMGBuf(GrayIMG_height+Mask_height, GrayIMG_width+Mask_width);
		
		for(i=0; i<GrayIMG_height; i++)
		{
			for(j=0; j<GrayIMG_width; j++)
			{
				tmpIMG[i][j] = GrayIMG[i][j]; 
			}
		}
		
		ResultIMG = InitIMGBuf.DoubleIMGBuf( GrayIMG_height, GrayIMG_width );
				
		for(i=0; i<GrayIMG_height; i++)
		{
			for(j=0; j<GrayIMG_width; j++)
			{
				// ʱȭ
				var = 0.0;
				
				for(m=0; m<Mask_height; m++)
				{
					for(n=0; n<Mask_width; n++)
					{
						var += tmpIMG[i+m][j+n]*Mask[m][n];
					}
				}
				
				// clamping with Saturation
				ResultIMG[i][j] = Clamping.DoubleSaturation(var);	
			}
		}					

		return ResultIMG;
	}
}
