/**
 * Class Name	: CenterIMGBuf
 * Description	:    ۳     ο  ۸ ȯѴ.
 * Date 				: 2003/05/10
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/05/10 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * Է  ۳     ο  ۸ ȯѴ.<p>
 * 
 *  API  ȸ    , Ʒ  ˰ ĥ   <br>
 *  ׵θ ˰ ĥϵ,     ġ Ű Ҷ ϶.<p>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class CenterIMGBuf
{
	private CenterIMGBuf() {}
	
	/**
	 * Է  ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
     * @param Image 	  
	 * @param pixels	ȼ ũ 
	 * @return short type   ۸ ȯ
	 */	
	public static short[][] CenterShortGrayIMGBuf(short[][] Image, int pixels) throws ImageGSException
	{
		return CenterShortGrayIMGBuf(Image, pixels, pixels);
	}
	
	/**
	 * Է  ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ, Ʒ ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
     * @param Image 	  
	 * @param right_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return short type   ۸ ȯ
	 */	
	public static short[][] CenterShortGrayIMGBuf(short[][] Image, int right_pixels, int bottom_pixels) throws ImageGSException
	{
		int height = GetSizeIMG.getHeight(Image);
		int width = GetSizeIMG.getWidth(Image);
		
		if(Image == null)
		{
			throw new ImageGSException("CenterIMGBuf.CenterShortGrayIMGBuf() >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
			
		if(right_pixels <0 || bottom_pixels <0) return null;
		
		short[][] retImage = FillIMGBuf.FillShortGrayIMGBuf((short)0, height, width);
				
		int half_height = (int)Math.round(right_pixels/2.0); 
		int half_width = (int)Math.round(bottom_pixels/2.0); 
	
		for(int i=0; i<height-right_pixels; i++)
		{
			for(int j=0; j<width-bottom_pixels; j++)
			{
				retImage[i + half_height][j + half_width] =  Image[i][j];	
			}	
		}

		return retImage;
	}

	/**
	 * Է  ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param Image 	  
	 * @param pixels	ȼ ũ 
	 * @return integer type   ۸ ȯ
	 */	
	public static int[][] CenterIntegerGrayIMGBuf(int[][] Image, int pixels) throws ImageGSException
	{
		return CenterIntegerGrayIMGBuf(Image, pixels, pixels);
	}
	
	/**
	 * Է  ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ, Ʒ ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param Image 	  
	 * @param right_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return integer type   ۸ ȯ
	 */	
	public static int[][] CenterIntegerGrayIMGBuf(int[][] Image, int right_pixels, int bottom_pixels) throws ImageGSException
	{
		int height = GetSizeIMG.getHeight(Image);
		int width = GetSizeIMG.getWidth(Image);
		
		if(Image == null)
		{
			throw new ImageGSException("CenterIMGBuf.CenterShortGrayIMGBuf() >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
			
		if(right_pixels <0 || bottom_pixels <0) return null;
		
		int[][] retImage = FillIMGBuf.FillIntegerGrayIMGBuf((short)0, height, width);
				
		int half_height = (int)Math.round(right_pixels/2.0); 
		int half_width = (int)Math.round(bottom_pixels/2.0); 
	
		for(int i=0; i<height-right_pixels; i++)
		{
			for(int j=0; j<width-bottom_pixels; j++)
			{
				retImage[i + half_height][j + half_width] =  Image[i][j];	
			}	
		}

		return retImage;
	}
			
	/**
	 * Է  ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
     * @param Image 	  
	 * @param pixels	ȼ ũ 
	 * @return double type   ۸ ȯ
	 */	
	public static double[][] CenterDoubleGrayIMGBuf(double[][] Image, int pixels) throws ImageGSException
	{
		return CenterDoubleGrayIMGBuf(Image, pixels, pixels);
	}
	
	/**
	 * Է  ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ, Ʒ ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
     * @param Image 	  
	 * @param right_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return double type   ۸ ȯ
	 */	
	public static double[][] CenterDoubleGrayIMGBuf(double[][] Image, int right_pixels, int bottom_pixels) throws ImageGSException
	{
		int height = GetSizeIMG.getHeight(Image);
		int width = GetSizeIMG.getWidth(Image);
		
		if(Image == null)
		{
			throw new ImageGSException("CenterIMGBuf.CenterDoubleGrayIMGBuf() >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
			
		if(right_pixels <0 || bottom_pixels <0) return null;

		double [][] retImage = FillIMGBuf.FillDoubleGrayIMGBuf((short)0, height, width);


		int half_height = (int)Math.round(right_pixels/2.0); 
		int half_width = (int)Math.round(bottom_pixels/2.0); 
	
		for(int i=0; i<height-right_pixels; i++)
		{
			for(int j=0; j<width-bottom_pixels; j++)
			{
				retImage[i + half_height][j + half_width] =  Image[i][j];	
			}	
		}

		return retImage;
	}
}
