/**
 * Class Name	: BoundaryIMG 
 * Description	: boundary  Ǵ ߰
 * Date 				: 2002/10/07
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/07 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.*;

/**
 * Boundary ߰/ <p>
 * 
 *  ó ӽ  ũ⸦  ȼŭ ߰/ Ѵ.<p>
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public final class BoundaryIMGBuf
{
	private BoundaryIMGBuf() {};

	/**
	 *  ۸ ϵ, , Ʒ right_pixels, bottom_pixels ŭ 0  ä ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param right_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return   ũ + (right_pixels, bottom_pixels) => ο ũ 
	 * @exception ImageGSException
	 */
	public static short[][] add(short[][] IMGBuf, int right_pixels, int bottom_pixels) 
		throws ImageGSException
	{
		short[][] ResultIMG = null;		
		int IMGBuf_height = 0;
		int IMGBuf_width = 0;
		int i, j;
		
		if(IMGBuf == null)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> IMGBuf is null !!");			
		}
		
		if(right_pixels <0 || bottom_pixels < 0)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> pixels is zero or negative !!");				
		} 

		IMGBuf_height = IMGBuf.length;
		IMGBuf_width = IMGBuf[IMGBuf_height-1].length;
		
			
		ResultIMG = (short [][]) InitIMGBuf.ShortIMGBuf(IMGBuf_height + right_pixels, IMGBuf_width + bottom_pixels);
		
		for(i=0; i<IMGBuf_height; i++)
			for(j=0; j<IMGBuf_width; j++)
				ResultIMG[i][j] = IMGBuf[i][j];

		return ResultIMG;			
	}
		
	/**
	 *  ۸ ϵ, , Ʒ pixels ŭ 0  ä ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param pixels	ȼ ũ
	 * @return   ũ + pixels => ο ũ 
	 * @exception ImageGSException
	 */
	public static short[][] add(short[][] IMGBuf, int pixels) throws ImageGSException
	{
		return add(IMGBuf, pixels, pixels);
	} 
	

	/**
	 *  ۸ ϵ, , Ʒ right_pixels, bottom_pixels ŭ  ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param right_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return   ũ + (right_pixels, bottom_pixels) => ο ũ 
	 * @exception ImageGSException
	 */
	public static short[][] delete(short[][] IMGBuf, int right_pixels, int bottom_pixels) 
		throws ImageGSException
	{
		short[][] ResultIMG = null;		
		int IMGBuf_height = 0;
		int IMGBuf_width = 0;
		int i, j;
		
		if(IMGBuf == null)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> IMGBuf is null !!");			
		}
		
		if(right_pixels <0 || bottom_pixels < 0)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> pixels is zero or negative !!");				
		} 

		IMGBuf_height = IMGBuf.length;
		IMGBuf_width = IMGBuf[IMGBuf_height-1].length;
			
		ResultIMG = (short [][]) InitIMGBuf.ShortIMGBuf(IMGBuf_height - right_pixels, IMGBuf_width - bottom_pixels);
		
		for(i=0; i<IMGBuf_height-right_pixels; i++)
			for(j=0; j<IMGBuf_width-bottom_pixels; j++)
				ResultIMG[i][j] = IMGBuf[i][j];

		return ResultIMG;				
	}
	
	/**
	 *  ۸ ϵ, , Ʒ pixels ŭ  ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param pixels	ȼ ũ
	 * @return   ũ - pixels => ο ũ 
	 * @exception ImageGSException
	 */
	public static short[][] delete(short[][] IMGBuf, int pixels) throws ImageGSException
	{
		return delete(IMGBuf, pixels, pixels);
	}
	
	/**
	 *  ۸ ϵ, , Ʒ right_pixels, bottom_pixels ŭ 0  ä ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param right_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return   ũ + (right_pixels, bottom_pixels) => ο ũ 
	 * @exception ImageGSException
	 */
	public static double[][] add(double[][] IMGBuf, int right_pixels, int bottom_pixels) 
		throws ImageGSException
	{
		double[][] ResultIMG = null;		
		int IMGBuf_height = 0;
		int IMGBuf_width = 0;
		int i, j;
		
		if(IMGBuf == null)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> IMGBuf is null !!");			
		}
		
		if(right_pixels <0 || bottom_pixels < 0)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> pixels is zero or negative !!");				
		} 

		IMGBuf_height = IMGBuf.length;
		IMGBuf_width = IMGBuf[IMGBuf_height-1].length;
		
			
		ResultIMG = (double [][]) InitIMGBuf.DoubleIMGBuf(IMGBuf_height + right_pixels, IMGBuf_width + bottom_pixels);
		
		for(i=0; i<IMGBuf_height; i++)
			for(j=0; j<IMGBuf_width; j++)
				ResultIMG[i][j] = IMGBuf[i][j];

		return ResultIMG;			
	}
		
	/**
	 *  ۸ ϵ, , Ʒ pixels ŭ 0  ä ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param pixels	ȼ ũ
	 * @return   ũ + pixels => ο ũ 
	 * @exception ImageGSException
	 */
	public static double[][] add(double[][] IMGBuf, int pixels) throws ImageGSException
	{
		return add(IMGBuf, pixels, pixels);
	} 
	

	/**
	 *  ۸ ϵ, , Ʒ right_pixels, bottom_pixels ŭ  ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param right_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return   ũ + (right_pixels, bottom_pixels) => ο ũ 
	 * @exception ImageGSException
	 */
	public static double[][] delete(double[][] IMGBuf, int right_pixels, int bottom_pixels) 
		throws ImageGSException
	{
		double[][] ResultIMG = null;		
		int IMGBuf_height = 0;
		int IMGBuf_width = 0;
		int i, j;
		
		if(IMGBuf == null)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> IMGBuf is null !!");			
		}
		
		if(right_pixels <0 || bottom_pixels < 0)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> pixels is zero or negative !!");				
		} 

		IMGBuf_height = IMGBuf.length;
		IMGBuf_width = IMGBuf[IMGBuf_height-1].length;
			
		ResultIMG = (double [][]) InitIMGBuf.DoubleIMGBuf(IMGBuf_height - right_pixels, IMGBuf_width - bottom_pixels);
		
		for(i=0; i<IMGBuf_height-right_pixels; i++)
			for(j=0; j<IMGBuf_width-bottom_pixels; j++)
				ResultIMG[i][j] = IMGBuf[i][j];

		return ResultIMG;				
	}
	
	/**
	 *  ۸ ϵ, , Ʒ pixels ŭ  ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param pixels	ȼ ũ
	 * @return   ũ - pixels => ο ũ 
	 * @exception ImageGSException
	 */
	public static double[][] delete(double[][] IMGBuf, int pixels) throws ImageGSException
	{
		return delete(IMGBuf, pixels, pixels);
	}

	/**
	 *  ۸ ϵ, , Ʒ right_pixels, bottom_pixels ŭ 0  ä ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param right_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return   ũ + (right_pixels, bottom_pixels) => ο ũ 
	 * @exception ImageGSException
	 */
	public static int[][] add(int[][] IMGBuf, int right_pixels, int bottom_pixels) 
		throws ImageGSException
	{
		int[][] ResultIMG = null;		
		int IMGBuf_height = 0;
		int IMGBuf_width = 0;
		int i, j;
		
		if(IMGBuf == null)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> IMGBuf is null !!");			
		}
		
		if(right_pixels <0 || bottom_pixels < 0)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> pixels is zero or negative !!");				
		} 

		IMGBuf_height = IMGBuf.length;
		IMGBuf_width = IMGBuf[IMGBuf_height-1].length;
		
			
		ResultIMG = (int [][]) InitIMGBuf.IntegerIMGBuf(IMGBuf_height + right_pixels, IMGBuf_width + bottom_pixels);
		
		for(i=0; i<IMGBuf_height; i++)
			for(j=0; j<IMGBuf_width; j++)
				ResultIMG[i][j] = IMGBuf[i][j];

		return ResultIMG;			
	}
		
	/**
	 *  ۸ ϵ, , Ʒ pixels ŭ 0  ä ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param pixels	ȼ ũ
	 * @return   ũ + pixels => ο ũ 
	 * @exception ImageGSException
	 */
	public static int[][] add(int[][] IMGBuf, int pixels) throws ImageGSException
	{
		return add(IMGBuf, pixels, pixels);
	} 
	

	/**
	 *  ۸ ϵ, , Ʒ right_pixels, bottom_pixels ŭ  ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param right_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return   ũ + (right_pixels, bottom_pixels) => ο ũ 
	 * @exception ImageGSException
	 */
	public static int[][] delete(int[][] IMGBuf, int right_pixels, int bottom_pixels) 
		throws ImageGSException
	{
		int[][] ResultIMG = null;		
		int IMGBuf_height = 0;
		int IMGBuf_width = 0;
		int i, j;
		
		if(IMGBuf == null)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> IMGBuf is null !!");			
		}
		
		if(right_pixels <0 || bottom_pixels < 0)
		{
			//   ErrorMsg class  ʴ´.
			throw new  ImageGSException("BoundaryIMGBuf.add >> pixels is zero or negative !!");				
		} 

		IMGBuf_height = IMGBuf.length;
		IMGBuf_width = IMGBuf[IMGBuf_height-1].length;
			
		ResultIMG = (int [][]) InitIMGBuf.IntegerIMGBuf(IMGBuf_height - right_pixels, IMGBuf_width - bottom_pixels);
		
		for(i=0; i<IMGBuf_height-right_pixels; i++)
			for(j=0; j<IMGBuf_width-bottom_pixels; j++)
				ResultIMG[i][j] = IMGBuf[i][j];

		return ResultIMG;				
	}
	
	/**
	 *  ۸ ϵ, , Ʒ pixels ŭ  ο ũ ۸ ȯ.
	 * 
	 * @param IMGBuf  2 
	 * @param pixels	ȼ ũ
	 * @return   ũ - pixels => ο ũ 
	 * @exception ImageGSException
	 */
	public static int[][] delete(int[][] IMGBuf, int pixels) throws ImageGSException
	{
		return delete(IMGBuf, pixels, pixels);
	}
}
