/**
 * Class Name	: ToRAWGrayImage
 * Description	: JPEG/BMP/PNG/PPM/GIF ÷  gray RAW ȯ.
 * Date 				: 2003/08/30
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/08/30 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * JPEG, BMP, PNG, PPM, GIF ÷ Ÿ  color RAW  ȯѴ.<p>
 * 
 *  JPEG, BMP, PNG, PPM, GIF ÷  ó ӵ  ȴٸ, <br>
 * color RAW  ȯ , RAWImage Բ غ ٶ.<p>
 *
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class ToRAWImage
{
	private final static String fmt = "raw";
	private String src_fname = null;
	private String dest_fname = null;
	private int height = 0;
	private int width = 0;
	
	public ToRAWImage(String src_fname) throws ImageGSException 
	{
		// src_fname ϴ° ˻.
		File fp = new File(src_fname);
		if(fp.exists() == false)
		{
			throw new ImageGSException("ToRAWImage.run() >> " 
				+ ErrorMsg.ERRORTHISFILEISNOTEXIST );
		}	
		
		this.src_fname = src_fname;
	}
	
	/**
	 * ش  color RAW  ȯѴ. <br>
	 * 128x128 ũ test.jpg argument ־, test_color_128x128.raw ȯش. 
	 * 
	 * @return	ȯ ϸ
	 */
	public String  run() throws ImageGSException
	{
		// ش 󿡼 RGB channel, height, width ´.
		IMGFileIO img = new IMGFileIO();
		img.readFileName(src_fname);
		
		short[][] redChannel = img.getRedChannel();
		short[][] greenChannel = img.getGreenChannel();
		short[][] blueChannel = img.getBlueChannel();
		
		height = img.getHeight();
		width = img.getWidth();
	
		//  ϸ 
		String suffix = "color_" + height + "x" + width;
		dest_fname = CreateFileName.getSuffix(src_fname, suffix , fmt);
		
		// RAWImage instance Ͽ Ѵ.
		RAWImage raw = new RAWImage(src_fname, height, width);
		raw.save(dest_fname, redChannel, greenChannel, blueChannel, height, width);
	
		return dest_fname;
	}

	/**
	 * ش  color RAW  ȯѴ. 
	 */	
	public void run(String src_fname, String dest_fname) throws ImageGSException
	{
		// ش 󿡼 RGB channel, height, width ´.
		IMGFileIO img = new IMGFileIO();
		img.readFileName(src_fname);
		
		short[][] redChannel = img.getRedChannel();
		short[][] greenChannel = img.getGreenChannel();
		short[][] blueChannel = img.getBlueChannel();
		
		height = img.getHeight();
		width = img.getWidth();
	
		//  ϸ 
		String suffix = "color_" + height + "x" + width;
		dest_fname = CreateFileName.getSuffix(src_fname, suffix , fmt);
		
		// RAWImage instance Ͽ Ѵ.
		RAWImage raw = new RAWImage(src_fname, height, width);
		raw.save(dest_fname, redChannel, greenChannel, blueChannel, height, width);

		return;		
	}
	
	/**
	 * 
	 * ȯ color RAW   ̸ ȯѴ.
	 * 
	 * @return ش color RAW   
	 */
	public int getHeight()
	{
		return height;	
	}
	
	/**
	 * 
	 * ȯ color RAW   ʺ ȯѴ.
	 * 
	 * @return ش color RAW   ʺ 
	 */	
	public int getWidth()
	{
		return width;	
	}
}
