/**
 * Class Name	: ToRAWGrayImage
 * Description	: JPEG/BMP/PNG/PPM ÷  gray RAW ȯ.
 * Date 				: 2002/11/29
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/11/29 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * JPEG, BMP, PNG, PPM, GIF ÷ Ÿ  gray RAW  ȯѴ.<p>
 * 
 *  JPEG, BMP, PNG, PPM, GIF ÷  ó ӵ  ȴٸ, <br>
 * gray RAW  ȯ , RAWGrayImage Բ غ ٶ.<p>
 *
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class ToRAWGrayImage
{
	private final static String fmt = "raw";
	private String src_fname = null;
	private String dest_fname = null;
	private int height = 0;
	private int width = 0;
	
	public ToRAWGrayImage(String src_fname) 	throws ImageGSException 
	{
		// src_fname ϴ° ˻.
		File fp = new File(src_fname);
		if(fp.exists() == false)
		{
			throw new ImageGSException("ToRAWGrayImage.run() >> " 
				+ ErrorMsg.ERRORTHISFILEISNOTEXIST );
		}	
		
		this.src_fname = src_fname;
	}
	
	/**
	 * ش  gray RAW  ȯѴ. <br>
	 * 128x128 ũ test.jpg argument ־, test_128x128.raw ȯش. 
	 * 
	 * @return	ȯ ϸ
	 */
	public String  run() throws ImageGSException
	{
		// ش 󿡼 gray channel, height, width ´.
		IMGFileIO img = new IMGFileIO();
		img.readFileName(src_fname);
		short[][] grayChannel = img.getGrayChannel();
		height = img.getHeight();
		width = img.getWidth();
	
		//  ϸ 
		String suffix = height + "x" + width;
		dest_fname = CreateFileName.getSuffix(src_fname, suffix , fmt);
		
		// RAWGrayImage instance Ͽ Ѵ.
		RAWGrayImage raw = new RAWGrayImage(src_fname, height, width);
		raw.save(dest_fname, grayChannel, height, width);
	
		return dest_fname;
	}

	/**
	 * ش  gray RAW  ȯѴ. 
	 */	
	public void run(String src_fname, String dest_fname) throws ImageGSException
	{
		// ش 󿡼 gray channel, height, width ´.
		IMGFileIO img = new IMGFileIO();
		img.readFileName(src_fname);
		short[][] grayChannel = img.getGrayChannel();
		height = img.getHeight();
		width = img.getWidth();
	
		// RAWGrayImage instance Ͽ Ѵ.
		RAWGrayImage raw = new RAWGrayImage(src_fname, height, width);
		raw.save(dest_fname, grayChannel, height, width);

		return;		
	}
	
	/**
	 * 
	 * ȯ gray RAW   ̸ ȯѴ.
	 * 
	 * @return ش gray RAW   
	 */
	public int getHeight()
	{
		return height;	
	}
	
	/**
	 * 
	 * ȯ gray RAW   ʺ ȯѴ.
	 * 
	 * @return ش gray RAW   ʺ 
	 */	
	public int getWidth()
	{
		return width;	
	}
}
