/**
 * Class Name	: TIMGViewer
 * Description	: ش  ÷
 * Date 				: 2004/02/01
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2004/02/01 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import java.awt.image.BufferedImage;

import com.conv2.imageGS.ErrorMsg.ErrorMsg;
import com.conv2.imageGS.Exception.ImageGSException;

/**
 * ش  ÷Ѵ. <p>
 * 
 *    : PPM / JPEG / PNG / BMP / GIF / PGM / Color RAW <p>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class TIMGViewer
{
	private TIMGViewer() {}

   /**
     * ش  ÷Ѵ.<p>
     * 
     * , ĸǹٿ fname θ . 
     * 
	 * @param	fname	ش  θ
     * @exception ImageGSException 
     */		
	public static void run(String fname) throws ImageGSException
	{
		run(fname, fname, fname);
	}

	/**
	 * ش  ÷Ѵ. , raw  ʴ´.
	 * 
	 * @param	fname	ش  θ
	 * @param    captionTitle	(ĸ)
	 * @param	imageTitle		̹ Ʒ ġ 	
	 * @exception ImageGSException 
	 */	
	public static void run(String fname, String captionTitle) throws ImageGSException
	{
		run( fname, captionTitle, captionTitle );
	}
	
   /**
     * ش  ÷Ѵ. , raw  ʴ´.
     * 
	 * @param	fname	ش  θ
     * @param    captionTitle	(ĸ)
     * @param	imageTitle		̹ Ʒ ġ 	
     * @exception ImageGSException 
     */	
	public static void run(String fname, String captionTitle, String imageTitle) throws ImageGSException
	{
		// fname  Ȯڸ ľѴ.
		int ExtName_start; // Ȯڸ ۵Ǵ ġ
		String ExtName="";

		// Ȯڸ ν
		ExtName_start = fname.lastIndexOf(".");
		ExtName = fname.substring(ExtName_start+1);

		if( ExtName.length() > 4) 
		{
			throw new ImageGSException(
					"TIMGViewer.run() >> "
					+ fname
					+ " "
					+ ErrorMsg.ERRORNOTSUPPORTFORMAT);
		}

		// ҹڷ ٲپش.
		String LowerString = ExtName.toLowerCase();
		
		if( LowerString.equals("raw") )
		{
			throw new ImageGSException(
					"TIMGViewer.run() >> "
					+ fname
					+ " not support raw format ");
		}
		
		run( fname, captionTitle, imageTitle, -1, -1 );
	}

	/**
	 * ش  ÷ϸ height, width  color RAW ʿ. (gray RAW  ʴ´.)
	 * 
	 * @param	fname	ش  θ
	 * @param   captionTitle	(ĸ)
	 * @param	height	ش   (only raw)
	 * @param	width	ش  ʺ (only raw)
	 * @exception ImageGSException 
	 */	
	public static void run(String fname, String captionTitle, int height, int width) throws ImageGSException
	{
		run( fname, captionTitle, captionTitle, height, width );
	}
	
	/**
	  * ش  ÷ϸ height, width  color RAW ʿ. (gray RAW  ʴ´.)
	  * 
	  * @param	fname	ش  θ
      * @param   captionTitle	(ĸ)
      * @param	imageTitle		̹ Ʒ ġ 	
      * @param	height	ش   (only raw)
      * @param	width	ش  ʺ (only raw)
	  * @exception ImageGSException 
	  */	
	public static void run(String fname, String captionTitle, String imageTitle, int height, int width) throws ImageGSException
	{
		// fname  Ȯڸ ľѴ.
		int ExtName_start; // Ȯڸ ۵Ǵ ġ
		String ExtName="";

		// Ȯڸ ν
		ExtName_start = fname.lastIndexOf(".");
		ExtName = fname.substring(ExtName_start+1);

		if( ExtName.length() > 4) 
		{
			throw new ImageGSException(
				"TIMGViewer.run() >> "
					+ fname
					+ " "
					+ ErrorMsg.ERRORNOTSUPPORTFORMAT);
		}

		// ҹڷ ٲپش.
		String LowerString = ExtName.toLowerCase();

		IMGFileIO img = new IMGFileIO();
		BufferedImage bi = null;
		
		if (LowerString.equals("ppm")
			|| LowerString.equals("jpg")
			|| LowerString.equals("png")
			|| LowerString.equals("bmp")
			|| LowerString.equals("gif"))
		{
			img.readFileName( fname );
			bi = img.getBufferedImage();
		}
		else if(LowerString.equals("pgm"))
		{
			PGMImage pgmImage = new PGMImage( fname );
			bi = pgmImage.getBufferedImage();
			
		}
		else if(LowerString.equals("raw"))
		{
			img.readRAW( fname, height, width );	
			img.readFileName( fname );
			bi = img.getBufferedImage();
		}
		else 
		{
			throw new ImageGSException(
				"TIMGViewer.run() >> "
					+ fname
					+ " "
					+ ErrorMsg.ERRORNOTSUPPORTFORMAT);
		}	
		
		TMultiChannelViewer mcv = new TMultiChannelViewer( 1, 1 );
		mcv.setPosition( 0, 0, bi, imageTitle );
		mcv.run( captionTitle );
	}
}
