/**
 * Class Name	: TChannelViewer
 * Description	: ش ä display Ѵ.
 * Date 				: 2003/10/20
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/10/20 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.BinaryProc.*;
import com.conv2.imageGS.Exception.*;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;

/**
 * Ϸ  ʰ ä , 2 ۸  display Ѵ.<br>
 * 2   ϵ    ִ. <p>
 *
 *  Ŭ,   display ֺ  ְ, ϴܿ ڸ   ִ.<br>
 * ׷Ƿ, ChannelViewer ɰ ϳ, ,  ߰ Ǿٴ 鸸 ٸ. <p>
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class TChannelViewer extends JFrame 
{
	private TChannelViewer() {}
	
	/**
	  * ش /ϵ ä , 2 ۸  display Ѵ. 
	  * 
	  * @param	channel	short type 2 
	  * @param	binaryFlag	true :  / false : ϵ
	  * @exception ImageGSException channel  
	  */
	 public static void run(short[][] channel, boolean binaryFlag ) throws ImageGSException 
	 {
		 run(channel, true, " Դϴ", null);	
	 }
	
	/**
	  * ش /ϵ ä , 2 ۸  display Ѵ.
	  * 
	  * @param	channel	short type 2 
	  * @param	binaryFlag	true :  / false : ϵ
	  * @param   captionTitle		(ĸ)
	  * @exception ImageGSException  channel  
	  */
	 public static void run(short[][] channel, boolean binaryFlag, String captionTitle) throws ImageGSException 
	 {
		run(channel, true, captionTitle, null);
	 }

	/**
	  * ش /ϵ ä , 2 ۸  display Ѵ.
	  * 
	  * @param	channel	short type 2 
	  * @param	binaryFlag	true :  / false : ϵ
	  * @param   captionTitle		(ĸ)
	  * @param	imageTitle		2  Ʒ ġ (ĸ)
	  * @exception ImageGSException  channel  
	  */
	 public static void run(short[][] channel, boolean binaryFlag, String captionTitle, String imageTitle)  throws ImageGSException 
	 {
		if(binaryFlag) 
		{
			run(Binary2GrayIMG.ShortBinary2GrayIMG(channel), captionTitle, imageTitle);
		}
		else 
		{
			run(channel, captionTitle, imageTitle);
		}
	 }
	 	 
   /**
     * ش ϵ ä , 2 ۸  display Ѵ. 
     * 
	 * @param	grayChannel	short type 2 
     * @exception ImageGSException grayChannel  
     */
	public static void run(short[][] grayChannel) throws ImageGSException 
	{
		String captionTitle = null;
		run(grayChannel, captionTitle, null );
	}
	
   /**
     * ش ϵ ä , 2 ۸  display Ѵ.
     * 
	 * @param	grayChannel	short type 2 
	  * @param   captionTitle		(ĸ)
     * @exception ImageGSException  grayChannel  
     */
	public static void run(short[][] grayChannel, String captionTitle) throws ImageGSException 
	{
		run(grayChannel, captionTitle, null);
	}	


	/**
	  * ش ϵ ä , 2 ۸  display Ѵ. 
	  * 
	  * @param	grayChannel	short type 2 
	  * @param   captionTitle		(ĸ)
	  * @param	imageTitle		2  Ʒ ġ (ĸ)
	  * @exception ImageGSException  grayChannel  
	  */
	 public static void run(short[][] grayChannel, String captionTitle, String imageTitle) throws ImageGSException 
	 {

		BufferedImage bi = null;
		
		String captionTitleStr = "ϵ Դϴ.";
		if(captionTitle != null)  captionTitleStr = captionTitle;
		
		String imageTitleStr = "";
		if( imageTitle != null ) imageTitleStr = imageTitle;

		try 
		{

			bi = makeBufferedImage( grayChannel, imageTitle);
			
			ImagePanel ip = new ImagePanel(bi);
					
			JFrame fr = new JFrame(captionTitle);
			fr.getContentPane().add(ip, BorderLayout.CENTER);
			fr.pack();
			fr.setVisible(true);		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("TChannelViewer.run() >> " + e.getMessage());
		}	
	 }	

   /**
     * Red, Green, Blue ä ģ ÷ ۸  display Ѵ.  <p>
     * 
	 *  ä ϵ  Ѵٸ, <br>
	 * 3 ä   ÷  .<p>
	 * 
	 * @param	redChannel	short type red channel
	 * @param	greenChannel	short type green channel
	 * @param	blueChannel	short type blue channel
     * @exception ImageGSException	 channel ũⰡ ġ  ʰų,    
     */
	public static void run(short[][] redChannel, short[][] greenChannel, short[][] blueChannel) throws ImageGSException 
	{
		run(redChannel, greenChannel, blueChannel, null, null);	
	}

	/**
	  * Red, Green, Blue ä ģ ÷ ۸  display Ѵ.  <p>
	  * 
	  *  ä ϵ  Ѵٸ, <br>
	  * 3 ä   ÷  .<p>
	  * 
	  * @param	redChannel	short type red channel
	  * @param	greenChannel	short type green channel
	  * @param	blueChannel	short type blue channel
	  * @param   captionTitle		(ĸ)
	  * @exception ImageGSException	 channel ũⰡ ġ  ʰų,    
	  */
	public static void run(short[][] redChannel, short[][] greenChannel, short[][] blueChannel, String title) throws ImageGSException 
	{
		run(redChannel, greenChannel, blueChannel, title, null);	
	}
		
   /**
     * Red, Green, Blue ä ģ ÷ ۸  display Ѵ.  <p>
     * 
	 *  ä ϵ  Ѵٸ, <br>
	 * 3 ä   ÷  .<p>
	 * 
	 * @param	redChannel	short type red channel
	 * @param	greenChannel	short type green channel
	 * @param	blueChannel	short type blue channel
	 * @param   captionTitle		(ĸ)
	 * @param	imageTitle		2  Ʒ ġ (ĸ)
     * @exception ImageGSException	 channel ũⰡ ġ  ʰų,    
     */
	public static void run(short[][] redChannel, short[][] greenChannel, short[][] blueChannel, String captionTitle, String imageTitle)
		throws ImageGSException 
	{
		BufferedImage bi = null;
		
		String captionTitleStr = "÷ Դϴ.";
		if(captionTitle != null)  captionTitleStr = captionTitle;
		
		String imageTitleStr = "";
		if( imageTitle != null ) imageTitleStr = imageTitle;

		try 
		{

			bi = makeBufferedImage( redChannel, greenChannel, blueChannel, imageTitle);
			
			ImagePanel ip = new ImagePanel(bi);
					
			JFrame fr = new JFrame(captionTitle);
			fr.getContentPane().add(ip, BorderLayout.CENTER);
			fr.pack();
			fr.setVisible(true);		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("TChannelViewer.run() >> " + e.getMessage());
		}	
	}	

	/**
	  * ش /ϵ ä , 2 ۸  display Ѵ. 
	  * 
	  * @param	channel	double type 2 
	  * @param	binaryFlag	true :  / false : ϵ
	  * @exception ImageGSException channel  
	  */
	 public static void run(double[][] channel, boolean binaryFlag ) throws ImageGSException 
	 {
		 run(channel, true, " Դϴ", null);	
	 }
	
	/**
	  * ش /ϵ ä , 2 ۸  display Ѵ.
	  * 
	  * @param	channel	short type 2 
	  * @param	binaryFlag	true :  / false : ϵ
	  * @param   captionTitle		(ĸ)
	  * @exception ImageGSException  channel  
	  */
	   public static void run(double[][] channel, boolean binaryFlag, String captionTitle) throws ImageGSException 
	   {
		  run(channel, true, captionTitle, null);
	   }

	/**
	  * ش /ϵ ä , 2 ۸  display Ѵ.
	  * 
	  * @param	channel	double type 2 
	  * @param	binaryFlag	true :  / false : ϵ
	  * @param   captionTitle		(ĸ)
	  * @param	imageTitle		2  Ʒ ġ (ĸ)
	  * @exception ImageGSException  channel  
	  */
	 public static void run(double[][] channel, boolean binaryFlag, String captionTitle, String imageTitle) throws ImageGSException 
	 {
		if(binaryFlag) 
		{
			run(Binary2GrayIMG.DoubleBinary2GrayIMG(channel), captionTitle, imageTitle);
		}
		else 
		{
			run(channel, captionTitle, imageTitle);
		}
	 }

	/**
	  * ش ϵ ä , 2 ۸  display Ѵ.
	  * 
	  * @param	grayChannel	double type 2 
	  * @exception ImageGSException grayChannel  
	  */
	 public static void run(double[][] grayChannel) throws ImageGSException 
	 {
		 String captionTitle = null;
		 run(TypeConv2GrayIMG.Double2ShortGrayIMG(grayChannel), captionTitle, null );
	 }
	 	 	 
	/**
	  * ش ϵ ä , 2 ۸  display Ѵ.
	  * 
	  * @param	grayChannel	double type 2 
	   * @param   captionTitle		(ĸ)
	  * @exception ImageGSException  grayChannel  
	  */
	 public static void run(double[][] grayChannel, String captionTitle) throws ImageGSException 
	 {
		 run(TypeConv2GrayIMG.Double2ShortGrayIMG(grayChannel), captionTitle, null);
	 }	

	/**
	  * ش ϵ ä , 2 ۸  display Ѵ.
	  * 
	  * @param	grayChannel	short type 2 
	  * @return   captionTitle		(ĸ)
	  * @param	imageTitle		2  Ʒ ġ (ĸ)
	  * @exception ImageGSException  grayChannel  
	  */
	 public static void run(double[][] grayChannel, String captionTitle, String imageTitle) throws ImageGSException 
	 {

		BufferedImage bi = null;
		
		String captionTitleStr = "ϵ Դϴ.";
		if(captionTitle != null)  captionTitleStr = captionTitle;
		
		String imageTitleStr = "";
		if( imageTitle != null ) imageTitleStr = imageTitle;

		try 
		{

			bi = makeBufferedImage( grayChannel, imageTitle);
			
			ImagePanel ip = new ImagePanel(bi);
			JFrame fr = new JFrame(captionTitle);
			fr.getContentPane().add(ip, BorderLayout.CENTER);
			fr.pack();
			fr.setVisible(true);		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("TChannelViewer.run() >> " + e.getMessage());
		}	
	 }	

	/**
	  * Red, Green, Blue ä ģ ÷ ۸  display Ѵ.  <p>
	  * 
	  *  ä ϵ  Ѵٸ, <br>
	  * 3 ä   ÷  .<p>
	  * 
	  * @param	redChannel	double type red channel
	  * @param	greenChannel	double type green channel
	  * @param	blueChannel	double type blue channel
	  * @exception ImageGSException	 channel ũⰡ ġ  ʰų,    
	  */
	 public static void run(double[][] redChannel, double[][] greenChannel, double[][] blueChannel) throws ImageGSException 
	 {
		 run(redChannel, greenChannel, blueChannel, null, null);	
	 }

	 /**
	   * Red, Green, Blue ä ģ ÷ ۸  display Ѵ.  <p>
	   * 
	   *  ä ϵ  Ѵٸ, <br>
	   * 3 ä   ÷  .<p>
	   * 
	   * @param	redChannel	short type red channel
	   * @param	greenChannel	short type green channel
	   * @param	blueChannel	short type blue channel
	   * @param   captionTitle		(ĸ)
	   * @exception ImageGSException	 channel ũⰡ ġ  ʰų,    
	   */
	 public static void run(double[][] redChannel, double[][] greenChannel, double[][] blueChannel, String captionTitle) throws ImageGSException 
	 {
		 run(redChannel, greenChannel, blueChannel, captionTitle, null);	
	 }
		
	/**
	  * Red, Green, Blue ä ģ ÷ ۸  display Ѵ.  <p>
	  * 
	  *  ä ϵ  Ѵٸ, <br>
	  * 3 ä   ÷  .<p>
	  * 
	  * @param	redChannel	short type red channel
	  * @param	greenChannel	short type green channel
	  * @param	blueChannel	short type blue channel
	  * @param   captionTitle		(ĸ)
	  * @param	imageTitle		2  Ʒ ġ (ĸ)
	  * @exception ImageGSException	 channel ũⰡ ġ  ʰų,    
	  */
	 public static void run(double[][] redChannel, double[][] greenChannel, double[][] blueChannel, String captionTitle, String imageTitle)
	 	throws ImageGSException 
	 {
		BufferedImage bi = null;
		
		 String captionTitleStr = "÷ Դϴ.";
		 if(captionTitle != null)  captionTitleStr = captionTitle;
		
		 String imageTitleStr = "";
		 if( imageTitle != null ) imageTitleStr = imageTitle;

		 try 
		 {

			 bi = makeBufferedImage( redChannel, greenChannel, blueChannel, imageTitle);
			
			 ImagePanel ip = new ImagePanel(bi);
					
			 JFrame fr = new JFrame(captionTitle);
			 fr.getContentPane().add(ip, BorderLayout.CENTER);
			 fr.pack();
			 fr.setVisible(true);		
		 } 
		 catch (Exception e)
		 {
			 throw new ImageGSException("TChannelViewer.run() >> " + e.getMessage());
		 }	
	 }	 

   /**
     * ش BufferedImage display Ѵ.  
     * 
	 * @param	bi	BufferedImage Ÿ 
     * @exception ImageGSException 
     */	
	public static void run(BufferedImage bi) throws ImageGSException 
	{
		run(bi, null, null);
	}	

	/**
	  * ش BufferedImage display Ѵ. 
	  * 
	  * @param	bi	BufferedImage Ÿ 
	   * @return   captionTitle		(ĸ)
	  * @exception ImageGSException 
	  */	
	 public static void run(BufferedImage bi, String captionTitle) throws ImageGSException 
	{
		run(bi, captionTitle, null);									 	
	}
	
   /**
     * ش BufferedImage display Ѵ. 
     * 
	 * @param	bi	BufferedImage Ÿ 
	 * @param   captionTitle		(ĸ)
	 * @param	imageTitle		ش BufferedImage Ʒ ġ (ĸ)
     * @exception ImageGSException 
     */	
	public static void run(BufferedImage bi, String captionTitle, String imageTitle) throws ImageGSException 
	{
		String captionTitleStr = "BufferedImage ݴϴ."; 
		if(captionTitle != null)  captionTitleStr = captionTitle;
		
		String imageTitleStr = "";
		if( imageTitle != null ) imageTitleStr = imageTitle;

		try 
		{

			BufferedImage bis = setBufferedImage(bi, imageTitle);
			
			ImagePanel ip = new ImagePanel(bis);
					
			JFrame fr = new JFrame(captionTitle);
			fr.getContentPane().add(ip, BorderLayout.CENTER);
			fr.pack();
			fr.setVisible(true);		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("TChannelViewer.run() >> " + e.getMessage());
		}		
	}


	// gray
	protected static BufferedImage makeBufferedImage(Object obj_grayChannel, String imageTitle) throws ImageGSException
	{
		if( obj_grayChannel == null ) return null;
		
		short[][] grayChannel = null;
		
		// type casting
		if(obj_grayChannel instanceof short[][])
		{
			grayChannel = CopyIMGBuf.CopyShortGrayIMGBuf( (short [][])obj_grayChannel );
		}
		else if(obj_grayChannel instanceof double[][])
		{
			grayChannel = TypeConv2GrayIMG.Double2ShortGrayIMG( (double [][])obj_grayChannel );
		}

		int marginLength = 10;
		int textMarginLength = 20;
		short backgroundValue = 128;
		int fontSize = 12;
		String fontName = "ü";
					
		short[][] newGrayChannel = null;
		int resizeHeight = 0;
		int resizeWidth = 0;
			
		int i, j;
		BufferedImage bi = null;

		int height = GetSizeIMG.getHeight(grayChannel);
		int width = GetSizeIMG.getWidth(grayChannel);

		if(imageTitle == null || imageTitle.length() < 1)
		{
			
			resizeHeight = height + marginLength;
			resizeWidth = width + marginLength;
			
			newGrayChannel = FillIMGBuf.FillShortGrayIMGBuf( backgroundValue, resizeHeight, resizeWidth );
				
			// copy
			for(i=marginLength; i<height; i++)
			{
				for(j=marginLength; j<width; j++)
				{
					newGrayChannel[i][j] = grayChannel[i][j];	
				}
			}

			// 2 ۸ BufferedImage ȯ.
			Channel2BufferedImage cb = new Channel2BufferedImage();
			cb.gray(newGrayChannel);
			bi = cb.getBufferedImage();
		}
		else
		{
			resizeHeight = height + marginLength;
			resizeWidth = width + marginLength;
			
			int resizeHeight2 = resizeHeight + textMarginLength;
			int resizeWidth2 = resizeWidth;
				
			newGrayChannel = FillIMGBuf.FillShortGrayIMGBuf( backgroundValue, resizeHeight2 ,  resizeWidth2);
				
			// copy
			for(i=marginLength; i<height; i++)
			{
				for(j=marginLength; j<width; j++)
				{
					newGrayChannel[i][j] = grayChannel[i][j];	
				}
			}
				
			// insert text
			// BufferedImage type ȯѴ.
			Channel2BufferedImage cb = new Channel2BufferedImage();
			cb.gray( newGrayChannel );
			bi = cb.getBufferedImage();
		
			// ߾ӿ ġŲ.
			Graphics2D gp = bi.createGraphics();
			Font fnt = new Font(fontName, Font.PLAIN, fontSize);
			gp.setFont(fnt);
			gp.setColor(Color.BLACK);
			gp.drawString(imageTitle, marginLength  ,  resizeHeight2 - textMarginLength/2);
			gp.dispose();				
								
		}
		
		return bi;
	}

	// color
	protected static BufferedImage makeBufferedImage(Object obj_redChannel, 
																Object obj_greenChannel,
																Object obj_blueChannel,
																String imageTitle) throws ImageGSException
	{
		if( obj_redChannel == null || obj_greenChannel == null || obj_blueChannel == null ) return null;

		short[][] redChannel = null;
		short[][] greenChannel = null;
		short[][] blueChannel = null;
		
		// type casting
		if(obj_redChannel instanceof short[][])
			redChannel = CopyIMGBuf.CopyShortGrayIMGBuf( (short [][])obj_redChannel );
		else if(obj_redChannel instanceof double[][])
			redChannel = TypeConv2GrayIMG.Double2ShortGrayIMG( (double [][])obj_redChannel );

		// type casting
		if(obj_greenChannel instanceof short[][])
			greenChannel = CopyIMGBuf.CopyShortGrayIMGBuf( (short [][])obj_greenChannel );
		else if(obj_greenChannel instanceof double[][])
			greenChannel = TypeConv2GrayIMG.Double2ShortGrayIMG( (double [][])obj_greenChannel );

		// type casting
		if(obj_blueChannel instanceof short[][])
			blueChannel = CopyIMGBuf.CopyShortGrayIMGBuf( (short [][])obj_blueChannel );
		else if(obj_blueChannel instanceof double[][])
			blueChannel = TypeConv2GrayIMG.Double2ShortGrayIMG( (double [][])obj_blueChannel );
						
		int marginLength = 10;
		int textMarginLength = 20;
		short backgroundValue = 128;
		int fontSize = 12;
		String fontName = "ü";
			
		short[][] newRedChannel = null;
		short[][] newGreenChannel = null;
		short[][] newBlueChannel = null;
		
		int resizeHeight = 0;
		int resizeWidth = 0;
			
		int i, j;
		BufferedImage bi = null;

		int height = GetSizeIMG.getHeight(redChannel);
		int width = GetSizeIMG.getWidth(redChannel);

		if(imageTitle == null || imageTitle.length() < 1)
		{
			
			resizeHeight = height + marginLength;
			resizeWidth = width + marginLength;
			
			newRedChannel = FillIMGBuf.FillShortGrayIMGBuf( backgroundValue, resizeHeight, resizeWidth );
			newGreenChannel = FillIMGBuf.FillShortGrayIMGBuf( backgroundValue, resizeHeight, resizeWidth );
			newBlueChannel = FillIMGBuf.FillShortGrayIMGBuf( backgroundValue, resizeHeight, resizeWidth );
							
			// copy
			for(i=marginLength; i<height; i++)
			{
				for(j=marginLength; j<width; j++)
				{
					newRedChannel[i][j] = redChannel[i][j];	
					newGreenChannel[i][j] = greenChannel[i][j];	
					newBlueChannel[i][j] = blueChannel[i][j];	
				}
			}

			// 2 ۸ BufferedImage ȯ.
			Channel2BufferedImage cb = new Channel2BufferedImage();
			cb.color(newRedChannel, newGreenChannel, newBlueChannel);
			bi = cb.getBufferedImage();
		}
		else
		{
			resizeHeight = height + marginLength;
			resizeWidth = width + marginLength;
			
			int resizeHeight2 = resizeHeight + textMarginLength;
			int resizeWidth2 = resizeWidth;

			newRedChannel = FillIMGBuf.FillShortGrayIMGBuf( backgroundValue, resizeHeight2, resizeWidth2 );
			newGreenChannel = FillIMGBuf.FillShortGrayIMGBuf( backgroundValue, resizeHeight2, resizeWidth2 );
			newBlueChannel = FillIMGBuf.FillShortGrayIMGBuf( backgroundValue, resizeHeight2, resizeWidth2 );
				
			// copy
			for(i=marginLength; i<height; i++)
			{
				for(j=marginLength; j<width; j++)
				{
					newRedChannel[i][j] = redChannel[i][j];	
					newGreenChannel[i][j] = greenChannel[i][j];	
					newBlueChannel[i][j] = blueChannel[i][j];	
				}
			}
				
			// insert text
			// BufferedImage type ȯѴ.
			// 2 ۸ BufferedImage ȯ.
			Channel2BufferedImage cb = new Channel2BufferedImage();
			cb.color(newRedChannel, newGreenChannel, newBlueChannel);
			bi = cb.getBufferedImage();
		
			// ߾ӿ ġŲ.
			Graphics2D gp = bi.createGraphics();
			Font fnt = new Font(fontName, Font.PLAIN, fontSize);
			gp.setFont(fnt);
			gp.setColor(Color.BLACK);
			gp.drawString(imageTitle, marginLength  ,  resizeHeight2 - textMarginLength/2);
			gp.dispose();				
								
		}
		
		return bi;
	}

	// BufferedImage
	protected static BufferedImage setBufferedImage(BufferedImage bi, String imageTitle) throws ImageGSException
	{
		if( bi == null ) return null;
		
		BufferedImage2Channel bc = new BufferedImage2Channel();
		bc.color(bi);

		short [][] redChannel = bc.getRedChannel();
		short [][] greenChannel = bc.getGreenChannel();
		short [][] blueChannel = bc.getBlueChannel();

		return makeBufferedImage( redChannel, greenChannel, blueChannel, imageTitle);
	}
}