
/* PPM  о̴ PPM  Ŭ only RAWBITS PPM Files
 *
 * By Programming Atanas Georgiev
 * By Modified, Programming Lee, Moon-Ho (conv2@nvision.gsnu.ac.kr)
 * 
 * First Modified Date : 2001. 08. 07
 * Last Modified Date : 2002. 10. 29
 *
 * Orginal Source : http://www.columbia.edu/~cs4735/code/java_code
*/

package com.conv2.imageGS.IMGFileIO;

import java.io.*;
import java.awt.image.*;
import javax.swing.*;

import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.Util.*;

/**
 * PPM handling Ŭ.<p>
 * 
 * , gray level   JPEG   ÷  Ÿ Ѵ. <br>
 * ׷Ƿ color  Ѵ.<p>
 * 
 * @author Atanas Georgiev, Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */

public class PPMImage
{

	public static final int PPM = 1;
	public static int DEFAULT = PPM;

	private int type;

	private int alpha = (int)0xFF000000;

	private String fname;
	private int width, height;

	protected BufferedImage bimg;
	protected PPMImagePanel panel;
	
	private short [][] RedChannel = null;
	private short [][] GreenChannel = null;
	private short [][] BlueChannel = null;
	private short [][] GrayChannel = null;
	
	public PPMImage(int type, String name, int w, int h) 
				throws ImageGSException 
	{
		setType(type);
		setSize(w, h);
		setName(name);
	}

	public PPMImage(int type, String name) 
				throws ImageGSException 
	{
		this(type, name, 0, 0);
	}

	public PPMImage(int type) 
				throws ImageGSException 
	{
		this(type, null, 0, 0);
	}

	public PPMImage(String name) 
				throws ImageGSException 
	{
		this(DEFAULT, name, 0, 0);
	}

	public PPMImage() 
				throws ImageGSException 
	{
		this(DEFAULT, null, 0, 0);
	}

	private int getType() {
		return this.type;
	}

	private void setType(int type) throws ImageGSException {
		if (type != PPM)
			throw new ImageGSException(this.getClass().getName() + "No such image type");
		this.type = type;
	}

	public String getName() {
		return new String(fname);
	}

	public void setName(String name) {
		if (name != null) fname = new String(name);
		else fname = null;
	}

	public int getWidth() {
		return width;
	}

	public int getHeight() {
		return height;
	}

	public short[][] getRedChannel()
	{
		return (short[][])RedChannel;
	}

	public short[][] getGreenChannel()
	{
		return (short[][])GreenChannel;
	}

	public short[][] getBlueChannel()
	{
		return (short[][])BlueChannel;
	}

	public short[][] getGrayChannel()
	{
		return (short[][])GrayChannel;
	}

	public BufferedImage getBufferedImage()
	{
		return bimg;	
	}
	
	private void setSize(int w, int h) {
		width = w; height = h;
		if (w == 0 || h == 0) { bimg = null; return; }
		bimg = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
		panel = new PPMImagePanel(bimg);
	}

	public short getR(int x, int y) {
		return (short)(bimg.getColorModel().getRed(bimg.getRGB(x,y)));
	}

	public short getG(int x, int y) {
		return (short)(bimg.getColorModel().getGreen(bimg.getRGB(x,y)));
	}

	public short getB(int x, int y) {
		return (short)(bimg.getColorModel().getBlue(bimg.getRGB(x,y)));
	}

	// Set pixel values
	private int packRGB(short r, short g, short b) 
	{
		return alpha + 65536*r + 256*g + b;
	 }

	private void setPixel(int x, int y, int rgb) 
	{
		bimg.setRGB(x, y, rgb);
	}

	private void setPixel(int x, int y, short r, short g, short b) 
	{
		setPixel(x, y, packRGB(r,g,b));
	}

	private String readHeader(FileInputStream in) throws IOException 
	{
		StringBuffer result = new StringBuffer("");
		char ch;

		// Get the line with the magic number
		while ((ch = (char)in.read()) != '\n')
		{
			result.append(ch);
		}
		result.append('\n');

		// Skip the comments
		while ((ch = (char)in.read()) == '#')
		{
			while (in.read() != '\n');
		}

		// Get the line with width and height
		do { result.append(ch); }
		while ((ch = (char)in.read()) != '\n');

		// Get the line with the color depth
		do { result.append(ch); }
		while ((ch = (char)in.read()) != '\n');
		result.append('\n');

		// The file stream is now at the beginning of the pixel values
		return result.toString();
	}

	public JPanel getImagePanel() 
	{
		return panel;
	}
	
	private void setup(String hdr) throws IOException, ImageGSException 
	{
		int type;
		StreamTokenizer st = new StreamTokenizer(new StringReader(hdr));

		st.eolIsSignificant(false);
		st.commentChar('#');
		st.whitespaceChars(0, (int)' ');

		//if (st.nextToken() != st.TT_WORD)
		if (st.nextToken() != -3)
		{
			throw new ImageGSException(this.getClass().getName() + ">> " +"Wrong file format");
		}
		if (!st.sval.equals("P6"))
		{
			throw new ImageGSException(this.getClass().getName()  + ">> "+"Bad magic number");
		}
		else {
			type = PPM;
		}
	
		// Read the width and the height
		//if (st.nextToken() != st.TT_NUMBER)
		if (st.nextToken() != -2)
			throw new ImageGSException(this.getClass().getName()  + ">> "+ "Bad image width");

		int w = (int)st.nval;

		if (w <= 0)
			throw new ImageGSException(this.getClass().getName()  + ">> "+"Bad image width");

		//if (st.nextToken() != st.TT_NUMBER)
		if(st.nextToken() != -2)
			throw new ImageGSException(this.getClass().getName()  + ">> "+"Bad image height");

		int h = (int)st.nval;
		
		if (h <= 0)
			throw new ImageGSException(this.getClass().getName()  + ">> "+"Bad image height");

		//if (st.nextToken() != st.TT_NUMBER)
		if(st.nextToken() != -2)
			throw new ImageGSException(this.getClass().getName()  + ">> "+"Bad image depth");

		st.eolIsSignificant(true);
		
		//if (st.nextToken() != st.TT_EOL)
		if(st.nextToken() != '\n')
			throw new ImageGSException(this.getClass().getName() + ">> " +"Bad end of header");

		setSize(w, h);

		try {
			setType(type);
		} catch (ImageGSException e) { throw e; }
	}

	public void load() throws ImageGSException 
	{
		FileInputStream in = null;
		
		try 
		{
			String header;
			in = new FileInputStream(fname);
			// Get and parse the header
			header = readHeader(in);
			setup(header);
			int total = width * height;
			short r, g, b = -1;
		
			//  Red, Green, Blue channel Ѵ.
			// Red, Green, Blue channel ֱ
			// 迭  ޸ Ҵ.
			RedChannel = InitIMGBuf.ShortIMGBuf(height, width);
			GreenChannel = InitIMGBuf.ShortIMGBuf(height, width);
			BlueChannel = InitIMGBuf.ShortIMGBuf(height, width);
			GrayChannel = InitIMGBuf.ShortIMGBuf(height, width);
			
			for (int i = 0; i < height; i++)
			{
				for (int j = 0; j < width; j++)
				{
					// bimg(BufferedImage ְ)
					r = (short)in.read();
					g = (short)in.read();
					b = (short)in.read();
					setPixel(j, i, r, g, b);

					// bimg ´.
					RedChannel[i][j] = getR(j,i);
					GreenChannel[i][j] = getG(j,i);
					BlueChannel[i][j] = getB(j,i);
					
					GrayChannel[i][j] = (short)((float)RedChannel[i][j]*0.299 
														+ (float)GreenChannel[i][j]*0.587 
														+ (float)BlueChannel[i][j]*0.114);					
				}
			}
	
			// Check for short files
			if (b < 0) throw new ImageGSException(this.getClass().getName() + " >>" + " Short file");
	
			// Done
			in.close();
		} 
		catch (IOException e)
		{
			if(in != null) try { in.close(); } catch (IOException se) {}
			throw new ImageGSException(this.getClass().getName() + ">>" +  e.getMessage());	
		}
		catch (ImageGSException e)
		{
			if(in != null) try { in.close(); } catch (IOException se) {}
			throw e;	
		}
	}

	public void load(String fname) throws ImageGSException 
	{
		setName(fname);
		this.load();
	}

	private byte short2byte(short n) 
	{
		if (n > 127) return (byte)(n - 256);
		else return (byte)n;
	}

	public void save(String fname, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int height, int width)
		throws ImageGSException
	{
		this.fname = fname;
		this.save(Red_ch, Green_ch, Blue_ch, height, width);	
	}
	
	// Save the image (PPM)
	public void save(short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int height, int width)
		throws ImageGSException
	{
		FileOutputStream out = null;
		PrintWriter pw = null; 
		try
		{
			out = new FileOutputStream(fname);
			pw = new PrintWriter(out);
			
			//  κ ۼѴ. txt..
			pw.println("P6"); 
			pw.print("# CS4735 PPM file I/O API (java).  Atanas Georgiev, 2001 ");
			pw.println("Modification Lee, Moon-Ho, 2002");
			pw.print(width); pw.print(" "); pw.println(height);
			pw.println("255");
			pw.flush();
			
			// Write the pixels
			// ڹ  : PPM̳ PGM  Ÿ 
			// 0~255̳, C unsigned char شϴ Ÿ
			// ڹٿ   byte  ؾ ϴ 
			//  츮  ̴   Ʋ.
			// ٸ, ó  ϴ.

			short r,g,b;
			
			// 2 1 .
			for(int i=0; i<height; i++)
			{
				for(int j=0; j<width; j++)
				{
					r = Red_ch[i][j];
					g = Green_ch[i][j];
					b = Blue_ch[i][j];
				
					out.write(short2byte(r));
					out.write(short2byte(g));
					out.write(short2byte(b));
				}	
			}
	
			// ݴ´.
			pw.close();
			out.close();
		} 
		catch (Exception e) 
		{
			try
			{
				if(pw != null) pw.close();
				if(out != null) out.close();
			} 
			catch (IOException es) {}
			
			throw new ImageGSException(this.getClass().getName() + ">>" +  e.getMessage());					
		}

	}
}

