/**
 * Class Name	: PGMImage
 * Description	: PGM handling class.
 * Date 				: 2003/10/12
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/10/12 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import java.io.*;
import java.awt.image.*;

import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.Util.*;

import javax.swing.*;

/**
 * gray level Ÿ PGM handling Ŭ. <p>
 *  
 * [] IMGFileIO Ŭ  ʴ´. <p>
 *
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class PGMImage 
{
	public static final int PGM = 1;
	private int type;
		
	private String fname;
	private BufferedImage myBufferedImage = null;
	private short [][] GrayChannel = null;

	private int height = 0;
	private int width = 0;

	protected ImagePanel panel;
		
	public PGMImage(String fname) throws ImageGSException
	{
		this.fname = fname;
	}

	public int getHeight()
	{
		return height;	
	}
	
	public int getWidth()
	{
		return width;
	}

	public short[][] getGrayChannel()
	{
		return (short[][])GrayChannel;
	}

	private void setType(int type) throws ImageGSException 
	{
		if (type != PGM)
			throw new ImageGSException(this.getClass().getName() + "No such image type");
		
		this.type = type;
	}

	private String readHeader(FileInputStream in) throws IOException 
	{
		StringBuffer result = new StringBuffer("");
		char ch;

		// Get the line with the magic number
		while ((ch = (char)in.read()) != '\n')
		{
			result.append(ch);
		}
		result.append('\n');

		// Skip the comments
		while ((ch = (char)in.read()) == '#')
		{
			while (in.read() != '\n');
		}

		// Get the line with width and height
		do { result.append(ch); }
		while ((ch = (char)in.read()) != '\n');

		// Get the line with the color depth
		do { result.append(ch); }
		while ((ch = (char)in.read()) != '\n');
		result.append('\n');

		// The file stream is now at the beginning of the pixel values
		return result.toString();
	}

	private void setSize(int w, int h) 
	{
		width = w; height = h;
	}
	
	private void setup(String hdr) throws IOException, ImageGSException 
	{
		int type;
		StreamTokenizer st = new StreamTokenizer(new StringReader(hdr));

		st.eolIsSignificant(false);
		st.commentChar('#');
		st.whitespaceChars(0, (int)' ');

		if (st.nextToken() != -3)
		{
			throw new ImageGSException(this.getClass().getName() + ">> " +"Wrong file format");
		}
		if (!st.sval.equals("P5"))
		{
			throw new ImageGSException(this.getClass().getName()  + ">> "+"Bad magic number");
		}
		else {
			type = PGM;
		}
	
		// Read the width and the height
		if (st.nextToken() != -2)
			throw new ImageGSException(this.getClass().getName()  + ">> "+ "Bad image width 1");

		int w = (int)st.nval;

		if (w <= 0)
			throw new ImageGSException(this.getClass().getName()  + ">> "+"Bad image width 2");

		if(st.nextToken() != -2)
			throw new ImageGSException(this.getClass().getName()  + ">> "+"Bad image height");

		int h = (int)st.nval;
		
		if (h <= 0)
			throw new ImageGSException(this.getClass().getName()  + ">> "+"Bad image height");

		if(st.nextToken() != -2)
			throw new ImageGSException(this.getClass().getName()  + ">> "+"Bad image depth");

		st.eolIsSignificant(true);
		
		if(st.nextToken() != '\n')
			throw new ImageGSException(this.getClass().getName() + ">> " +"Bad end of header");

		setSize(w, h);

		try {
			setType(type);
		} catch (ImageGSException e) { throw e; }
	}
		
	public void load() throws ImageGSException
	{
		FileInputStream in = null;
		
		try 
		{
			String header;
			in = new FileInputStream(fname);
			// Get and parse the header
			header = readHeader(in);
			setup(header);
			int total = width * height;
		
			//  Gray channel Ѵ.
			GrayChannel = InitIMGBuf.ShortIMGBuf(height, width);
			
			for (int i = 0; i < height; i++)
			{
				for (int j = 0; j < width; j++)
				{

					GrayChannel[i][j] = (short)in.read();			
				}
			}

			// Done
			in.close();
		} 
		catch (IOException e)
		{
			if(in != null) try { in.close(); } catch (IOException se) {}
			throw new ImageGSException(this.getClass().getName() + ">>" +  e.getMessage());	
		}
		catch (ImageGSException e)
		{
			if(in != null) try { in.close(); } catch (IOException se) {}
			throw e;	
		}
	}	

	// Get image panel
	public JPanel getImagePanel()
	{
		panel = new ImagePanel(getBufferedImage());	
		return panel;
	}
		
	public BufferedImage getBufferedImage()
	{
		try 
		{
			Channel2BufferedImage cb = new Channel2BufferedImage();
			cb.gray(GrayChannel, height, width);
			myBufferedImage = cb.getBufferedImage();
		}
		catch (ImageGSException e) 
		{
			; // ignore	
		}
		
		return myBufferedImage;
	}	

	public void save(String OutFname, short[][] OutGrayChannel) throws ImageGSException
	{
		this.fname = OutFname;
		this.save(OutGrayChannel, this.getHeight(), this.getWidth() );	
	}
	
	public void save(String OutFname, short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException
	{
		this.fname = OutFname;
		this.save(OutGrayChannel, OutHeight, OutWidth);	
	}
		
	public void save(short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException
	{
		int i, j;
		FileOutputStream out = null;
		PrintWriter pw = null; 
				
		try 
		{
			out = new FileOutputStream(fname);
			pw = new PrintWriter(out);
			
			//  κ ۼѴ. txt..
			pw.println("P5"); 
			pw.println("#imageGS API, Lee, Moon-Ho, 2003");
			pw.print(OutWidth); pw.print(" "); pw.println(OutHeight);
			pw.println("255");
			pw.flush();

			// 2 1 .
			for(i=0; i<OutHeight; i++)
			{
				for(j=0; j<OutWidth; j++)
				{
					out.write((byte)OutGrayChannel[i][j]);
				}	
			}
			
			// ݴ´.
			pw.close();
			out.close();
		}
		catch(Exception e)
		{
			if(pw != null) try{ pw.close(); } catch(Exception se) {}
			if(out != null) try { out.close(); } catch(IOException se) {}
			throw new ImageGSException(this.getClass().getName() + " >> "  + e.getMessage() );	
		}			
		
	}
}
