/**
 * Class Name	: Jpeg2Ppm
 * Description	: JPEG Ÿ ÷  PPM Ÿ ȯ
 * Date 				: 2002/10/08
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/08 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * JPEG Ÿ  PPM  Ÿ  ȯѴ.<p>
 * 
 * , ÷  Ѵ. ̿ܿ  ȯغ  ٸ. <br>
 * ⼭, ѹ PPMViewer class ϸ Jpeg .<p>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Jpeg2Ppm
{
	private Jpeg2Ppm() {}

   /**
     * JPEG  PPM ȯѴ. 
     * 
	 * @param	 jpeg_fname	ȯ JPEG  θ	
     * @return	ppm_fname	PPM  θ 
     * @exception ImageGSException
     * @exception IOException 
     */
	public static void run(String jpeg_fname, String ppm_fname) throws ImageGSException
	{
		File fp_src = new File(jpeg_fname);
		
		// ppm   ʴ´ٸ
		if(!fp_src.exists())
		{
			throw new ImageGSException("Jpeg2Ppm.run() >> " + ppm_fname + " : " 
												 + ErrorMsg.ERRORTHISFILEISNOTEXIST);
		}
/*		
		File fp_dest = new File(ppm_fname);
		
		// jpeg     ̶ִ Ǵ   Ǿ  
		if(fp_dest.canWrite())
		{
			throw new ImageGSException("Jpeg2Ppm.run() >> " + jpeg_fname + " : " 
												 + ErrorMsg.ERRORTHISISFILEISOCCUPIED);
		}			
*/		
//		IMGFileIO img = new IMGFileIO();
//		img.ReadJPEG(jpeg_fname);
//
//		short [][] R = img.getRedChannel();
//		short [][] G = img.getGreenChannel();
//		short [][] B = img.getBlueChannel();		
//		int height = img.getHeight();
//		int width = img.getWidth();
//		
//		img.WritePPM(ppm_fname, R, G, B, height, width);

		JPEGImage img = new JPEGImage(jpeg_fname);	
		img.load();
			
		IMGFileIO ppm= new IMGFileIO();

		short [][] R = img.getRedChannel();
		short [][] G = img.getGreenChannel();
		short [][] B = img.getBlueChannel();		
		int height = img.getHeight();
		int width = img.getWidth();
		
		ppm.writePPM(ppm_fname,  R, G, B, height, width);
	}
}
