/**
 * Class Name	: GIFImage
 * Description	: GIF handling class.
 * Date 				: 2003/03/31
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/03/31 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import java.io.*;
import java.awt.image.*;
import com.conv2.imageGS.Util.*;
import javax.imageio.*; // JDK 1.4
import javax.swing.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * GIF handling Ŭ with ImageIO package in JDK 1.4.<p>
 * 
 * , gray level   ʴ´. ̿    <br>
 *  PPM   ÷  Ÿ Ͽ Ѵ.. <br>
 * ׷Ƿ gray level  Ҷ color Ÿ ٲپ ϰ ִ.<p>
 *
 *  imageGS package  ó ˰  ΰ Ƿ,  <br>
 *   ڵ鸵 е鿡 ñ Ѵ.<p>
 * 
 * JDK 1.4̻󿡼 Ѵ. ׷   Ȳ .<p>
 * 
 * [] ImageIO pacakge in JDK 1.4  GIF(only read), JPEG, PNG Ѵ.<br>
 * [] JAI(Java Advanced Imaging) Ǵ JIMI   پ  Ѵ. ׷ API  ޾ƾ Ѵ.<br>
 * [] JDK 1.4    ϰ Ϸ JDK 1.4 javax.imageio Ű  ҽ imageGS ϸ ȴ. 
 * ׷   ʴ  Sun Microsystems ۱  ֱ ̴.<p>
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.1
 */
public class GIFImage
{
	private String fname;
	private int height;
	private int width;
	private BufferedImage myBufferedImage = null;
	private short [][] RedChannel = null;
	private short [][] GreenChannel = null;
	private short [][] BlueChannel = null;
	private short [][] GrayChannel = null;
	
	protected GIFImagePanel panel;
	
	// The transparency level, not used
	private int alpha = (int)0xFF000000;
				
	public GIFImage(String fname) throws ImageGSException
	{
		// JDK 1.4    Ȳ . (2002/12/23)
		// ࿡ 1.4 ̻  쿡 ó ð Ͽ, try ~ catch  ּ ޱ ٶ.
		try 
		{
			Class.forName("javax.imageio.ImageIO");	
		}
		catch (ClassNotFoundException e) 
		{
			throw new ImageGSException(this.getClass().getName() +  " >> "
				+ ErrorMsg.ERRORSUPPORTJDK14LATER );
		}
		
		this.fname = fname;
	}
	
	public int getHeight()
	{
		return height;	
	}
	
	public int getWidth()
	{
		return width;
	}

	public short[][] getRedChannel()
	{
		return (short[][])RedChannel;
	}

	public short[][] getGreenChannel()
	{
		return (short[][])GreenChannel;
	}

	public short[][] getBlueChannel()
	{
		return (short[][])BlueChannel;
	}

	public short[][] getGrayChannel()
	{
		return (short[][])GrayChannel;
	}

	// Get pixel values
	//
	// !!
	// JPEG, PPM  о϶ getColorModel().getRed(...) ,
	// PNG/GIF  getRGBdefault().getRed(...) ġϿ Ѵ.
	// ׷  more than component per pixel ̶  ޽  ȴ.
	// 
	private short getR(int x, int y) {
		
		ColorModel cm = ColorModel.getRGBdefault();
		
		return (short) cm.getRed(myBufferedImage.getRGB(x,y));
		
		//return (short)(myBufferedImage.getColorModel().getRGBdefault().getRed(myBufferedImage.getRGB(x,y)));
	}

	private short getG(int x, int y) {

		ColorModel cm = ColorModel.getRGBdefault();
		
		return (short) cm.getGreen(myBufferedImage.getRGB(x,y));
				
		//return (short)(myBufferedImage.getColorModel().getRGBdefault().getGreen(myBufferedImage.getRGB(x,y)));
	}

	private short getB(int x, int y) {

		ColorModel cm = ColorModel.getRGBdefault();
		
		return (short) cm.getBlue(myBufferedImage.getRGB(x,y));

		//return (short)(myBufferedImage.getColorModel().getRGBdefault().getBlue(myBufferedImage.getRGB(x,y)));
	}

	// Set pixel values
	private int packRGB(short r, short g, short b) {
		return alpha + 65536*r + 256*g + b;
	 }

	private void setPixel(int x, int y, int rgb) {
		myBufferedImage.setRGB(x, y, rgb);
	}

	private void setPixel(int x, int y, short r, short g, short b) {
		setPixel(x, y, packRGB(r,g,b));
	}
	
	public void load() throws ImageGSException
	{
		int i;
		int j;


		try{

			File fp = new File(fname);
			myBufferedImage = ImageIO.read(fp);

			this.height = myBufferedImage.getHeight();
			this.width = myBufferedImage.getWidth();

			// 2 ̹ Ѵ.
			//  Ҵ
			RedChannel = InitIMGBuf.ShortIMGBuf(height, width);
			GreenChannel = InitIMGBuf.ShortIMGBuf(height, width);
			BlueChannel = InitIMGBuf.ShortIMGBuf(height, width);
			GrayChannel = InitIMGBuf.ShortIMGBuf(height, width);

			for(i=0; i<height; i++)
			{
				for(j=0; j<width; j++)
				{
					RedChannel[i][j] = this.getR(j,i);
					GreenChannel[i][j] = this.getG(j,i);
					BlueChannel[i][j] = this.getB(j,i);
					GrayChannel[i][j] =  (short)((float)this.getR(j,i)*0.299  
															+ (float)this.getG(j,i)*0.587 			
															+ (float)this.getB(j,i)*0.114);
				}
			} 	
		}
		catch(Exception e)
		{
			throw new ImageGSException(this.getClass().getName() + " >> "
																+ e.getMessage() );	
		}			
	}

	// Get image panel
	public JPanel getImagePanel() 
	{
		return panel;
	}
	
	public BufferedImage getBufferedImage() throws ImageGSException
	{
		
		try
		{
			File fp = new File(fname);
			myBufferedImage = ImageIO.read(fp);
			this.panel = new GIFImagePanel(myBufferedImage);	

		}
		catch(Exception e)
		{
			throw new ImageGSException(this.getClass().getName() + " >> "
				+ e.getMessage() );	
		}		
					
		return myBufferedImage; 	
	}
}
