/**
 * Class Name	: FormatMatch
 * Description	:    мϿ   ȯ.
 * Date 				: 2003/04/01
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/04/01 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * ش     мϿ   ȯѴ.<p>
 * 
 * - üũ   : JPEG / BMP / PPM / PNG / GIF 5.<p>
 * 
 * [] <p>
 * 
 * imageGS API raw κ ٷ ֱ  Ȯڸ  óϰ ִ.<br>
 * ࿡    üũϷ  FormatMatch Ŭ ϶. <p>
 *  
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class FormatMatch
{
	public static final int JPEG = 1;
	public static final int BMP = 2;
	public static final int PPM = 3;
	public static final int PNG = 4;
	public static final int GIF = 5;
	public static final int UNKNOWNFORMAT = -1;
	
	private char header[] = null;
	
	public FormatMatch() 
	{
		header = new char[10];	
	}

   /**
     * ش   ȯѴ. 
     * 
	 * @param	fname	ش   θ
     * @return   type	1(JPEG), 2(BMP), 3(PPM), 4(PNG), 5(GIF), -1(UNKOWNFORMAT)
     * @exception ImageGSException fname ̰ų   
     */	
	public int match(String fname)	throws ImageGSException
	{
		int type = -5;
		
		FileInputStream in = null;
		
		if(fname == null) 
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
					+ ErrorMsg.ERRORUSERVALUEISNULL );	
		}
		else 
		{
			File fp = new File(fname);
			if(fp.exists() == false) 
			{
				throw new ImageGSException(this.getClass().getName() + " >> " 
					+ ErrorMsg.ERRORTHISFILEISNOTEXIST );
			}
			
			try
			{
				in = new FileInputStream(fp);
				
				// 10 character оδ.
				header[0] = (char)in.read();
				header[1] = (char)in.read();
				header[2] = (char)in.read();
				header[3] = (char)in.read();
				header[4] = (char)in.read();
				header[5] = (char)in.read();
				header[6] = (char)in.read();
				header[7] = (char)in.read();
				header[8] = (char)in.read();
				header[9] = (char)in.read();
				if(in != null) in.close();
				
				String str_header = new String(header);
				
				if( StringUtil.matchStr(str_header, "JFIF") ) type = JPEG;
				else if( StringUtil.matchStr(str_header, "BM") ) type = BMP;
				else if( StringUtil.matchStr(str_header, "P6") ) type = PPM;
				else if( StringUtil.matchStr(str_header, "PNG") ) type = PNG;
				else if( StringUtil.matchStr(str_header, "GIF89a") || StringUtil.matchStr(str_header, "GIF87a") ) type = GIF;
				else type = UNKNOWNFORMAT;
			}
			catch(IOException e)
			{
				if(in != null) try { in.close(); } catch(IOException se) {}
				
				throw new ImageGSException(this.getClass().getName() + " >> " 
											+ e.getMessage());			
			}
		}
		
		return type;
	}
}
