/**
 * Class Name	: NewIMGFileIO
 * Description	: image file handling class.
 * Date 				: 2003/06/29
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2001/06/29 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.Exception.*;

/**
 *   ڵ鸵. <p>
 * 
 *     : JPEG, PNG, PPM, BMP, RAW, GIF (all, only color type)<p>
 * 
 * IMGFileIO  short type 2 迭 ,  Ŭ short, double, integer type<br>
 * Ÿ 2  ۸  Ͽ  δ. , IMGFileIO κ    IMGFileIO Ѵ.<p>
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class ExtIMGFileIO extends IMGFileIO
{	
	private String filename = null;
	
	private short[][] sRedChannel = null;
	private short[][] sGreenChannel = null;
	private short[][] sBlueChannel = null;	
	private short[][] sGrayChannel = null;
	private short[][] sBinaryChannel = null;
	
	/**
	 * 
	 */
	public ExtIMGFileIO()	
	{
		super();
		sRedChannel = null;
		sGreenChannel = null;
		sBlueChannel = null;
		sGrayChannel = null;
		sBinaryChannel = null;
		filename = null;
	}
	
	// object short[][]  mappingѴ.
	private void colorMapping(Object Out_Red_ch, 
										Object Out_Green_ch, 
										Object Out_Blue_ch) 
		throws ImageGSException
	{
		if(Out_Red_ch instanceof double[][] 
			&& Out_Green_ch instanceof double[][]
			&& Out_Blue_ch instanceof double[][])
		{
			sRedChannel = TypeConv2GrayIMG.Double2ShortGrayIMG( (double [][])Out_Red_ch );
			sGreenChannel = TypeConv2GrayIMG.Double2ShortGrayIMG( (double [][])Out_Green_ch );
			sBlueChannel = TypeConv2GrayIMG.Double2ShortGrayIMG( (double [][])Out_Blue_ch );
		}
		else if(Out_Red_ch instanceof int[][]			
					&& Out_Green_ch instanceof int[][]
					&& Out_Blue_ch instanceof int[][])
		{
			sRedChannel = TypeConv2GrayIMG.Integer2ShortGrayIMG( (int [][])Out_Red_ch );
			sGreenChannel = TypeConv2GrayIMG.Integer2ShortGrayIMG( (int [][])Out_Green_ch );
			sBlueChannel = TypeConv2GrayIMG.Integer2ShortGrayIMG( (int [][])Out_Blue_ch );			
		}
		else if(Out_Red_ch instanceof short[][]			
					&& Out_Green_ch instanceof short[][]
					&& Out_Blue_ch instanceof short[][])
		{
			sRedChannel = CopyIMGBuf.CopyShortGrayIMGBuf( (short [][])Out_Red_ch );
			sGreenChannel = CopyIMGBuf.CopyShortGrayIMGBuf( (short [][])Out_Green_ch );
			sBlueChannel = CopyIMGBuf.CopyShortGrayIMGBuf( (short [][])Out_Blue_ch );		
		}
	}

	// object short[][]  mappingѴ.
	private void grayMapping(Object Out_Gray_ch) throws ImageGSException
	{
		if(Out_Gray_ch instanceof double[][] )
		{
			sGrayChannel = TypeConv2GrayIMG.Double2ShortGrayIMG( (double [][])Out_Gray_ch );
		}
		else if(Out_Gray_ch instanceof int[][])
		{
			sGrayChannel = TypeConv2GrayIMG.Integer2ShortGrayIMG( (int [][])Out_Gray_ch );
		}
		else if(Out_Gray_ch instanceof short[][])
		{
			sGrayChannel = CopyIMGBuf.CopyShortGrayIMGBuf( (short [][])Out_Gray_ch );
		}
	}

	// object short[][]  mappingѴ.
	private void binaryMapping(Object Out_Binary_ch) throws ImageGSException
	{
		if(Out_Binary_ch instanceof double[][] )
		{
			sBinaryChannel = TypeConv2GrayIMG.Double2ShortGrayIMG( (double [][])Out_Binary_ch );
		}
		else if(Out_Binary_ch instanceof int[][])
		{
			sBinaryChannel = TypeConv2GrayIMG.Integer2ShortGrayIMG( (int [][])Out_Binary_ch );
		}
		else if(Out_Binary_ch instanceof short[][])
		{
			sBinaryChannel = CopyIMGBuf.CopyShortGrayIMGBuf( (short [][])Out_Binary_ch );
		}
	}
		

	/**
	 * ÷  Ѵ.
	 */
	public void WriteFileName(Object Out_Red_ch, 
											Object Out_Green_ch, 
											Object Out_Blue_ch)
		throws ImageGSException
	{
		// IMGFileIO ´.
		filename = super.getReadFileName();
		
		// mapping
		colorMapping(Out_Red_ch, Out_Green_ch, Out_Blue_ch);
		super.WriteFileName(filename, 
							sRedChannel, 
							sGreenChannel, 
							sBlueChannel, 
							GetSizeIMG.HeightFromGrayIMG(sRedChannel), 
							GetSizeIMG.WidthFromGrayIMG(sRedChannel)); 	
	}

	/**
	 * ÷  Ѵ.
	 */	
	public void WriteFileName(String filename, 
											Object Out_Red_ch, 
											Object Out_Green_ch, 
											Object Out_Blue_ch)
		throws ImageGSException
	{

		colorMapping(Out_Red_ch, Out_Green_ch, Out_Blue_ch);
		super.WriteFileName(filename, 
							sRedChannel, 
							sGreenChannel, 
							sBlueChannel, 
							GetSizeIMG.HeightFromGrayIMG(sRedChannel), 
							GetSizeIMG.WidthFromGrayIMG(sRedChannel)); 
	}

	/**
	 * ÷  Ѵ.
	 */	
	public void WriteFileName(String filename, 
											Object Out_Red_ch, 
											Object Out_Green_ch, 
											Object Out_Blue_ch,
											int Height,
											int Width)
		throws ImageGSException
	{

		colorMapping(Out_Red_ch, Out_Green_ch, Out_Blue_ch);
		super.WriteFileName(filename, 
							sRedChannel, 
							sGreenChannel, 
							sBlueChannel, 
							Height, 
							Width); 
	}
	

	/**
	 * ϵ  Ѵ.
	 */
	public void WriteGrayFileName(Object Out_Gray_ch) throws ImageGSException
	{
		filename = super.getReadFileName();
		grayMapping(Out_Gray_ch);
		super.WriteGrayFileName(filename, sGrayChannel, 
									GetSizeIMG.HeightFromGrayIMG(sGrayChannel), 
									GetSizeIMG.WidthFromGrayIMG(sGrayChannel));		
	}
	
	/**
	 * ϵ  Ѵ.
	 */
	public void WriteGrayFileName(String filename, Object Out_Gray_ch) throws ImageGSException
	{
		grayMapping(Out_Gray_ch);
		
		super.WriteGrayFileName(filename, 
											sGrayChannel,
											GetSizeIMG.HeightFromGrayIMG(sGrayChannel),
											GetSizeIMG.WidthFromGrayIMG(sGrayChannel));		
	}
	
	/**
	 * ϵ  Ѵ.
	 */
	public void WriteGrayFileName(String filename, Object Out_Gray_ch, int height, int width) throws ImageGSException
	{
		grayMapping(Out_Gray_ch);
		super.WriteGrayFileName(filename, sGrayChannel, height, width);
	}
	

	/**
	 *   Ѵ.
	 */
	public void WriteBinaryFileName(Object Out_Binary_ch) throws ImageGSException
	{
		filename = super.getReadFileName();
		binaryMapping(Out_Binary_ch);
		super.WriteBinaryFileName(filename, 
												sBinaryChannel, 
												GetSizeIMG.HeightFromGrayIMG(sBinaryChannel), 
												GetSizeIMG.WidthFromGrayIMG(sBinaryChannel));		
	}
	
	/**
	 *   Ѵ.
	 */
	public void WriteBinaryFileName(String filename, Object Out_Binary_ch) throws ImageGSException
	{
		binaryMapping(Out_Binary_ch);
		super.WriteBinaryFileName(filename, 
												sBinaryChannel, 
												GetSizeIMG.HeightFromGrayIMG(sBinaryChannel), 
												GetSizeIMG.WidthFromGrayIMG(sBinaryChannel));		
	}

	/**
	 *   Ѵ.
	 */
	public void WriteBinaryFileName(String filename, Object Out_Binary_ch, int Height, int Width) throws ImageGSException
	{
		binaryMapping(Out_Binary_ch);
		super.WriteBinaryFileName(filename, 
												sBinaryChannel, 
												Height, 
												Width);		
	}
		
	/**
	 * wrapper method
	 */
	public void writeFileName(Object Out_Red_ch, 
											Object Out_Green_ch, 
											Object Out_Blue_ch)
		throws ImageGSException
	{
		WriteFileName(Out_Red_ch, 
							Out_Green_ch, 
							Out_Blue_ch
							); 	
	}

	/**
	 * wrapper method
	 */	
	public void writeFileName(String filename, 
											Object Out_Red_ch, 
											Object Out_Green_ch, 
											Object Out_Blue_ch)
		throws ImageGSException
	{
		WriteFileName(filename, 
							Out_Red_ch, 
							Out_Green_ch, 
							Out_Blue_ch);
	}

	/**
	 * wrapper method
	 */	
	public void writeFileName(String filename, 
											Object Out_Red_ch, 
											Object Out_Green_ch, 
											Object Out_Blue_ch,
											int Height, 
											int Width) 
		throws  ImageGSException
	{
		
		WriteFileName(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);
	}

									
	/**
	 * wrapper method
	 */
	public void writeGrayFileName(Object Out_Gray_ch) throws ImageGSException
	{
		WriteGrayFileName(Out_Gray_ch); 
	}

	/**
	 * wrapper method
	 */
	public void writeGrayFileName(String filename, Object Out_Gray_ch) throws ImageGSException
	{
		WriteGrayFileName(filename, Out_Gray_ch);
	}

	/**
	 * wrapper method
	 */
	public void writeGrayFileName(String filename, Object Out_Gray_ch, int Height, int Width) throws ImageGSException
	{
		WriteGrayFileName(filename, Out_Gray_ch, Height, Width);
	}		

	/**
	 * wrapper method
	 */
	public void writeBinaryFileName(Object Out_Binary_ch) throws ImageGSException
	{
		WriteBinaryFileName(Out_Binary_ch);
	}

	/**
	 * wrapper method
	 */
	public void writeBinaryFileName(String filename, Object Out_Binary_ch) throws ImageGSException
	{
		WriteBinaryFileName(filename, Out_Binary_ch);		
	}

	/**
	 * wrapper method
	 */
	public void writeBinaryFileName(String filename, Object Out_Binary_ch, int Height, int Width) throws ImageGSException
	{
		WriteBinaryFileName(filename, Out_Binary_ch, Height, Width);
	}		
}
