/**
 * Class Name	: Bmp2Jpeg
 * Description	: BMP Ÿ ÷  JPEG Ÿ ȯ
 * Date 				: 2002/11/27
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/11/27 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * BMP Ÿ  JPEG Ÿ  ȯѴ.<p>
 *  
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Bmp2Jpeg
{
	private Bmp2Jpeg() {}

   /**
     * BMP JPEG ȯѴ. <p>
     * 
     * , ÷  Ѵ. 
     * 
	 * @param	bmp_fname	BMP  θ
     * @return    jpeg_fname	ȯ JPEG  θ 
     * @exception ImageGSException
     */	
	public static void run(String bmp_fname, String jpeg_fname) throws ImageGSException
	{
		File fp_src = new File(bmp_fname);
		
		// bmp   ʴ´ٸ
		if(!fp_src.exists())
		{
			throw new ImageGSException("Bmp2Jpeg.run() >> " + bmp_fname + " : " 
				+ ErrorMsg.ERRORTHISFILEISNOTEXIST);
		}

	
		IMGFileIO img = new IMGFileIO();
		img.readBMP(bmp_fname);
		
		JPEGImage js = new JPEGImage(jpeg_fname);
		js.save(img.getRedChannel(), img.getGreenChannel(), img.getBlueChannel(), img.getHeight(), img.getWidth());
	}
}

