/**
 * Class Name	: BatchImageConvert
 * Description	: ش 丮    丮 ϴ   ϰ ȯŲ.
 * Date 				: 2002/12/03
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/12/03 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.Util.*;
import java.io.*;

/**
 * ش 丮    丮 ϴ   ϰ ȯŲ.<p>
 * 
 *   ȯ  . <p>
 * 
 * 1) bmp to jpg <br>
 * 2) bmp to png <br>
 * 3) jpg to bmp <br>
 * 4) jpg to png <br>
 * 5) jpg to ppm <br>
 * 6) png to bmp <br>
 * 7) png to jpeg <br>
 * 8) ppm to jpeg <p>
 * 
 * [ 1] ϰ ȯ move ޼ҵ argument list  ! Ư move() Ȯ   .<br>
 * [ 2] Ȯڿ ImageConvert class ޸ ڰ Է Ȯ ҹڸ  Կ Ѵ.<p> 
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class BatchImageConvert
{
	public BatchImageConvert() {}
	
	/**
	 * ش src_directory   dest_directory Ѵ.
	 * 
	 * @param	src_directory	 丮
	 * @param	dest_directory	 丮
	 * @exception	ImageGSException
	 */
	public static void copy(String src_directory, String dest_directory) throws ImageGSException
	{
 		String src_fname;
		String dest_fname;	
		String [] src_FileList = null;

		File dir = new File(src_directory);
		src_FileList = dir.list();
		
		for(int i=0; i<src_FileList.length; i++)
		{
			src_fname = src_directory + File.separator + src_FileList[i];
			dest_fname = dest_directory + File.separator + src_FileList[i];

			FileOperation.copy(src_fname, dest_fname);
		}			
	}

	/**
	 * ش src_directory Ȯڰ src_format  dest_directory dest_format Ϸ ϰ ȯ, Ѵ.
	 * 
	 * @param	src_directory	 丮
	 * @param	src_format	  Ȯ
	 * @param	dest_directory	 丮
	 * @param	dest_format	  Ȯ
	 * @exception	ImageGSException
	 */
	public static void copy(String src_directory, String src_format, String dest_directory, String dest_format) throws ImageGSException
	{
 		String src_fname;
		String dest_fname;	
		String [] src_FileList = null;

        ExtFileFilter nf = new ExtFileFilter(src_format);
        File dir = new File(src_directory);
        src_FileList = dir.list(nf);
       
        for(int i=0; i<src_FileList.length; i++)
        {
			src_fname = src_directory + File.separator + src_FileList[i];
			dest_fname = dest_directory + File.separator + getFilename(src_FileList[i]) + dest_format;
        	ImageConvert.run(src_fname, dest_fname);
        }		
		
	}

	/**
	 * ش src_directory   dest_directory dest_format Ϸ ϰ ȯ, Ѵ.
	 * 
	 * @param	src_directory	 丮
	 * @param	dest_directory	 丮
	 * @param	dest_format	  Ȯ
	 * @exception	ImageGSException
	 */	
	public static void copy(String src_directory, String dest_directory, String dest_format)  throws ImageGSException
	{
   		String src_fname;
		String dest_fname;	
		String [] src_FileList = null;
		
        File dir = new File(src_directory);
        src_FileList = dir.list();
		      
        for(int i=0; i<src_FileList.length; i++)
        {
			src_fname = src_directory + File.separator + src_FileList[i];
			dest_fname = dest_directory + File.separator + getFilename(src_FileList[i]) + dest_format;
			
        	ImageConvert.run(src_fname, dest_fname);
        }			
	}

	/**
	 * ش src_directory   dest_directory ű.
	 * 
	 * @param	src_directory	 丮
	 * @param	dest_directory	 丮
	 * @param	overwrite		  Ǵϴ flag (true/false)
	 * @exception	ImageGSException
	 */	
	public static void move(String src_directory, String dest_directory, boolean overwrite) throws ImageGSException
	{
 		String src_fname;
		String dest_fname;	
		String [] src_FileList = null;
		File tmp = null;		

		File dir = new File(src_directory);
		src_FileList = dir.list();
		
		for(int i=0; i<src_FileList.length; i++)
		{
			src_fname = src_directory + File.separator + src_FileList[i];
			
			//  ƴ 丮 Ѵ.
			tmp = new File(src_fname);
			if(tmp.isDirectory()) continue;
			
			dest_fname = dest_directory + File.separator + src_FileList[i];
			
			FileOperation.move(src_fname, dest_fname, overwrite);
		}			
	}

	/**
	 * ش src_directory Ȯڰ src_format  dest_directory dest_format Ϸ ϰ ȯ, ű.
	 * 
	 * @param	src_directory	 丮
	 * @param	src_format	  Ȯ
	 * @param	dest_directory	 丮
	 * @param	dest_format	  Ȯ
	 * @exception	ImageGSException
	 */
	public static void move(String src_directory, String src_format,  String dest_directory, String dest_format) throws ImageGSException
	{
 		String src_fname;
		String dest_fname;	
		String [] src_FileList = null;
        File tmp = null;		
 
        ExtFileFilter nf = new ExtFileFilter(src_format);
        File dir = new File(src_directory);
        src_FileList = dir.list(nf);


        for(int i=0; i<src_FileList.length; i++)
        {
 			src_fname = src_directory + File.separator + src_FileList[i];

			//  ƴ 丮 Ѵ.
			tmp = new File(src_fname);
			if(tmp.isDirectory()) continue;
			else 
			{			
				dest_fname = dest_directory + File.separator + getFilename(src_FileList[i]) + dest_format;
	        	ImageConvert.run(src_fname, dest_fname);
	        	tmp.delete();	
			}
        }		
		
	}

	/**
	 * ش src_directory   dest_directory dest_format Ϸ ϰ ȯ, ű.
	 * 
	 * @param	src_directory	 丮
	 * @param	dest_directory	 丮
	 * @param	dest_format	  Ȯ
	 * @exception	ImageGSException
	 */		
	public static void move(String src_directory, String dest_directory, String dest_format)  throws ImageGSException
	{
 		String src_fname;
		String dest_fname;	
		String [] src_FileList = null;
        File tmp = null;
        		
        File dir = new File(src_directory);
        src_FileList = dir.list();
                
        for(int i=0; i<src_FileList.length; i++)
        {
			src_fname = src_directory + File.separator + src_FileList[i];
			
			//  ƴ 丮 Ѵ.
			tmp = new File(src_fname);
			if(tmp.isDirectory()) continue;
			else 
			{			
				dest_fname = dest_directory + File.separator + getFilename(src_FileList[i]) + dest_format;
	        	ImageConvert.run(src_fname, dest_fname);
	        	tmp.delete();	
			}
        }			
	}
	
	private static String getFilename(String filename)
	{
		int extName_end = filename.lastIndexOf("."); // Ȯڸ  ġ
		return filename.substring(0, extName_end + 1);	
	}
}
