/**
 * Class Name	: BMPImage
 * Description	: BMP handling class.
 * Date 				: 2002/11/26
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/11/26 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import java.io.*;
import java.awt.*;
import java.awt.image.*;
import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import javax.swing.*;

/**
 * BMP handling Ŭ.<p>
 * 
 * [BMP loading] <p>
 * 
 * ó : http://www.javacool.net/board/view.jsp?id=69&page=4&bbscode=board_java&mMenu=3&sMenu=1 <br>
 *  ҽ  : ̿켱(clepper@javacool.net)<p>
 * 
 * [BMP saving] <p>
 * 
 * ó : http://java2u.wo.to/ <br>
 *  ҽ  :  (sorinury@hotmail.com) <p>
 * 
 *  ҽ Image Ŭ õ  Ͽ, <br>
 *  ҽ BMPImage ̿ õ κ Ͽ. <p>
 * 
 * <xmp>
 * []
 * 
 *  ҽ Ϻ ҽ ƴϴ.
 * 
 * - ε
 * 
 *  1) bmp ε (1 ) ÷ Ÿ(24 )  Ϻκ  Ǵ  .
 *  2) ׷ 16(4), 256(8)   .
 * 
 * - 
 * 
 *  1) save() ϸ  ,   ҷ϶  .
 *
 * -  ε/    ̴.
 * - Linux/Unix ȯ濡      .
 * 
 *  imageGS package  ó ˰  ΰ Ƿ,  
 *   ڵ鸵 е鿡 ñ Ѵ.
 *
 * </xmp> 
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class BMPImage
{
	private String fname;
	private BufferedImage myBufferedImage = null;
	private short [][] RedChannel = null;
	private short [][] GreenChannel = null;
	private short [][] BlueChannel = null;
	private short [][] GrayChannel = null;
	private int alpha = (int)0xFF000000;
	protected BMPImagePanel panel;
		
	// load κ
	private byte[] bytebuffer;
	private int i;
	private int j;

	private int windowLong;
	private short windowInt;
	private DataInputStream d;

	private int BMPsize;			     // size of this header in bytes
	private int BMPreserved;
	private int BMPimageoffset;
	private int BMPheadersize;

	private int BMPwidth;                      // image width in pixels
	private int BMPheight;                     // image height in pixels (if < 0, "top-down")
	private short BMPplanes;                   // no. of color planes: always 1

	private short BMPbitsPerPixel;             // number of bits per pixel: 1, 4, 8, or 24 (no color map)
	private int BMPcompression;                // compression methods used: 0 (none), 1 (8-bit RLE), or 2 (4-bit RLE)
	private int BMPsizeOfBitmap;               // size of bitmap in bytes (may be 0: if so, calculate)
	private int BMPhorzResolution;             // horizontal resolution, pixels/meter (may be 0)
	private int BMPvertResolution;             // vertical resolution, pixels/meter (may be 0)
	private int BMPcolorsUsed;                 // no. of colors in palette (if 0, calculate)
	private int BMPcolorsImportant;    // no. of important colors (appear first in palette) (0 means all are important)
	private Color colorTable[]; //color table

	private int pixels[]; // array of pixels
	
	private int colorIndex;
	private int bytesPerLine;
	private byte scanline[];
	
	
	// save κ 

	private final static int BITMAPFILEHEADER_SIZE = 14;
	private final static int BITMAPINFOHEADER_SIZE = 40;
	// Ʈ   
	private byte bitmapFileHeader[] = new byte[14];
	private byte bfType[] = { 'B', 'M'};
	private int bfSize = 0;
	private int bfReserved1 = 0;
	private int bfReserved2 = 0;
	private int bfOffBits = BITMAPFILEHEADER_SIZE + BITMAPINFOHEADER_SIZE;
	
	// BITMAPINFOHEADER
	private byte bitmapInfoHeader[] = new byte[40];
	private int biSize = BITMAPINFOHEADER_SIZE;
	private int biWidth = 0;
	private int biHeight = 0;
	private int biPlanes = 1;
	private int biBitCount = 24;
	private int biCompression = 0;
	private int biSizeImage = 0x030000;
	private int biXPelsPerMeter = 0x0;
	private int biYPelsPerMeter = 0x0;
	private int biClrUsed = 0;
	private int biClrImportant = 0;
	
	private FileOutputStream fout_stream = null;
	int [] save_bmpdata = null;
	
	public BMPImage(String fname) throws ImageGSException
	{
		this.fname = fname;
	}
	
	public int getHeight()
	{
		return BMPheight;	
	}
	
	public int getWidth()
	{
		return BMPwidth;
	}

	public short[][] getRedChannel()
	{
		return (short[][])RedChannel;
	}

	public short[][] getGreenChannel()
	{
		return (short[][])GreenChannel;
	}

	public short[][] getBlueChannel()
	{
		return (short[][])BlueChannel;
	}

	public short[][] getGrayChannel()
	{
		return (short[][])GrayChannel;
	}
	
	public void load() throws ImageGSException
	{
		FileInputStream fstream = null;
		boolean colortype = true;
		 
		try 
		{
			fstream = new FileInputStream(fname);
			d = new DataInputStream(fstream);
			parseit();

			// ó 24 bit  ÷ ŸԸ  ̹Ƿ  Ȳ ֵ Ǿ,
			// , 16, 256 ÷ Ÿ ٲ  ֵ ߴ.
			//
			// BMPbitsPerPixel = 1̸  
			// BMPbitsPerpixel = 4̸ 4  
			// BMPbitsPerPixel = 8̸ 8  (=׷̷)
			// BMPbitsPerPixel = 24̸ ÷ Ÿ.
			// 2003. 01.21, 1, 4, 8  , 16, 256 Ͽ ÷ Ÿ ٲ.
			if(BMPbitsPerPixel != 24)
			{
				RedChannel = InitIMGBuf.ShortIMGBuf(BMPheight, BMPwidth);
				GreenChannel = InitIMGBuf.ShortIMGBuf(BMPheight, BMPwidth);
				BlueChannel = InitIMGBuf.ShortIMGBuf(BMPheight, BMPwidth);
				GrayChannel = InitIMGBuf.ShortIMGBuf(BMPheight, BMPwidth);
				
				int length = BMPwidth * BMPheight;
				int tmp_width = 0;
				int tmp_height = 0;

				myBufferedImage = new BufferedImage(BMPwidth, BMPheight, BufferedImage.TYPE_INT_RGB);

				// 3 ̷ ƴϹǷ ÷ Ÿ ̷ .
				int [] three_pixels = new int[pixels.length * 3];
				for(i=0; i<pixels.length; i++)
				{
					three_pixels[i] = pixels[i];
					three_pixels[i+1] = pixels[i];
					three_pixels[i+2] = pixels[i];
				}
				
				// 1 2 Ѵ.
				for(i=0; i<length; i++)
				{
					if(tmp_width == BMPwidth)
					{
						tmp_height++;
						tmp_width = 0;	
					}
					
					setPixel(tmp_width, tmp_height, three_pixels[i]);
					
					RedChannel[tmp_height][tmp_width] = getR(tmp_width,tmp_height);
					GreenChannel[tmp_height][tmp_width] = getG(tmp_width, tmp_height);
					BlueChannel[tmp_height][tmp_width] = getB(tmp_width,tmp_height);
					
					
					GrayChannel[tmp_height][tmp_width] = (short)((float)RedChannel[tmp_height][tmp_width]*0.299 
														+ (float)GreenChannel[tmp_height][tmp_width]*0.587 
														+ (float)BlueChannel[tmp_height][tmp_width]*0.114);	
				 	
				 	tmp_width++;
				}	
			}
			else 
			{
				RedChannel = InitIMGBuf.ShortIMGBuf(BMPheight, BMPwidth);
				GreenChannel = InitIMGBuf.ShortIMGBuf(BMPheight, BMPwidth);
				BlueChannel = InitIMGBuf.ShortIMGBuf(BMPheight, BMPwidth);
				GrayChannel = InitIMGBuf.ShortIMGBuf(BMPheight, BMPwidth);
				
				int length = BMPwidth * BMPheight;
				int tmp_width = 0;
				int tmp_height = 0;

				myBufferedImage = new BufferedImage(BMPwidth, BMPheight, BufferedImage.TYPE_INT_RGB);

				// 1 2 Ѵ.
				for(i=0; i<length; i++)
				{
					if(tmp_width == BMPwidth)
					{
						tmp_height++;
						tmp_width = 0;	
					}	
					
					setPixel(tmp_width, tmp_height, pixels[i]);
					
					RedChannel[tmp_height][tmp_width] = getR(tmp_width,tmp_height);
					GreenChannel[tmp_height][tmp_width] = getG(tmp_width, tmp_height);
					BlueChannel[tmp_height][tmp_width] = getB(tmp_width,tmp_height);
					
					GrayChannel[tmp_height][tmp_width] = (short)((float)RedChannel[tmp_height][tmp_width]*0.299 
														+ (float)GreenChannel[tmp_height][tmp_width]*0.587 
														+ (float)BlueChannel[tmp_height][tmp_width]*0.114);	
				 	
				 	tmp_width++;
				} 
			}			

			fstream.close();
		}
		catch(IOException e)
		{		
			if(fstream != null) try { fstream.close(); } catch(IOException se) {}
			throw new ImageGSException(this.getClass().getName() + " >> "
																+ e.getMessage() );	
		}			

		if(colortype == false)
		{
			 throw new ImageGSException(this.getClass().getName() + " >> " 
			 												+ ErrorMsg.ERRORTHISISNOTCOLORIMAGE );
		}
	}

	public BufferedImage getBufferedImage()
					throws ImageGSException
	{
		if(myBufferedImage == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> "  
											+ ErrorMsg.ERRORBUFFEREDIMAGEISNULL );	
		}

		this.panel = new BMPImagePanel(myBufferedImage);		

		return myBufferedImage;			
	}

	// Get image panel
	public JPanel getImagePanel() {
		return panel;
	}
	
	private short getR(int x, int y) 
	{
		return (short)(myBufferedImage.getColorModel().getRed(myBufferedImage.getRGB(x,y)));
	}

	private short getG(int x, int y) 
	{
		return (short)(myBufferedImage.getColorModel().getGreen(myBufferedImage.getRGB(x,y)));
	}

	private short getB(int x, int y) 
	{
		return (short)(myBufferedImage.getColorModel().getBlue(myBufferedImage.getRGB(x,y)));
	}

	private void setPixel(int x, int y, int rgb) 
	{
		myBufferedImage.setRGB(x, y, rgb);
	}

	private void setPixel(int x, int y, short r, short g, short b) 
	{
		setPixel(x, y, packRGB(r,g,b));
	}

	private int packRGB(short r, short g, short b) 
	{
		return alpha + 65536*r + 256*g + b;
	 }
	 	
	//=============   ҽ Դϴ. (loading κ) ===============//

	private synchronized void  parseit() throws IOException
	{
		parseit(0);
	}

	private synchronized void  parseit(int typeFlag) throws IOException
	{
		byte[] f_long =new byte[4];
		byte[] f_int = new byte[2];
		byte[] parmBuffer;
		byte[] tempBuffer;

		short x;
		short y;
		short x2;
		short y2;
		short count = 0;

		//begin bitmap header
		if (typeFlag == 0) 
		{  
			// read header - bitmapfile
			tempBuffer = null;
			tempBuffer = new byte[2];  //get BM
			d.read(tempBuffer);
			
			//System.out.println ("tempBuffer " + new String(tempBuffer,0));
			BMPsize = readLong(d); //key  4 bytes
			//System.out.println ("size " + BMPsize);
			BMPreserved = readLong(d);
			//System.out.println ("reservede " + BMPreserved);
			BMPimageoffset = readLong(d);
			//System.out.println ("offset " + BMPimageoffset);
		}
		
		//System.out.println ("in bmpstream" );
		BMPheadersize = readLong(d);
		//System.out.println ("BMPheadersize " + BMPheadersize);
		BMPwidth = readLong(d); 
		//System.out.println ("BMPwidth " + BMPwidth);
		BMPheight = readLong(d); 
		//System.out.println ("BMPheight " + BMPheight);
		BMPplanes = readInt(d); 
		//System.out.println ("BMPplanes " + BMPplanes);
		BMPbitsPerPixel = readInt(d); 
		//System.out.println ("BMPbitsPerPixel " + BMPbitsPerPixel);
		BMPcompression = readLong(d); 
		//System.out.println ("BMPcompression " + BMPcompression);
		BMPsizeOfBitmap = readLong(d); 
		//System.out.println ("BMPsizeOfBitmap " + BMPsizeOfBitmap);
		BMPhorzResolution = readLong(d); 
		//System.out.println ("BMPhorzResolution " + BMPhorzResolution);
		BMPvertResolution = readLong(d); 
		//System.out.println ("BMPvertResolution " + BMPvertResolution);
		BMPcolorsUsed = readLong(d); 
		//System.out.println ("BMPcolorsUsed " + BMPcolorsUsed);
		BMPcolorsImportant = readLong(d); 
		//System.out.println ("BMPcolorsImportant " + BMPcolorsImportant);

		pixels = new int [BMPwidth * (BMPheight +1)];

		if (BMPbitsPerPixel== 1)
		{
			colorTable = new Color[2];
			
			for (i =0; i < 2; i++)
			{
				colorTable[i] = win2Color(readLong(d));
			}
			
			bytesPerLine = BMPwidth/8;  //width is # of pixels, twice as many bytes as pixles
										// only used to read in scan lines
			
			if (bytesPerLine * 8 < BMPwidth) 
			{  
				// if pixel is on odd boundary 
				bytesPerLine++;
			}
			
			while (bytesPerLine % 4 != 0)
				bytesPerLine++; // get even boundary, DWORD boundary

			scanline = new byte[bytesPerLine]; // declare a buffer sufficient for 1 line
			
			for (i = BMPheight -1; i >= 0; i--)
			{    
				// bottom up, start with last line
				d.readFully(scanline,0, bytesPerLine);  // read in a line
				for (j = 0; j < BMPwidth; j+=8)
				{
					colorIndex = (scanline[j/8])>>7 & 0x01;  // 1st 4 bits of byte shifted and masked
					pixels[i*BMPwidth + j]= colorTable[colorIndex].getRGB();
					colorIndex = (scanline[j/8])>>6 & 0x01;  // 1st 4 bits of byte shifted and masked
					pixels[i*BMPwidth + j +1 ]= colorTable[colorIndex].getRGB();
					colorIndex = (scanline[j/8])>>5 & 0x01;  // 1st 4 bits of byte shifted and masked
					pixels[i*BMPwidth + j +2]= colorTable[colorIndex].getRGB();
					colorIndex = (scanline[j/8])>>4 & 0x01;  // 1st 4 bits of byte shifted and masked
					pixels[i*BMPwidth + j +3]= colorTable[colorIndex].getRGB();
					colorIndex = (scanline[j/8])>>3 & 0x01;  // 1st 4 bits of byte shifted and masked
					pixels[i*BMPwidth + j +4]= colorTable[colorIndex].getRGB();
					colorIndex = (scanline[j/8])>>2 & 0x01;  // 1st 4 bits of byte shifted and masked
					pixels[i*BMPwidth + j +5]= colorTable[colorIndex].getRGB();
					colorIndex = (scanline[j/8])>>1 & 0x01;  // 1st 4 bits of byte shifted and masked
					pixels[i*BMPwidth + j +6]= colorTable[colorIndex].getRGB();
					colorIndex = (scanline[j/8]) & 0x01;  // 1st 4 bits of byte shifted and masked
					pixels[i*BMPwidth + j +7]= colorTable[colorIndex].getRGB();
				}
			}
		} // if bpp = 1

		if (BMPbitsPerPixel== 4)
		{
			colorTable = new Color[16];
			for (i =0; i < 16; i++){
				colorTable[i] = win2Color(readLong(d));
			}
			
			bytesPerLine = BMPwidth/2;   //width is # of pixels, twice as many bytes as pixles
										 // only used to read in scan lines
			if (bytesPerLine * 2 < BMPwidth) {  // if pixel is on odd boundary 
				bytesPerLine++;
			}
			
			while (bytesPerLine % 4 != 0)
				bytesPerLine++; // get even boundary, DWORD boundary

			scanline = new byte[bytesPerLine]; // declare a buffer sufficient for 1 line

			for (i = BMPheight -1; i >= 0; i--)
			{     
				// bottom up, start with last line
				d.readFully(scanline,0, bytesPerLine);  // read in a line

				for (j = 0; j < BMPwidth; j+=2)
				{
					colorIndex = (scanline[j/2]>>4) & 0x0F;  // 1st 4 bits of byte shifted and masked
					pixels[i*BMPwidth + j]= colorTable[colorIndex].getRGB();
					colorIndex = (scanline[j/2]) & 0x0F;  // 2nd 4 bits masked
					pixels[i*BMPwidth + j + 1]= colorTable[colorIndex].getRGB();
				}
			}
		} // if bpp = 4

		if (BMPbitsPerPixel== 8)
		{
			colorTable = new Color[256];
			for (i =0; i < 256; i++)
			{
				colorTable[i] = win2Color(readLong(d));
			}
			
			bytesPerLine = BMPwidth;   //width is # of pixels, 1 pixels for each byte
			
			while (bytesPerLine % 4 != 0)
				bytesPerLine++; // get even boundary

			scanline = new byte[bytesPerLine]; // declare a buffer sufficient for 1 line

			//System.out.println ("bytesPerLine " + bytesPerLine );


			for (i = BMPheight -1; i >= 0; i--)
			{    
				// bottom up, start with last line
				d.readFully(scanline);  // read in a line
				for (j = 0; j < BMPwidth; j++)
				{
					colorIndex = scanline[j] ;
					
					if (colorIndex <0)
						colorIndex +=256;
					
					pixels[i*BMPwidth + j]= colorTable[colorIndex].getRGB();
				}
			}
		} // if bpp = 8

		if (BMPbitsPerPixel== 24)
		{
			//System.out.println ("in bmpstream bpp =24 ");
			int winBlue;
			int winGreen;
			int winRed;
			bytesPerLine = 3 * BMPwidth;   //width is # of pixels, 3 bytes for each pixel

			while (bytesPerLine % 4 != 0)
				bytesPerLine++; // get even boundary

			scanline = new byte[bytesPerLine+4]; // declare a buffer sufficient for 1 line
			
			for (i = BMPheight -1; i >= 0; i--){    // bottom up, start with last line
				d.readFully(scanline,0, bytesPerLine);  // read in a line

				for (j = 0; j < bytesPerLine; j+=3){ //work with 3 bytes at a time
					//j
					//j+1
					//j+2
					winBlue =   (int) (scanline[j]) & 0xff;
					winGreen = ((int) (scanline[j+1]) & 0xff) << 8;
					winRed =   ((int) (scanline[j+2]) & 0xff) << 16;
					pixels[i*BMPwidth + j/3]= 0xff000000;
					pixels[i*BMPwidth + j/3] |= winRed;
					pixels[i*BMPwidth + j/3] |= winGreen;
					pixels[i*BMPwidth + j/3] |= winBlue;
				}
			}
		} // if bpp = 24
	}
	
	private Color win2Color( int colorValue) 
	{
		// windows does it backwards
		int rgbBlue   = 16711680; // ff0000
		int rgbGreen  =    65280; // 00ff00
		int rgbRed    =      255; // 0000ff
		int javaBlue ;
		int javaGreen;
		int javaRed  ;

		javaRed = (int)((colorValue & rgbBlue)/ 65536);
		javaGreen = (int)((colorValue & rgbGreen)/ 256);
		javaBlue = (int)((colorValue & rgbRed));
		
		return( new Color (javaRed , javaGreen, javaBlue));
	}

 
	private int readLong( DataInputStream d )
	{
		byte[] longBuf = new byte[4];

		try{
			d.readFully(longBuf);
			return flipLong(longBuf);
		} catch(IOException e){
			//System.err.println(e);
			return 99;
		}
	}

	private short readInt(DataInputStream d)
	{
		byte[] intBuf =new byte[2];
		try{
			d.readFully(intBuf);
			return flipInt(intBuf);
		}  catch(IOException e){
			//System.err.println(e);
			return 99;
		}
	}

	private int flipLong( byte[] byteFlip)
	{
		DataInputStream dl;
		ByteArrayInputStream  b_in;
		byte[] bytebuffer;

		bytebuffer = new byte[4];
		bytebuffer[0] = byteFlip[3];
		bytebuffer[1] = byteFlip[2];  
		bytebuffer[2] = byteFlip[1];  
		bytebuffer[3] = byteFlip[0];  
		
		b_in = new ByteArrayInputStream(bytebuffer);
		dl = new DataInputStream(b_in);

		try{
			return dl.readInt();
		}
		catch(IOException e) { } //System.err.println(e);}
	
		return 0;
	}

 
	private short flipInt( byte[] byteFlip)
	{
		DataInputStream d;
		ByteArrayOutputStream b_out;
		ByteArrayInputStream  b_in;
		byte[] bytebuffer;
		bytebuffer = new byte[2];

		bytebuffer[0] = byteFlip[1];
		bytebuffer[1] = byteFlip[0];  
		b_in = new ByteArrayInputStream(bytebuffer);
		d = new DataInputStream(b_in);
		
		try{
			return d.readShort();
		}
		catch(IOException e){ } //System.err.println(e);}
		return 0;
	}

	public void save(String OutFname, short[][] OutGrayChannel, int OutHeight, int OutWidth)
							throws ImageGSException
	{
		this.fname = OutFname;
		this.save(OutGrayChannel, OutHeight, OutWidth);	
	}
		
	public void save(short[][] OutGrayChannel, int OutHeight, int OutWidth)
								throws ImageGSException
	{
		this.save(OutGrayChannel, OutGrayChannel, OutGrayChannel, OutHeight, OutWidth);	
	}

	public void save(String OutFname, 
									short[][] OutRedChannel, 
									short[][] OutGreenChannel, 
									short[][] OutBlueChannel, 
									int OutHeight, int OutWidth
								)
								throws ImageGSException
	{
		this.fname = OutFname;
		this.save(OutRedChannel, OutGreenChannel, OutBlueChannel, OutHeight, OutWidth);	
	}

	public void save(short[][] OutRedChannel, 
									short[][] OutGreenChannel, 
									short[][] OutBlueChannel, 
									int OutHeight, int OutWidth
								)
								throws ImageGSException
	{
		BufferedImage outputBufferedImage = null;
		short r, g, b;
		int count = 0;
		
		try 
		{
			outputBufferedImage = new BufferedImage(OutWidth,OutHeight, BufferedImage.TYPE_INT_RGB);
			fout_stream = new FileOutputStream(fname);
			
			save_bmpdata = new int[OutHeight * OutWidth];
			
			// 2 1 .
			for(i=0; i<OutHeight; i++)
			{
				for(j=0; j<OutWidth; j++)
				{
					r = OutRedChannel[i][j];
					g = OutGreenChannel[i][j];
					b = OutBlueChannel[i][j];
					
					outputBufferedImage.setRGB(j,i,packRGB(r,g,b));	
					save_bmpdata[count] = outputBufferedImage.getRGB(j,i);

					count++;
				}	
			}
			
			int pad = (4-((OutWidth*3)%4))*OutHeight;
			biSizeImage = ((OutWidth*OutHeight)*3)+pad;
			bfSize = biSizeImage + BITMAPFILEHEADER_SIZE + BITMAPINFOHEADER_SIZE;
			biWidth = OutWidth;
			biHeight = OutHeight;
					
			writeBitmapFileHeader();
			writeBitmapInfoHeader();
			writeBitmap();
			fout_stream.close();
		}
		catch(Exception e)
		{
			if(fout_stream != null) try { fout_stream.close(); } catch(IOException se) {}
			throw new ImageGSException(this.getClass().getName() + " >> "
																+ e.getMessage() );	
		}			
	}

	//==============   ҽ κԴϴ.(saving κ) ==========//
	// Ʈ Ͽ ϱ
	private void writeBitmap() throws Exception
	{
		int size;
		int value;
		int j;
		int i;
		int rowCount;
		int rowIndex;
		int lastRowIndex;
		int pad;
		int padCount;
		byte rgb[] = new byte[3];
		size = (biWidth*biHeight)-1;
		pad = 4-((biWidth*3)%4);
		
		if(pad==4)
			pad=0;
			
		rowCount = 1;
		padCount = 0;
		rowIndex = size-biWidth;
		lastRowIndex = rowIndex;
		
		try
		{
			for(j=0; j<size; j++) 
			{
				value = save_bmpdata[rowIndex];
				rgb[0] = (byte)(value&0xFF);
				rgb[1] = (byte)((value>>8)&0xFF);
				rgb[2] = (byte)((value>>16)&0xFF);
				
				fout_stream.write(rgb);
				if (rowCount == biWidth)
				{
					padCount += pad;
					for(i=1; i<=pad; i++)
					{
						fout_stream.write(0x00);
					}
					rowCount = 1;
					rowIndex = lastRowIndex - biWidth;
					lastRowIndex = rowIndex;
				} else
				{
					rowCount++;
				}
				
				rowIndex++;
			}
			
			bfSize += padCount-pad;
			biSizeImage += padCount - pad;
		} 
		catch(Exception e)
		{
			throw e;
		}
	}
	
	// Ʈ Ͽ ϱ
	private void writeBitmapFileHeader() throws Exception
	{
		try
		{
			fout_stream.write(bfType);
			fout_stream.write(intToDWord(bfSize));
			fout_stream.write(intToWord(bfReserved1));
			fout_stream.write(intToWord(bfReserved2));
			fout_stream.write(intToDWord(bfOffBits));
		} 
		catch(Exception e)
		{
			throw e;
		}
	}
	
	// Ʈ Ͽ ϱ
	private void writeBitmapInfoHeader() throws Exception
	{
		try
		{
			fout_stream.write(intToDWord(biSize));
			fout_stream.write(intToDWord(biWidth));
			fout_stream.write(intToDWord(biHeight));
			fout_stream.write(intToWord(biPlanes));
			fout_stream.write(intToWord(biBitCount));
			fout_stream.write(intToDWord(biCompression));
			fout_stream.write(intToDWord(biSizeImage));
			fout_stream.write(intToDWord(biXPelsPerMeter));
			fout_stream.write(intToDWord(biYPelsPerMeter));
			fout_stream.write(intToDWord(biClrUsed));
			fout_stream.write(intToDWord(biClrImportant));
		} 
		catch(Exception e)
		{
			throw e;
		}
	}
	
	// Visual C++ WORDŸ  ڹٿ ٲٱ
	private byte[] intToWord(int parValue)
	{
		byte retValue[] = new byte[2];
		retValue[0] = (byte)(parValue & 0x00FF);
		retValue[1] = (byte)((parValue>>8)&0x00FF);
		
		return retValue;
	}
	
	// Visual C++ DWORDŸ  ڹٿ ٲٱ
	private byte[] intToDWord(int parValue)
	{
		byte retValue[] = new byte[4];
		
		retValue[0] = (byte)(parValue&0x00FF);
		retValue[1] = (byte)((parValue>>8) & 0x000000FF);
		retValue[2] = (byte)((parValue>>16) & 0x000000FF);
		retValue[3] = (byte)((parValue>>24) & 0x000000FF);
		
		return retValue;
	}
}