
import java.io.File;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.IMGFileIO;

public class Compare {

	public int width;
	public int height;
	public int pixelNum;
	public int matchPoint;
	
	public Compare()
	{
		width = 0;
		height = 0;
		pixelNum = 0;
		matchPoint = 0;
	}
	
	public void compareSize(short [][] original, short [][] tempImage)
	{
		int originalWidth = 0;
		int originalHeight = 0;
		int tempImageWidht = 0;
		int tempImageHeight = 0;
		try{
			originalHeight = original.length;
			originalWidth = original[0].length;
		}
		catch(Exception e)
		{
			originalHeight = 73;
			originalWidth = 30;
		}
		
		try{
			tempImageHeight = tempImage.length;
			tempImageWidht = tempImage[0].length;
		}
		catch(Exception e)
		{
			tempImageHeight = 73;
			tempImageWidht = 30;
		}
		
		//height Ѵ.
		if(originalHeight <= tempImageHeight)
		{
			height = originalHeight;
		}
		else
		{
			height = tempImageHeight;
		}
		
		//width Ѵ.
		if(originalWidth <= tempImageWidht)
		{
			width = originalWidth;
		}
		else
		{
			width = tempImageWidht;
		}
	}
	
	public void compareImage(short [][] original, short [][] tempImage)
	{
		//width height Ѵ.
		compareSize(original, tempImage);
		
		int i = 0;
		int j = 0;
		
		matchPoint = 0;

		for(i = 0; i < height; i++)
		{
			for( j = 0; j < width; j++)
			{
				try{
					if(original[i][j] == tempImage[i][j])
					{
						matchPoint++;
					}
					else
					{
						matchPoint -= 2;
					}
				}
				catch(Exception e)
				{
					matchPoint -= 2;
				}
			}
		}
	}
	
	public int compareNumber(short [][] original) throws ImageGSException
	{
		int result = 0;
		int max = 0;
		int i = 0;
		short [][] temp = null;
		
		String orig_frame;
		String imagedata_directory;
		String absolute_orig_read_frame;
		IMGFileIO img = new IMGFileIO();

		// ޾ƿ
		File f = new File("readme.txt");
		String path = f.getAbsolutePath();
		int length;
		length = path.length() - 10;
		path = path.substring(0,length);

		imagedata_directory = path + "num/";

		for(i =0; i <= 9; i++)
		{
			orig_frame = i + ".jpg";
			absolute_orig_read_frame = imagedata_directory + orig_frame;
			img.readFileName(absolute_orig_read_frame);
			
			//System.out.println(absolute_orig_read_frame);
			temp = img.getGrayChannel();
			compareImage(original, temp);
			//System.out.println(orig_frame + " : " + matchPoint);
			if(i == 0)
			{
				result = matchPoint;
			}
			if(result < matchPoint)
			{
				result = matchPoint;
				max = i;
			}
			if(result > 2000)
			{
				break;
			}
		}
		
		
		return max;
	}
	
	public String compareHangul(short [][] original) throws ImageGSException
	{
		String resultHan = null;
		int i = 0;
		int max = 0;
		int max2 = 0;
		int result = 0;
		short [][] temp = null;
		
		String orig_frame;
		String imagedata_directory;
		String absolute_orig_read_frame;
		IMGFileIO img = new IMGFileIO();

		// ޾ƿ
		File f = new File("readme.txt");
		String path = f.getAbsolutePath();
		int length;
		length = path.length() - 10;
		path = path.substring(0,length);

		imagedata_directory = path + "Han/";
		
		for(i = 1; i <= 4; i++)
		{
			orig_frame = i + "_.jpg";
			absolute_orig_read_frame = imagedata_directory + orig_frame;
			img.readFileName(absolute_orig_read_frame);
			//System.out.println(absolute_orig_read_frame);
			temp = img.getGrayChannel();
			compareImage(original, temp);
			if(i == 1)
			{
				result = matchPoint;
				max = i;
			}
				
			if(result < matchPoint)
			{
				result = matchPoint;
				max = i;
			}
			if(result > 2000)
			{
				break;
			}
		}
		
		for(i = 1; i <= 14; i++)
		{
			orig_frame = max + "_" + i + ".jpg";
			absolute_orig_read_frame = imagedata_directory + orig_frame;
			//System.out.println(absolute_orig_read_frame);
			img.readFileName(absolute_orig_read_frame);
			
			temp = img.getGrayChannel();

			compareImage(original, temp);
			if(result < matchPoint)
			{
				result = matchPoint;
				max2 = i;
			}
			if(result > 2000)
			{
				break;
			}
			
		}

		switch (max){
		case 1 :
			switch (max2){
			case 1 :
				resultHan = "";
				break;
				
			case 2 :
				resultHan = "";
				break;
				
			case 3 :
				resultHan = "";
				break;
				
			case 4 :
				resultHan = "";
				break;
				
			case 5 :
				resultHan = "";
				break;
				
			case 6 :
				resultHan = "";
				break;
				
			case 7 :
				resultHan = "";
				break;
				
			case 8 :
				resultHan = "";
				break;
				
			case 9 :
				resultHan = "";
				break;
				
			case 10 :
				resultHan = "";
				break;
				
			case 11 :
				resultHan = "ī";
				break;
				
			case 12 :
				resultHan = "Ÿ";
				break;
				
			case 13 :
				resultHan = "";
				break;
				
			case 14 :
				resultHan = "";
				break;
				
			}
			break;
			
		case 2 :
			switch (max2){
			case 1 :
				resultHan = "";
				break;
				
			case 2 :
				resultHan = "";
				break;
				
			case 3 :
				resultHan = "";
				break;
				
			case 4 :
				resultHan = "";
				break;
				
			case 5 :
				resultHan = "";
				break;
				
			case 6 :
				resultHan = "";
				break;
				
			case 7 :
				resultHan = "";
				break;
				
			case 8 :
				resultHan = "";
				break;
				
			case 9 :
				resultHan = "";
				break;
				
			case 10 :
				resultHan = "ó";
				break;
				
			case 11 :
				resultHan = "Ŀ";
				break;
				
			case 12 :
				resultHan = "";
				break;
				
			case 13 :
				resultHan = "";
				break;
				
			case 14 :
				resultHan = "";
				break;
				
			}
			break;
			
		case 3 :
			switch (max2){
			case 1 :
				resultHan = "";
				break;
				
			case 2 :
				resultHan = "";
				break;
				
			case 3 :
				resultHan = "";
				break;
				
			case 4 :
				resultHan = "";
				break;
				
			case 5 :
				resultHan = "";
				break;
				
			case 6 :
				resultHan = "";
				break;
				
			case 7 :
				resultHan = "";
				break;
				
			case 8 :
				resultHan = "";
				break;
				
			case 9 :
				resultHan = "";
				break;
				
			case 10 :
				resultHan = "";
				break;
				
			case 11 :
				resultHan = "";
				break;
				
			case 12 :
				resultHan = "";
				break;
				
			case 13 :
				resultHan = "Ǫ";
				break;
				
			case 14 :
				resultHan = "";
				break;
				
			}
			break;
			
		case 4 :
			switch (max2){
			case 1 :
				resultHan = "";
				break;
				
			case 2 :
				resultHan = "";
				break;
				
			case 3 :
				resultHan = "";
				break;
				
			case 4 :
				resultHan = "";
				break;
				
			case 5 :
				resultHan = "";
				break;
				
			case 6 :
				resultHan = "";
				break;
				
			case 7 :
				resultHan = "";
				break;
				
			case 8 :
				resultHan = "";
				break;
				
			case 9 :
				resultHan = "";
				break;
				
			case 10 :
				resultHan = "";
				break;
				
			case 11 :
				resultHan = "";
				break;
				
			case 12 :
				resultHan = "";
				break;
				
			case 13 :
				resultHan = "";
				break;
				
			case 14 :
				resultHan = "ȣ";
				break;
				
			}
			break;
			
		}
		
		return resultHan;
	}
}
