/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.Util.CopyIMGBuf;
import com.conv2.imageGS.Util.GetSizeIMG;
import com.conv2.imageGS.Util.InitIMGBuf;

public class PaddedIMG {
    private int height = 0;
    private int width = 0;
    private int zPaddedLength = 0;
    private short[][] orgImage = null;
    private short[][] zPaddedImage = null;

    public PaddedIMG(short[][] image) throws ImageGSException {
        if (image == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "Unknown size of GrayIMG or GrayIMG is null");
        }
        this.orgImage = CopyIMGBuf.CopyShortGrayIMGBuf(image);
        this.height = GetSizeIMG.getHeight(image);
        this.width = GetSizeIMG.getWidth(image);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getPaddedLength() {
        return this.zPaddedLength;
    }

    public short[][] getPaddedImage() throws ImageGSException {
        if (this.zPaddedImage == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "Unknown size of GrayIMG or GrayIMG is null");
        }
        return this.zPaddedImage;
    }

    public short[][] getImage(short[][] paddedImage) {
        return this.getImage(paddedImage, this.height, this.width);
    }

    public short[][] getImage(short[][] paddedImage, int height, int width) {
        short[][] image = InitIMGBuf.ShortIMGBuf(height, width);
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                image[i][j] = paddedImage[i][j];
                ++j;
            }
            ++i;
        }
        return image;
    }

    public short[][] addValue() throws ImageGSException {
        return this.addValue((short)0);
    }

    public short[][] addValue(short var) throws ImageGSException {
        int real_num;
        int result;
        if (var < 0 || var > 255) {
            throw new ImageGSException(String.valueOf(PaddedIMG.class.getName()) + " >> " + "The range of the value don't satisify" + " (0~255)");
        }
        if (this.height >= this.width) {
            int tmp_height;
            result = 0;
            real_num = tmp_height = this.height;
            while (tmp_height >= 2) {
                tmp_height >>= 1;
                ++result;
            }
            this.zPaddedLength = real_num != (int)Math.pow(2.0, result) ? (int)Math.pow(2.0, result + 1) : this.height;
        } else if (this.height < this.width) {
            int tmp_width;
            result = 0;
            real_num = tmp_width = this.width;
            while (tmp_width >= 2) {
                tmp_width >>= 1;
                ++result;
            }
            this.zPaddedLength = real_num != (int)Math.pow(2.0, result) ? (int)Math.pow(2.0, result + 1) : this.width;
        }
        this.zPaddedImage = InitIMGBuf.ShortIMGBuf(this.zPaddedLength, this.zPaddedLength);
        int i = 0;
        while (i < this.height) {
            int j = 0;
            while (j < this.width) {
                this.zPaddedImage[i][j] = this.orgImage[i][j];
                ++j;
            }
            ++i;
        }
        return this.zPaddedImage;
    }
}

