/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.Util.FillIMGBuf;
import com.conv2.imageGS.Util.GetSizeIMG;

public class CenterIMGBuf {
    private CenterIMGBuf() {
    }

    public static short[][] CenterShortGrayIMGBuf(short[][] Image, int pixels) throws ImageGSException {
        return CenterIMGBuf.CenterShortGrayIMGBuf(Image, pixels, pixels);
    }

    public static short[][] CenterShortGrayIMGBuf(short[][] Image, int right_pixels, int bottom_pixels) throws ImageGSException {
        int height = GetSizeIMG.getHeight(Image);
        int width = GetSizeIMG.getWidth(Image);
        if (Image == null) {
            throw new ImageGSException("CenterIMGBuf.CenterShortGrayIMGBuf() >> Unknown size of GrayIMG or GrayIMG is null");
        }
        if (right_pixels < 0 || bottom_pixels < 0) {
            return null;
        }
        short[][] retImage = FillIMGBuf.FillShortGrayIMGBuf((short)0, height, width);
        int half_height = (int)Math.round((double)right_pixels / 2.0);
        int half_width = (int)Math.round((double)bottom_pixels / 2.0);
        int i = 0;
        while (i < height - right_pixels) {
            int j = 0;
            while (j < width - bottom_pixels) {
                retImage[i + half_height][j + half_width] = Image[i][j];
                ++j;
            }
            ++i;
        }
        return retImage;
    }

    public static int[][] CenterIntegerGrayIMGBuf(int[][] Image, int pixels) throws ImageGSException {
        return CenterIMGBuf.CenterIntegerGrayIMGBuf(Image, pixels, pixels);
    }

    public static int[][] CenterIntegerGrayIMGBuf(int[][] Image, int right_pixels, int bottom_pixels) throws ImageGSException {
        int height = GetSizeIMG.getHeight(Image);
        int width = GetSizeIMG.getWidth(Image);
        if (Image == null) {
            throw new ImageGSException("CenterIMGBuf.CenterShortGrayIMGBuf() >> Unknown size of GrayIMG or GrayIMG is null");
        }
        if (right_pixels < 0 || bottom_pixels < 0) {
            return null;
        }
        int[][] retImage = FillIMGBuf.FillIntegerGrayIMGBuf(0, height, width);
        int half_height = (int)Math.round((double)right_pixels / 2.0);
        int half_width = (int)Math.round((double)bottom_pixels / 2.0);
        int i = 0;
        while (i < height - right_pixels) {
            int j = 0;
            while (j < width - bottom_pixels) {
                retImage[i + half_height][j + half_width] = Image[i][j];
                ++j;
            }
            ++i;
        }
        return retImage;
    }

    public static double[][] CenterDoubleGrayIMGBuf(double[][] Image, int pixels) throws ImageGSException {
        return CenterIMGBuf.CenterDoubleGrayIMGBuf(Image, pixels, pixels);
    }

    public static double[][] CenterDoubleGrayIMGBuf(double[][] Image, int right_pixels, int bottom_pixels) throws ImageGSException {
        int height = GetSizeIMG.getHeight(Image);
        int width = GetSizeIMG.getWidth(Image);
        if (Image == null) {
            throw new ImageGSException("CenterIMGBuf.CenterDoubleGrayIMGBuf() >> Unknown size of GrayIMG or GrayIMG is null");
        }
        if (right_pixels < 0 || bottom_pixels < 0) {
            return null;
        }
        double[][] retImage = FillIMGBuf.FillDoubleGrayIMGBuf(0.0, height, width);
        int half_height = (int)Math.round((double)right_pixels / 2.0);
        int half_width = (int)Math.round((double)bottom_pixels / 2.0);
        int i = 0;
        while (i < height - right_pixels) {
            int j = 0;
            while (j < width - bottom_pixels) {
                retImage[i + half_height][j + half_width] = Image[i][j];
                ++j;
            }
            ++i;
        }
        return retImage;
    }
}

