/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.BinaryProc.Binary2GrayIMG;
import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.BMPImage;
import com.conv2.imageGS.IMGFileIO.BufferedImage2Channel;
import com.conv2.imageGS.IMGFileIO.ChannelViewer;
import com.conv2.imageGS.IMGFileIO.GIFImage;
import com.conv2.imageGS.IMGFileIO.JPEGImage;
import com.conv2.imageGS.IMGFileIO.PNGImage;
import com.conv2.imageGS.IMGFileIO.PPMImage;
import com.conv2.imageGS.IMGFileIO.RAWImage;
import com.conv2.imageGS.Util.CreateFileName;
import com.conv2.imageGS.Util.GetSizeIMG;
import com.conv2.imageGS.Util.InitIMGBuf;
import java.awt.image.BufferedImage;
import java.io.File;

public class IMGFileIO {
    private int height = 0;
    private int width = 0;
    private short[][] Red_ch = null;
    private short[][] Green_ch = null;
    private short[][] Blue_ch = null;
    private short[][] Gray_ch = null;
    private BufferedImage myBufferedImage = null;
    private String filename = null;

    public short[][] getRedChannel() throws ImageGSException {
        if (this.Red_ch == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The Red channel is null");
        }
        return this.Red_ch;
    }

    public short[][] getGreenChannel() throws ImageGSException {
        if (this.Green_ch == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The Green channel is null");
        }
        return this.Green_ch;
    }

    public short[][] getBlueChannel() throws ImageGSException {
        if (this.Blue_ch == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The Blue channel is null");
        }
        return this.Blue_ch;
    }

    public short[][] getGrayChannel() throws ImageGSException {
        if (this.Gray_ch == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "Unknown size of GrayIMG or GrayIMG is null");
        }
        return this.Gray_ch;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public BufferedImage getBufferedImage() throws ImageGSException {
        if (this.myBufferedImage == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "BufferedImage is null");
        }
        return this.myBufferedImage;
    }

    public String getReadFileName() {
        return this.filename;
    }

    public void ReadFileName(String filename) throws ImageGSException {
        int ExtName_start = filename.lastIndexOf(".");
        String ExtName = filename.substring(ExtName_start + 1);
        String LowerString = ExtName.toLowerCase();
        if (LowerString.equals("raw")) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "This format is not support." + " RAW! height and width are omiss! ");
        }
        this.ReadFileName(filename, 0, 0);
    }

    public void ReadFileName(String filename, int height, int width) throws ImageGSException {
        if (filename == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The user's value is null");
        }
        File fp = new File(filename);
        if (!fp.exists()) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + " This file is not exist!");
        }
        this.filename = filename;
        int ExtName_start = filename.lastIndexOf(".");
        String ExtName = filename.substring(ExtName_start + 1);
        String LowerString = ExtName.toLowerCase();
        if (LowerString.equals("ppm")) {
            this.ReadPPM(filename);
        } else if (LowerString.equals("jpg")) {
            this.ReadJPEG(filename);
        } else if (LowerString.equals("png")) {
            this.ReadPNG(filename);
        } else if (LowerString.equals("bmp")) {
            this.ReadBMP(filename);
        } else if (LowerString.equals("raw")) {
            this.ReadRAW(filename, height, width);
        } else if (LowerString.equals("gif")) {
            this.ReadGIF(filename);
        } else {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "This format is not support.");
        }
    }

    public void ReadGIF(String filename) throws ImageGSException {
        GIFImage img = new GIFImage(filename);
        img.load();
        this.Red_ch = img.getRedChannel();
        this.Green_ch = img.getGreenChannel();
        this.Blue_ch = img.getBlueChannel();
        this.Gray_ch = img.getGrayChannel();
        this.myBufferedImage = img.getBufferedImage();
        this.height = img.getHeight();
        this.width = img.getWidth();
    }

    public void ReadRAW(String filename, int height, int width) throws ImageGSException {
        RAWImage img = new RAWImage(filename, height, width);
        img.load();
        this.Red_ch = img.getRedChannel();
        this.Green_ch = img.getGreenChannel();
        this.Blue_ch = img.getBlueChannel();
        this.Gray_ch = img.getGrayChannel();
        this.myBufferedImage = img.getBufferedImage();
        height = img.getHeight();
        width = img.getWidth();
    }

    public void ReadBMP(String filename) throws ImageGSException {
        BMPImage img = new BMPImage(filename);
        img.load();
        this.Red_ch = img.getRedChannel();
        this.Green_ch = img.getGreenChannel();
        this.Blue_ch = img.getBlueChannel();
        this.Gray_ch = img.getGrayChannel();
        this.myBufferedImage = img.getBufferedImage();
        this.height = img.getHeight();
        this.width = img.getWidth();
    }

    public void ReadJPEG(String filename) throws ImageGSException {
        JPEGImage img = new JPEGImage(filename);
        img.load();
        this.Red_ch = img.getRedChannel();
        this.Green_ch = img.getGreenChannel();
        this.Blue_ch = img.getBlueChannel();
        this.Gray_ch = img.getGrayChannel();
        this.myBufferedImage = img.getBufferedImage();
        this.height = img.getHeight();
        this.width = img.getWidth();
    }

    public void ReadPNG(String filename) throws ImageGSException {
        PNGImage img = new PNGImage(filename);
        img.load();
        this.height = img.getHeight();
        this.width = img.getWidth();
        this.Red_ch = img.getRedChannel();
        this.Green_ch = img.getGreenChannel();
        this.Blue_ch = img.getBlueChannel();
        this.Gray_ch = img.getGrayChannel();
        this.myBufferedImage = img.getBufferedImage();
    }

    public void ReadPPM(String filename) throws ImageGSException {
        PPMImage img = new PPMImage(filename);
        img.load();
        this.height = img.getHeight();
        this.width = img.getWidth();
        this.Red_ch = img.getRedChannel();
        this.Green_ch = img.getGreenChannel();
        this.Blue_ch = img.getBlueChannel();
        this.Gray_ch = img.getGrayChannel();
        this.myBufferedImage = img.getBufferedImage();
    }

    public void WriteFileName(short[][] Out_Red_ch, short[][] Out_Green_ch, short[][] Out_Blue_ch) throws ImageGSException {
        this.WriteFileName(this.filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, GetSizeIMG.HeightFromGrayIMG(Out_Red_ch), GetSizeIMG.WidthFromGrayIMG(Out_Red_ch));
    }

    public void WriteFileName(String filename, short[][] Out_Red_ch, short[][] Out_Green_ch, short[][] Out_Blue_ch) throws ImageGSException {
        this.WriteFileName(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, GetSizeIMG.HeightFromGrayIMG(Out_Red_ch), GetSizeIMG.WidthFromGrayIMG(Out_Red_ch));
    }

    public void WriteFileName(String filename, short[][] Out_Red_ch, short[][] Out_Green_ch, short[][] Out_Blue_ch, int Height, int Width) throws ImageGSException {
        if (filename == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The user's value is null");
        }
        int ExtName_start = filename.lastIndexOf(".");
        String ExtName = filename.substring(ExtName_start + 1);
        if (ExtName.equals("ppm")) {
            this.WritePPM(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);
        } else if (ExtName.equals("jpg")) {
            this.WriteJPEG(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);
        } else if (ExtName.equals("png")) {
            this.WritePNG(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);
        } else if (ExtName.equals("bmp")) {
            this.WriteBMP(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);
        } else if (ExtName.equals("raw")) {
            this.WriteRAW(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);
        } else {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "This format is not support.");
        }
    }

    public void WriteRAW(String filename, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int Height, int Width) throws ImageGSException {
        RAWImage img = new RAWImage(filename, Height, Width);
        img.save(Red_ch, Green_ch, Blue_ch, Height, Width);
    }

    public void WriteBMP(String filename, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int Height, int Width) throws ImageGSException {
        BMPImage img = new BMPImage(filename);
        img.save(Red_ch, Green_ch, Blue_ch, Height, Width);
    }

    public void WritePNG(String filename, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int Height, int Width) throws ImageGSException {
        PNGImage img = new PNGImage(filename);
        img.save(Red_ch, Green_ch, Blue_ch, Height, Width);
    }

    public void WriteJPEG(String filename, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int Height, int Width) throws ImageGSException {
        JPEGImage img = new JPEGImage(filename);
        img.save(Red_ch, Green_ch, Blue_ch, Height, Width);
    }

    public void WritePPM(String filename, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int Height, int Width) throws ImageGSException {
        PPMImage img = new PPMImage(filename);
        img.save(Red_ch, Green_ch, Blue_ch, Height, Width);
    }

    public void WriteGrayFileName(short[][] Out_Gray_ch) throws ImageGSException {
        this.WriteGrayFileName(this.filename, Out_Gray_ch, GetSizeIMG.HeightFromGrayIMG(Out_Gray_ch), GetSizeIMG.WidthFromGrayIMG(Out_Gray_ch));
    }

    public void WriteGrayFileName(String filename, short[][] Out_Gray_ch) throws ImageGSException {
        this.WriteGrayFileName(filename, Out_Gray_ch, GetSizeIMG.HeightFromGrayIMG(Out_Gray_ch), GetSizeIMG.WidthFromGrayIMG(Out_Gray_ch));
    }

    public void WriteGrayFileName(String filename, short[][] Out_Gray_ch, int Height, int Width) throws ImageGSException {
        if (filename == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The user's value is null");
        }
        if (Out_Gray_ch == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "Unknown size of GrayIMG or GrayIMG is null");
        }
        if (Height != GetSizeIMG.HeightFromGrayIMG(Out_Gray_ch)) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + " The size that user's argument value and size of GrayIMG is not equal.");
        }
        if (Width != GetSizeIMG.WidthFromGrayIMG(Out_Gray_ch)) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + " The size that user's argument value and size of GrayIMG is not equal.");
        }
        short[][] R = InitIMGBuf.ShortIMGBuf(Height, Width);
        short[][] G = InitIMGBuf.ShortIMGBuf(Height, Width);
        short[][] B = InitIMGBuf.ShortIMGBuf(Height, Width);
        int i = 0;
        while (i < Height) {
            int j = 0;
            while (j < Width) {
                R[i][j] = Out_Gray_ch[i][j];
                G[i][j] = Out_Gray_ch[i][j];
                B[i][j] = Out_Gray_ch[i][j];
                ++j;
            }
            ++i;
        }
        int ExtName_start = filename.lastIndexOf(".");
        String ExtName = filename.substring(ExtName_start + 1);
        String LowerString = null;
        LowerString = ExtName.toLowerCase();
        if (LowerString.equals("ppm")) {
            this.WritePPM(filename, R, G, B, Height, Width);
        } else if (ExtName.equals("jpg")) {
            this.WriteJPEG(filename, R, G, B, Height, Width);
        } else if (ExtName.equals("png")) {
            this.WritePNG(filename, R, G, B, Height, Width);
        } else if (ExtName.equals("bmp")) {
            this.WriteBMP(filename, R, G, B, Height, Width);
        } else if (ExtName.equals("raw")) {
            this.WriteRAW(filename, R, G, B, Height, Width);
        } else {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "This format is not support.");
        }
    }

    public void WriteBinaryFileName(short[][] Out_Binary_ch) throws ImageGSException {
        this.WriteBinaryFileName(this.filename, Out_Binary_ch, GetSizeIMG.HeightFromGrayIMG(Out_Binary_ch), GetSizeIMG.WidthFromGrayIMG(Out_Binary_ch));
    }

    public void WriteBinaryFileName(String filename, short[][] Out_Binary_ch) throws ImageGSException {
        this.WriteBinaryFileName(filename, Out_Binary_ch, GetSizeIMG.HeightFromGrayIMG(Out_Binary_ch), GetSizeIMG.WidthFromGrayIMG(Out_Binary_ch));
    }

    public void WriteBinaryFileName(String filename, short[][] Out_Binary_ch, int Height, int Width) throws ImageGSException {
        short[][] Out_Gray_ch = Binary2GrayIMG.ShortBinary2GrayIMG((short[][])Out_Binary_ch);
        this.WriteGrayFileName(filename, Out_Gray_ch, Height, Width);
    }

    public String GetWriteFileName(String filename, String Suffix) {
        String pureFileName = CreateFileName.getSuffix(filename, Suffix, null);
        return pureFileName;
    }

    public String GetWriteFileName(String filename, String Suffix, String fmt) {
        String pureFileName = CreateFileName.getSuffix(filename, Suffix, fmt);
        return pureFileName;
    }

    public void readFileName(String filename) throws ImageGSException {
        this.ReadFileName(filename);
    }

    public void readFileName(String filename, int height, int width) throws ImageGSException {
        this.ReadFileName(filename, height, width);
    }

    public void readJPEG(String filename) throws ImageGSException {
        this.ReadJPEG(filename);
    }

    public void readPNG(String filename) throws ImageGSException {
        this.ReadPNG(filename);
    }

    public void readPPM(String filename) throws ImageGSException {
        this.ReadPPM(filename);
    }

    public void readBMP(String filename) throws ImageGSException {
        this.ReadBMP(filename);
    }

    public void readRAW(String filename, int height, int width) throws ImageGSException {
        this.ReadRAW(filename, height, width);
    }

    public void writeFileName(short[][] Out_Red_ch, short[][] Out_Green_ch, short[][] Out_Blue_ch) throws ImageGSException {
        this.WriteFileName(this.filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, GetSizeIMG.HeightFromGrayIMG(Out_Red_ch), GetSizeIMG.WidthFromGrayIMG(Out_Red_ch));
    }

    public void writeFileName(String filename, short[][] Out_Red_ch, short[][] Out_Green_ch, short[][] Out_Blue_ch) throws ImageGSException {
        this.WriteFileName(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, GetSizeIMG.HeightFromGrayIMG(Out_Red_ch), GetSizeIMG.WidthFromGrayIMG(Out_Red_ch));
    }

    public void writeFileName(String filename, short[][] Out_Red_ch, short[][] Out_Green_ch, short[][] Out_Blue_ch, int Height, int Width) throws ImageGSException {
        this.WriteFileName(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);
    }

    public void writeGrayFileName(short[][] Out_Gray_ch) throws ImageGSException {
        this.WriteGrayFileName(this.filename, Out_Gray_ch, GetSizeIMG.HeightFromGrayIMG(Out_Gray_ch), GetSizeIMG.WidthFromGrayIMG(Out_Gray_ch));
    }

    public void writeGrayFileName(String filename, short[][] Out_Gray_ch) throws ImageGSException {
        this.WriteGrayFileName(filename, Out_Gray_ch, GetSizeIMG.HeightFromGrayIMG(Out_Gray_ch), GetSizeIMG.WidthFromGrayIMG(Out_Gray_ch));
    }

    public void writeGrayFileName(String filename, short[][] Out_Gray_ch, int Height, int Width) throws ImageGSException {
        this.WriteGrayFileName(filename, Out_Gray_ch, Height, Width);
    }

    public void writeBinaryFileName(short[][] Out_Binary_ch) throws ImageGSException {
        this.WriteBinaryFileName(this.filename, Out_Binary_ch, GetSizeIMG.HeightFromGrayIMG(Out_Binary_ch), GetSizeIMG.WidthFromGrayIMG(Out_Binary_ch));
    }

    public void writeBinaryFileName(String filename, short[][] Out_Binary_ch) throws ImageGSException {
        this.WriteBinaryFileName(filename, Out_Binary_ch, GetSizeIMG.HeightFromGrayIMG(Out_Binary_ch), GetSizeIMG.WidthFromGrayIMG(Out_Binary_ch));
    }

    public void writeBinaryFileName(String filename, short[][] Out_Binary_ch, int Height, int Width) throws ImageGSException {
        this.WriteBinaryFileName(filename, Out_Binary_ch, Height, Width);
    }

    public void writeJPEG(String filename, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int Height, int Width) throws ImageGSException {
        this.WriteJPEG(filename, Red_ch, Green_ch, Blue_ch, Height, Width);
    }

    public void writePNG(String filename, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int Height, int Width) throws ImageGSException {
        this.WritePNG(filename, Red_ch, Green_ch, Blue_ch, Height, Width);
    }

    public void writePPM(String filename, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int Height, int Width) throws ImageGSException {
        this.WritePPM(filename, Red_ch, Green_ch, Blue_ch, Height, Width);
    }

    public void writeBMP(String filename, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int Height, int Width) throws ImageGSException {
        this.WriteBMP(filename, Red_ch, Green_ch, Blue_ch, Height, Width);
    }

    public void writeRAW(String filename, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int Height, int Width) throws ImageGSException {
        this.WriteRAW(filename, Red_ch, Green_ch, Blue_ch, Height, Width);
    }

    public String getWriteFileName(String filename, String Suffix) {
        String pureFileName = this.GetWriteFileName(filename, Suffix);
        return pureFileName;
    }

    public String getWriteFileName(String filename, String Suffix, String fmt) {
        String pureFileName = this.GetWriteFileName(filename, Suffix, fmt);
        return pureFileName;
    }

    public void WriteFileName(String filename, BufferedImage bi) throws ImageGSException {
        BufferedImage2Channel bc = new BufferedImage2Channel();
        bc.all(bi);
        short[][] redChannel = bc.getRedChannel();
        short[][] greenChannel = bc.getGreenChannel();
        short[][] blueChannel = bc.getBlueChannel();
        this.writeFileName(filename, redChannel, greenChannel, blueChannel);
    }

    public void writeFileName(String filename, BufferedImage bi) throws ImageGSException {
        this.WriteFileName(filename, bi);
    }

    public void display() throws ImageGSException {
        this.display(null);
    }

    public void display(String captionTitle) throws ImageGSException {
        try {
            if (captionTitle == null || captionTitle.equals("")) {
                captionTitle = this.filename;
            }
            ChannelViewer.run(this.myBufferedImage, captionTitle);
        }
        catch (ImageGSException e) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }
}

