/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.GIFImagePanel;
import com.conv2.imageGS.Util.InitIMGBuf;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class GIFImage {
    private String fname;
    private int height;
    private int width;
    private BufferedImage myBufferedImage = null;
    private short[][] RedChannel = null;
    private short[][] GreenChannel = null;
    private short[][] BlueChannel = null;
    private short[][] GrayChannel = null;
    protected GIFImagePanel panel;
    private int alpha = -16777216;

    public GIFImage(String fname) throws ImageGSException {
        try {
            Class.forName("javax.imageio.ImageIO");
        }
        catch (ClassNotFoundException e) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "This class is not support in JDK 1.4 or later");
        }
        this.fname = fname;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public short[][] getRedChannel() {
        return this.RedChannel;
    }

    public short[][] getGreenChannel() {
        return this.GreenChannel;
    }

    public short[][] getBlueChannel() {
        return this.BlueChannel;
    }

    public short[][] getGrayChannel() {
        return this.GrayChannel;
    }

    private short getR(int x, int y) {
        ColorModel cm = ColorModel.getRGBdefault();
        return (short)cm.getRed(this.myBufferedImage.getRGB(x, y));
    }

    private short getG(int x, int y) {
        ColorModel cm = ColorModel.getRGBdefault();
        return (short)cm.getGreen(this.myBufferedImage.getRGB(x, y));
    }

    private short getB(int x, int y) {
        ColorModel cm = ColorModel.getRGBdefault();
        return (short)cm.getBlue(this.myBufferedImage.getRGB(x, y));
    }

    private int packRGB(short r, short g, short b) {
        return this.alpha + 65536 * r + 256 * g + b;
    }

    private void setPixel(int x, int y, int rgb) {
        this.myBufferedImage.setRGB(x, y, rgb);
    }

    private void setPixel(int x, int y, short r, short g, short b) {
        this.setPixel(x, y, this.packRGB(r, g, b));
    }

    public void load() throws ImageGSException {
        try {
            File fp = new File(this.fname);
            this.myBufferedImage = ImageIO.read(fp);
            this.height = this.myBufferedImage.getHeight();
            this.width = this.myBufferedImage.getWidth();
            this.RedChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            this.GreenChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            this.BlueChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            this.GrayChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            int i = 0;
            while (i < this.height) {
                int j = 0;
                while (j < this.width) {
                    this.RedChannel[i][j] = this.getR(j, i);
                    this.GreenChannel[i][j] = this.getG(j, i);
                    this.BlueChannel[i][j] = this.getB(j, i);
                    this.GrayChannel[i][j] = (short)((double)this.getR(j, i) * 0.299 + (double)this.getG(j, i) * 0.587 + (double)this.getB(j, i) * 0.114);
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }

    public JPanel getImagePanel() {
        return this.panel;
    }

    public BufferedImage getBufferedImage() throws ImageGSException {
        try {
            File fp = new File(this.fname);
            this.myBufferedImage = ImageIO.read(fp);
            this.panel = new GIFImagePanel(this.myBufferedImage);
        }
        catch (Exception e) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
        return this.myBufferedImage;
    }
}

