/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.Util.GetSizeIMG;
import com.conv2.imageGS.Util.InitIMGBuf;
import com.conv2.imageGS.Util.TypeConv2GrayIMG;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;

public class GetIMGBufferType {
    private GetIMGBufferType() {
    }

    public static boolean isBinary(Object image) throws ImageGSException {
        boolean isBinaryImage = false;
        if (image == null) {
            throw new ImageGSException(String.valueOf(GetIMGBufferType.class.getClass().getName()) + ">> image is null!!");
        }
        if (image instanceof BufferedImage) {
            if (GetIMGBufferType.checkBufferedImage((BufferedImage)image) == 0) {
                isBinaryImage = true;
            }
        } else if (image instanceof short[][]) {
            isBinaryImage = GetIMGBufferType.isBinary(TypeConv2GrayIMG.Short2DoubleGrayIMG((short[][])image));
        } else if (image instanceof double[][]) {
            isBinaryImage = GetIMGBufferType.isBinary((double[][])image);
        }
        return isBinaryImage;
    }

    public static boolean isGray(Object image) throws ImageGSException {
        boolean isGrayImage = false;
        if (image == null) {
            throw new ImageGSException(String.valueOf(GetIMGBufferType.class.getClass().getName()) + ">> image is null!!");
        }
        if (image instanceof BufferedImage) {
            if (GetIMGBufferType.checkBufferedImage((BufferedImage)image) == 1) {
                isGrayImage = true;
            }
        } else if (image instanceof short[][]) {
            isGrayImage = !GetIMGBufferType.isBinary(TypeConv2GrayIMG.Short2DoubleGrayIMG((short[][])image));
        } else if (image instanceof double[][]) {
            isGrayImage = !GetIMGBufferType.isBinary((double[][])image);
        }
        return isGrayImage;
    }

    public static boolean isColor(BufferedImage image) throws ImageGSException {
        boolean isColorImage = false;
        if (image == null) {
            throw new ImageGSException(String.valueOf(GetIMGBufferType.class.getClass().getName()) + ">> image is null!!");
        }
        if (GetIMGBufferType.checkBufferedImage(image) == 2) {
            isColorImage = true;
        }
        return isColorImage;
    }

    public static int checkBufferedImage(BufferedImage bi) throws ImageGSException {
        int height = bi.getHeight();
        int width = bi.getWidth();
        boolean rotateType = false;
        boolean ROTATE_Y = false;
        boolean ROTATE_N = true;
        int BINARY = 0;
        int GRAY = 1;
        int COLOR = 2;
        int imageType = -1;
        int[] histogram = new int[256];
        int tmpHeight = width;
        int tmpWidth = height;
        rotateType = tmpHeight == width && tmpWidth == height ? ROTATE_Y : ROTATE_N;
        if (rotateType == ROTATE_Y) {
            int tmp = height;
            height = width;
            width = tmp;
        }
        short[][] image = InitIMGBuf.ShortIMGBuf(height, width);
        Raster raster = bi.getData();
        int[] data = new int[3];
        data = raster.getPixel(0, 0, (int[])null);
        if (data.length > 3) {
            throw new ImageGSException(String.valueOf(GetIMGBufferType.class.getClass().getName()) + ">> this BufferedImage data not support over 32 bi!");
        }
        if (data.length == 3) {
            imageType = COLOR;
        } else {
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    data = raster.getPixel(i, j, (int[])null);
                    image[i][j] = (short)data[0];
                    short s = image[i][j];
                    histogram[s] = histogram[s] + 1;
                    ++j;
                }
                ++i;
            }
            imageType = GetIMGBufferType.checkHistogram(histogram) ? BINARY : GRAY;
        }
        return imageType;
    }

    private static boolean checkHistogram(int[] histogram) {
        int pixels = 0;
        int i = 2;
        while (i < 256) {
            if (histogram[i] != 0) {
                ++pixels;
            }
            ++i;
        }
        return pixels == 0;
    }

    private static boolean isBinary(double[][] image) throws ImageGSException {
        int height = GetSizeIMG.getHeight(image);
        int width = GetSizeIMG.getWidth(image);
        int[] histogram = new int[256];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int n = (int)image[i][j];
                histogram[n] = histogram[n] + 1;
                ++j;
            }
            ++i;
        }
        return GetIMGBufferType.checkHistogram(histogram);
    }
}

