/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.GeometryProc.BilinearInterp;
import com.conv2.imageGS.GeometryProc.GeometryProc;
import com.conv2.imageGS.Util.BoundaryIMGBuf;
import com.conv2.imageGS.Util.CenterIMGBuf;
import com.conv2.imageGS.Util.Clamping;
import com.conv2.imageGS.Util.CopyIMGBuf;
import com.conv2.imageGS.Util.FillIMGBuf;
import com.conv2.imageGS.Util.GetSizeIMG;
import com.conv2.imageGS.Util.InitIMGBuf;
import com.conv2.imageGS.Util.TypeConv2GrayIMG;

public class AbstractGS {
    private short[][] ShortResultIMG = null;
    private double[][] DoubleResultIMG = null;
    private int[][] IntegerResultIMG = null;
    private double[][] IMGBuf = null;
    private int DataType = -1;
    protected static final int SHORTTYPE = 0;
    protected static final int DOUBLETYPE = 1;
    protected static final int INTEGERTYPE = 2;
    protected static final int ERROR = 3;
    private int IMGBuf_height = 0;
    private int IMGBuf_width = 0;

    public AbstractGS(short[][] ShortIMGBuf) {
        this(ShortIMGBuf, -1, -1);
    }

    public AbstractGS(short[][] ShortIMGBuf, int height, int width) {
        if (height == -1 && width == -1) {
            try {
                this.DataType = 0;
                this.IMGBuf_height = GetSizeIMG.getHeight(ShortIMGBuf);
                this.IMGBuf_width = GetSizeIMG.getWidth(ShortIMGBuf);
                this.IMGBuf = CopyIMGBuf.CopyShort2DoubleGrayIMGBuf(ShortIMGBuf);
                this.initImageBuf();
            }
            catch (ImageGSException e) {
                this.DataType = 3;
            }
        } else {
            this.IMGBuf_height = height;
            this.IMGBuf_width = width;
            try {
                this.DataType = 0;
                this.IMGBuf = CopyIMGBuf.CopyShort2DoubleGrayIMGBuf(ShortIMGBuf);
                this.initImageBuf();
            }
            catch (ImageGSException e) {
                this.DataType = 3;
            }
        }
    }

    public AbstractGS(double[][] DoubleIMGBuf) {
        this(DoubleIMGBuf, -1, -1);
    }

    public AbstractGS(double[][] DoubleIMGBuf, int height, int width) {
        if (height == -1 && width == -1) {
            try {
                this.DataType = 1;
                this.IMGBuf_height = GetSizeIMG.getHeight(DoubleIMGBuf);
                this.IMGBuf_width = GetSizeIMG.getWidth(DoubleIMGBuf);
                this.IMGBuf = CopyIMGBuf.CopyDoubleGrayIMGBuf(DoubleIMGBuf);
                this.initImageBuf();
            }
            catch (ImageGSException e) {
                this.DataType = 3;
            }
        } else {
            this.IMGBuf_height = height;
            this.IMGBuf_width = width;
            try {
                this.DataType = 1;
                this.IMGBuf = CopyIMGBuf.CopyDoubleGrayIMGBuf(DoubleIMGBuf);
                this.initImageBuf();
            }
            catch (ImageGSException e) {
                this.DataType = 3;
            }
        }
    }

    public AbstractGS(int[][] IntegerIMGBuf) {
        this(IntegerIMGBuf, -1, -1);
    }

    public AbstractGS(int[][] IntegerIMGBuf, int height, int width) {
        if (height == -1 && width == -1) {
            try {
                this.DataType = 2;
                this.IMGBuf_height = GetSizeIMG.getHeight(IntegerIMGBuf);
                this.IMGBuf_width = GetSizeIMG.getWidth(IntegerIMGBuf);
                this.IMGBuf = CopyIMGBuf.CopyInteger2DoubleGrayIMGBuf(IntegerIMGBuf);
                this.initImageBuf();
            }
            catch (ImageGSException e) {
                this.DataType = 3;
            }
        } else {
            this.IMGBuf_height = height;
            this.IMGBuf_width = width;
            try {
                this.DataType = 2;
                this.IMGBuf = CopyIMGBuf.CopyInteger2DoubleGrayIMGBuf(IntegerIMGBuf);
                this.initImageBuf();
            }
            catch (ImageGSException e) {
                this.DataType = 3;
            }
        }
    }

    public short[][] getShortResultIMG() throws ImageGSException {
        if (this.ShortResultIMG != null) {
            return this.ShortResultIMG;
        }
        if (this.DoubleResultIMG != null) {
            return TypeConv2GrayIMG.Double2ShortGrayIMG(this.DoubleResultIMG);
        }
        if (this.IntegerResultIMG != null) {
            return TypeConv2GrayIMG.Integer2ShortGrayIMG(this.IntegerResultIMG);
        }
        return null;
    }

    public double[][] getDoubleResultIMG() throws ImageGSException {
        if (this.DoubleResultIMG != null) {
            return this.DoubleResultIMG;
        }
        if (this.ShortResultIMG != null) {
            return TypeConv2GrayIMG.Short2DoubleGrayIMG(this.ShortResultIMG);
        }
        if (this.IntegerResultIMG != null) {
            return TypeConv2GrayIMG.Integer2DoubleGrayIMG(this.IntegerResultIMG);
        }
        return null;
    }

    public int[][] getIntegerResultIMG() throws ImageGSException {
        if (this.IntegerResultIMG != null) {
            return this.IntegerResultIMG;
        }
        if (this.ShortResultIMG != null) {
            return TypeConv2GrayIMG.Short2IntegerGrayIMG(this.ShortResultIMG);
        }
        if (this.DoubleResultIMG != null) {
            return TypeConv2GrayIMG.Double2IntegerGrayIMG(this.DoubleResultIMG);
        }
        return null;
    }

    public short[][] getCenterShortResultIMG() throws ImageGSException {
        return CenterIMGBuf.CenterShortGrayIMGBuf(this.getShortResultIMG(), 3, 3);
    }

    public short[][] getCenterShortResultIMG(int pixels) throws ImageGSException {
        return CenterIMGBuf.CenterShortGrayIMGBuf(this.getShortResultIMG(), pixels, pixels);
    }

    public short[][] getCenterShortResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException {
        return CenterIMGBuf.CenterShortGrayIMGBuf(this.getShortResultIMG(), left_pixels, bottom_pixels);
    }

    public double[][] getCenterDoubleResultIMG() throws ImageGSException {
        return CenterIMGBuf.CenterDoubleGrayIMGBuf(this.getDoubleResultIMG(), 3, 3);
    }

    public double[][] getCenterDoubleResultIMG(int pixels) throws ImageGSException {
        return CenterIMGBuf.CenterDoubleGrayIMGBuf(this.getDoubleResultIMG(), pixels, pixels);
    }

    public double[][] getCenterDoubleResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException {
        return CenterIMGBuf.CenterDoubleGrayIMGBuf(this.getDoubleResultIMG(), left_pixels, bottom_pixels);
    }

    public int[][] getCenterIntegerResultIMG() throws ImageGSException {
        return CenterIMGBuf.CenterIntegerGrayIMGBuf(this.getIntegerResultIMG(), 3, 3);
    }

    public int[][] CenterIntegerResultIMG(int pixels) throws ImageGSException {
        return CenterIMGBuf.CenterIntegerGrayIMGBuf(this.getIntegerResultIMG(), pixels, pixels);
    }

    public int[][] CenterIntegerResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException {
        return CenterIMGBuf.CenterIntegerGrayIMGBuf(this.getIntegerResultIMG(), left_pixels, bottom_pixels);
    }

    public short[][] getEnlargeShortResultIMG() throws ImageGSException {
        return this.getEnlargeShortResultIMG(3, 3);
    }

    public short[][] getEnlargeShortResultIMG(int pixels) throws ImageGSException {
        return this.getEnlargeShortResultIMG(pixels, pixels);
    }

    public short[][] getEnlargeShortResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException {
        if (left_pixels < 0 || bottom_pixels < 0) {
            return null;
        }
        if (this.getShortResultIMG() == null) {
            throw new ImageGSException("Unknown size of GrayIMG or GrayIMG is null");
        }
        short[][] tmpImage = BoundaryIMGBuf.delete(this.getShortResultIMG(), left_pixels, bottom_pixels);
        if (tmpImage == null) {
            throw new ImageGSException("Unknown size of GrayIMG or GrayIMG is null");
        }
        BilinearInterp bilinear = GeometryProc.getBilinearInterp((short[][])tmpImage);
        bilinear.BilinearInterpOP(this.IMGBuf_height, this.IMGBuf_width);
        return bilinear.getShortResultIMG();
    }

    public double[][] getEnlargeDoubleResultIMG() throws ImageGSException {
        return this.getEnlargeDoubleResultIMG(3, 3);
    }

    public double[][] getEnlargeDoubleResultIMG(int pixels) throws ImageGSException {
        return this.getEnlargeDoubleResultIMG(pixels, pixels);
    }

    public double[][] getEnlargeDoubleResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException {
        if (left_pixels < 0 || bottom_pixels < 0) {
            return null;
        }
        if (this.getDoubleResultIMG() == null) {
            throw new ImageGSException("Unknown size of GrayIMG or GrayIMG is null");
        }
        double[][] tmpImage = BoundaryIMGBuf.delete(this.getDoubleResultIMG(), left_pixels, bottom_pixels);
        if (tmpImage == null) {
            throw new ImageGSException("Unknown size of GrayIMG or GrayIMG is null");
        }
        BilinearInterp bilinear = GeometryProc.getBilinearInterp((double[][])tmpImage);
        bilinear.BilinearInterpOP(this.IMGBuf_height, this.IMGBuf_width);
        return bilinear.getDoubleResultIMG();
    }

    public int[][] getEnlargeIntegerResultIMG() throws ImageGSException {
        return this.getEnlargeIntegerResultIMG(3, 3);
    }

    public int[][] getEnlargeIntegerResultIMG(int pixels) throws ImageGSException {
        return this.getEnlargeIntegerResultIMG(pixels, pixels);
    }

    public int[][] getEnlargeIntegerResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException {
        if (left_pixels < 0 || bottom_pixels < 0) {
            return null;
        }
        if (this.getIntegerResultIMG() == null) {
            throw new ImageGSException("Unknown size of GrayIMG or GrayIMG is null");
        }
        int[][] tmpImage = BoundaryIMGBuf.delete(this.getIntegerResultIMG(), left_pixels, bottom_pixels);
        if (tmpImage == null) {
            throw new ImageGSException("Unknown size of GrayIMG or GrayIMG is null");
        }
        double[][] tmpImage2 = TypeConv2GrayIMG.Integer2DoubleGrayIMG(tmpImage);
        if (tmpImage2 == null) {
            throw new ImageGSException("Unknown size of GrayIMG or GrayIMG is null");
        }
        BilinearInterp bilinear = GeometryProc.getBilinearInterp((double[][])tmpImage2);
        bilinear.BilinearInterpOP(this.IMGBuf_height, this.IMGBuf_width);
        return bilinear.getIntegerResultIMG();
    }

    public void initImageBuf() throws ImageGSException {
        this.initImageBuf(this.IMGBuf_height, this.IMGBuf_width);
    }

    public void initImageBuf(int height, int width) throws ImageGSException {
        if (this.DataType == 1) {
            if (this.DoubleResultIMG != null) {
                this.DoubleResultIMG = null;
            }
            this.DoubleResultIMG = InitIMGBuf.DoubleIMGBuf(height, width);
        } else if (this.DataType == 0) {
            if (this.ShortResultIMG != null) {
                this.ShortResultIMG = null;
            }
            this.ShortResultIMG = InitIMGBuf.ShortIMGBuf(height, width);
        } else if (this.DataType == 2) {
            if (this.IntegerResultIMG != null) {
                this.IntegerResultIMG = null;
            }
            this.IntegerResultIMG = InitIMGBuf.IntegerIMGBuf(height, width);
        } else if (this.DataType == 3) {
            throw new ImageGSException("Unknown size of GrayIMG or GrayIMG is null");
        }
    }

    public void initWhiteImageBuf(int height, int width) throws ImageGSException {
        if (this.DataType == 1) {
            if (this.DoubleResultIMG != null) {
                this.DoubleResultIMG = null;
            }
            this.DoubleResultIMG = FillIMGBuf.FillDoubleGrayIMGBuf(255.0, height, width);
        } else if (this.DataType == 0) {
            if (this.ShortResultIMG != null) {
                this.ShortResultIMG = null;
            }
            this.ShortResultIMG = FillIMGBuf.FillShortGrayIMGBuf((short)255, height, width);
        } else if (this.DataType == 2) {
            if (this.IntegerResultIMG != null) {
                this.IntegerResultIMG = null;
            }
            this.IntegerResultIMG = FillIMGBuf.FillIntegerGrayIMGBuf(255, height, width);
        } else if (this.DataType == 3) {
            throw new ImageGSException("Unknown size of GrayIMG or GrayIMG is null");
        }
    }

    public void initWhiteImageBuf() throws ImageGSException {
        this.initWhiteImageBuf(this.IMGBuf_height, this.IMGBuf_width);
    }

    public void initBlackImageBuf(int height, int width) throws ImageGSException {
        if (this.DataType == 1) {
            if (this.DoubleResultIMG != null) {
                this.DoubleResultIMG = null;
            }
            this.DoubleResultIMG = FillIMGBuf.FillDoubleGrayIMGBuf(0.0, height, width);
        } else if (this.DataType == 0) {
            if (this.ShortResultIMG != null) {
                this.ShortResultIMG = null;
            }
            this.ShortResultIMG = FillIMGBuf.FillShortGrayIMGBuf((short)0, height, width);
        } else if (this.DataType == 2) {
            if (this.IntegerResultIMG != null) {
                this.IntegerResultIMG = null;
            }
            this.IntegerResultIMG = FillIMGBuf.FillIntegerGrayIMGBuf(0, height, width);
        } else if (this.DataType == 3) {
            throw new ImageGSException("Unknown size of GrayIMG or GrayIMG is null");
        }
    }

    public void initBlackImageBuf() throws ImageGSException {
        this.initBlackImageBuf(this.IMGBuf_height, this.IMGBuf_width);
    }

    public void initUserDefinedImageBuf(int height, int width, short var) throws ImageGSException {
        if (this.DataType == 1) {
            if (this.DoubleResultIMG != null) {
                this.DoubleResultIMG = null;
            }
            this.DoubleResultIMG = FillIMGBuf.FillDoubleGrayIMGBuf(var, height, width);
        } else if (this.DataType == 0) {
            if (this.ShortResultIMG != null) {
                this.ShortResultIMG = null;
            }
            this.ShortResultIMG = FillIMGBuf.FillShortGrayIMGBuf(var, height, width);
        } else if (this.DataType == 2) {
            if (this.IntegerResultIMG != null) {
                this.IntegerResultIMG = null;
            }
            this.IntegerResultIMG = FillIMGBuf.FillIntegerGrayIMGBuf(var, height, width);
        } else if (this.DataType == 3) {
            throw new ImageGSException("Unknown size of GrayIMG or GrayIMG is null");
        }
    }

    public void initUserDefinedImageBuf(short var) throws ImageGSException {
        this.initUserDefinedImageBuf(this.IMGBuf_height, this.IMGBuf_width, var);
    }

    public void setImageBuf(int pixelHeight, int pixelWidth, double var) {
        this.setImageBuf(pixelHeight, pixelWidth, var, true);
    }

    public void setImageBuf(int pixelHeight, int pixelWidth, short var) {
        this.setImageBuf(pixelHeight, pixelWidth, (double)var, true);
    }

    public void setImageBuf(int pixelHeight, int pixelWidth, int var) {
        this.setImageBuf(pixelHeight, pixelWidth, (double)var, true);
    }

    public void setImageBuf(int pixelHeight, int pixelWidth, double var, boolean clampingFlag) {
        if (this.DataType == 1) {
            this.DoubleResultIMG[pixelHeight][pixelWidth] = clampingFlag ? Clamping.DoubleSaturation(var) : var;
        } else if (this.DataType == 0) {
            this.ShortResultIMG[pixelHeight][pixelWidth] = clampingFlag ? Clamping.ShortSaturation(var) : (short)var;
        } else if (this.DataType == 2) {
            this.IntegerResultIMG[pixelHeight][pixelWidth] = clampingFlag ? Clamping.IntSaturation(var) : (int)var;
        }
    }

    public void setImageBuf(int pixelHeight, int pixelWidth, short var, boolean clampingFlag) {
        this.setImageBuf(pixelHeight, pixelWidth, (double)var, clampingFlag);
    }

    public void setImageBuf(int pixelHeight, int pixelWidth, int var, boolean clampingFlag) {
        this.setImageBuf(pixelHeight, pixelWidth, (double)var, clampingFlag);
    }

    public void setImageBuf(double[][] image) throws ImageGSException {
        if (this.DataType == 1) {
            this.DoubleResultIMG = CopyIMGBuf.CopyDoubleGrayIMGBuf(image);
        } else if (this.DataType == 0) {
            this.ShortResultIMG = CopyIMGBuf.CopyDouble2ShortGrayIMGBuf(image);
        } else if (this.DataType == 2) {
            this.IntegerResultIMG = CopyIMGBuf.CopyDouble2IntegerGrayIMGBuf(image);
        }
    }

    public void setImageBuf(short[][] image) throws ImageGSException {
        if (this.DataType == 1) {
            this.DoubleResultIMG = CopyIMGBuf.CopyShort2DoubleGrayIMGBuf(image);
        } else if (this.DataType == 0) {
            this.ShortResultIMG = CopyIMGBuf.CopyShortGrayIMGBuf(image);
        } else if (this.DataType == 2) {
            this.IntegerResultIMG = CopyIMGBuf.CopyShort2IntegerGrayIMGBuf(image);
        }
    }

    public void setImageBuf(int[][] image) throws ImageGSException {
        if (this.DataType == 1) {
            this.DoubleResultIMG = CopyIMGBuf.CopyInteger2DoubleGrayIMGBuf(image);
        } else if (this.DataType == 0) {
            this.ShortResultIMG = CopyIMGBuf.CopyInteger2ShortGrayIMGBuf(image);
        } else if (this.DataType == 2) {
            this.IntegerResultIMG = CopyIMGBuf.CopyIntegerGrayIMGBuf(image);
        }
    }

    public int getOrgImageBufHeight() {
        return this.IMGBuf_height;
    }

    public int getOrgImageBufWidth() {
        return this.IMGBuf_width;
    }

    public double[][] getOrgImageBuf() {
        return this.IMGBuf;
    }

    public double[][] getOrgDoubleImageBuf() {
        return this.IMGBuf;
    }

    public short[][] getOrgShortImageBuf() throws ImageGSException {
        return TypeConv2GrayIMG.Double2ShortGrayIMG(this.IMGBuf);
    }

    public int[][] getOrgIntegerImageBuf() throws ImageGSException {
        return TypeConv2GrayIMG.Double2IntegerGrayIMG(this.IMGBuf);
    }

    public int getOrgImageBufType() {
        return this.DataType;
    }
}

