/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.GeometryProc.Mirror;
import com.conv2.imageGS.IMGFileIO.BufferedImage2Channel;
import com.conv2.imageGS.IMGFileIO.Channel2BufferedImage;
import com.conv2.imageGS.IMGFileIO.JAI.FileSeekableStream;
import com.conv2.imageGS.IMGFileIO.JAI.ImageCodec;
import com.conv2.imageGS.IMGFileIO.JAI.ImageDecoder;
import com.conv2.imageGS.IMGFileIO.JAI.ImageEncodeParam;
import com.conv2.imageGS.IMGFileIO.JAI.ImageEncoder;
import com.conv2.imageGS.IMGFileIO.JAI.TIFFEncodeParam;
import com.conv2.imageGS.Util.InitIMGBuf;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class TIFFImage {
    private String fname = null;
    private int height = 0;
    private int width = 0;
    private int numPages = 0;
    private RenderedImage[] images = null;
    private int imageType = -1;
    private short[][] grayChannel = null;
    private short[][] redChannel = null;
    private short[][] greenChannel = null;
    private short[][] blueChannel = null;
    private BufferedImage bi = null;
    public final int BINARY = 0;
    public final int GRAY = 1;
    public final int COLOR = 2;
    private final int ROTATE_N = 0;
    private final int ROTATE_Y = 1;
    private int rotateType = 0;
    private int compressMethod = 0;
    private boolean fastSplit = false;

    public TIFFImage(String fname) throws ImageGSException {
        this.fname = fname;
    }

    public int getNumPages() {
        return this.numPages;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void load() throws ImageGSException {
        FileSeekableStream in = null;
        try {
            try {
                File file = new File(this.fname);
                in = new FileSeekableStream(file);
                ImageDecoder decoder = ImageCodec.createImageDecoder((String)"tiff", (File)file, null);
                this.numPages = decoder.getNumPages();
                this.images = new RenderedImage[this.numPages];
                int i = 0;
                while (i < decoder.getNumPages()) {
                    this.images[i] = decoder.decodeAsRenderedImage(i);
                    ++i;
                }
                this.height = this.images[0].getHeight();
                this.width = this.images[0].getWidth();
            }
            catch (IOException e) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public RenderedImage[] getRenderImages() {
        return this.images;
    }

    public BufferedImage getBufferedImage() throws ImageGSException {
        return this.bi;
    }

    public short[][] getRedChannel() throws ImageGSException {
        if (this.imageType == 1 || this.imageType == 0) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + " gray image!");
        }
        if (this.fastSplit) {
            BufferedImage2Channel bc = new BufferedImage2Channel();
            bc.color(this.bi);
            this.redChannel = bc.getRedChannel();
        }
        return this.redChannel;
    }

    public short[][] getGreenChannel() throws ImageGSException {
        if (this.imageType == 1 || this.imageType == 0) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + " gray image!");
        }
        if (this.fastSplit) {
            BufferedImage2Channel bc = new BufferedImage2Channel();
            bc.color(this.bi);
            this.greenChannel = bc.getGreenChannel();
        }
        return this.greenChannel;
    }

    public short[][] getBlueChannel() throws ImageGSException {
        if (this.imageType == 1 || this.imageType == 0) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + " gray image!");
        }
        if (this.fastSplit) {
            BufferedImage2Channel bc = new BufferedImage2Channel();
            bc.color(this.bi);
            this.blueChannel = bc.getBlueChannel();
        }
        return this.blueChannel;
    }

    public short[][] getGrayChannel() throws ImageGSException {
        if (this.imageType == 2) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + " color image!");
        }
        if (this.fastSplit) {
            this.grayChannel = this.getGrayChannel(this.bi, this.imageType);
        }
        return this.grayChannel;
    }

    private short[][] getGrayChannel(BufferedImage bi, int imageType) throws ImageGSException {
        short[][] image = null;
        try {
            int height = bi.getHeight();
            int width = bi.getWidth();
            boolean rotateType = false;
            int tmpHeight = width;
            int tmpWidth = height;
            rotateType = tmpHeight == width && tmpWidth == height;
            if (rotateType) {
                int tmp = height;
                height = width;
                width = tmp;
            }
            image = InitIMGBuf.ShortIMGBuf(height, width);
            Raster raster = bi.getData();
            int[] data = new int[3];
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    data = raster.getPixel(i, j, (int[])null);
                    if (imageType == 0) {
                        image[i][j] = (short)(255 * data[0]);
                    } else if (imageType == 1) {
                        image[i][j] = (short)data[0];
                    }
                    ++j;
                }
                ++i;
            }
            if (rotateType) {
                image = this.rotate(image, height, width);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
        return image;
    }

    public void splitImageData() throws ImageGSException {
        if (this.numPages != 1) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + " not support multi-TIFF");
        }
        if (this.numPages == 1) {
            this.splitImageData(this.images[0]);
        }
    }

    public boolean getRotateImage() {
        return this.rotateType == 1;
    }

    public BufferedImage fastSplitImageData(RenderedImage image) throws ImageGSException {
        try {
            int[] rgba = null;
            this.fastSplit = true;
            Raster raster = image.getData();
            rgba = raster.getPixel(0, 0, (int[])null);
            if (rgba.length > 3) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + " not support 32-bit in TIFF");
            }
            if (rgba.length == 1) {
                this.searchBinaryGrayImage(raster, rgba);
                if (this.imageType == 0) {
                    this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 12);
                } else if (this.imageType == 1) {
                    this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 10);
                }
            } else if (rgba.length == 3) {
                this.bi = new BufferedImage(this.width, this.height, 1);
            }
            this.bi.setData(raster);
        }
        catch (Exception e) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
        return this.bi;
    }

    public void splitImageData(RenderedImage image) throws ImageGSException {
        try {
            Raster raster = image.getData();
            int[] rgba = null;
            double alpha = 0.0;
            int tmpHeight = this.width;
            int tmpWidth = this.height;
            this.rotateType = tmpHeight == this.width && tmpWidth == this.height ? 1 : 0;
            if (this.rotateType == 1) {
                int tmp = this.height;
                this.height = this.width;
                this.width = tmp;
            }
            if ((rgba = raster.getPixel(0, 0, (int[])null)).length > 3) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + " not support 32-bit in TIFF");
            }
            if (rgba.length == 1) {
                this.grayChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            } else if (rgba.length == 3) {
                this.redChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
                this.greenChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
                this.blueChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            }
            int[] histogram = new int[256];
            int i = 0;
            while (i < this.height) {
                int j = 0;
                while (j < this.width) {
                    rgba = raster.getPixel(i, j, (int[])null);
                    if (rgba.length == 1) {
                        this.imageType = 1;
                        this.grayChannel[i][j] = (short)rgba[0];
                        short s = this.grayChannel[i][j];
                        histogram[s] = histogram[s] + 1;
                    } else if (rgba.length == 3) {
                        this.imageType = 2;
                        this.redChannel[i][j] = (short)rgba[0];
                        this.greenChannel[i][j] = (short)rgba[1];
                        this.blueChannel[i][j] = (short)rgba[2];
                    }
                    ++j;
                }
                ++i;
            }
            if (this.imageType == 1) {
                int pixels = 0;
                int i2 = 2;
                while (i2 < 256) {
                    if (histogram[i2] != 0) {
                        ++pixels;
                    }
                    ++i2;
                }
                if (pixels == 0) {
                    this.imageType = 0;
                }
            }
            if (this.imageType == 0) {
                this.grayChannel = this.inverse(this.grayChannel);
            }
            if (this.rotateType == 1) {
                if (this.imageType == 1 || this.imageType == 0) {
                    this.grayChannel = this.rotate(this.grayChannel, this.height, this.width);
                } else if (this.imageType == 2) {
                    this.redChannel = this.rotate(this.redChannel, this.height, this.width);
                    this.greenChannel = this.rotate(this.greenChannel, this.height, this.width);
                    this.blueChannel = this.rotate(this.blueChannel, this.height, this.width);
                }
            }
            Channel2BufferedImage cb = new Channel2BufferedImage();
            if (this.imageType == 1 || this.imageType == 0) {
                cb.gray(this.grayChannel);
            } else if (this.imageType == 2) {
                cb.color(this.redChannel, this.greenChannel, this.blueChannel);
            }
            this.bi = cb.getBufferedImage();
        }
        catch (Exception e) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }

    private short[][] inverse(short[][] binaryImage) throws ImageGSException {
        int height = binaryImage.length;
        int width = binaryImage[height - 1].length;
        short[][] inverseBinaryImage = InitIMGBuf.ShortIMGBuf(height, width);
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                inverseBinaryImage[i][j] = binaryImage[i][j] == 0 ? 255 : 0;
                ++j;
            }
            ++i;
        }
        return inverseBinaryImage;
    }

    private short[][] rotate(short[][] image, int height, int width) throws ImageGSException {
        Mirror flip = new Mirror(image);
        flip.FlipOP();
        short[][] tmpImage1 = flip.getShortResultIMG();
        short[][] tmpImage2 = InitIMGBuf.ShortIMGBuf(width, height);
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                tmpImage2[j][i] = tmpImage1[i][j];
                ++j;
            }
            ++i;
        }
        flip = new Mirror(tmpImage2);
        flip.ReflectOP();
        return flip.getShortResultIMG();
    }

    public int getImageType() {
        return this.imageType;
    }

    public void saveMultiBufferedImage(String fname, BufferedImage[] image) throws ImageGSException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(fname);
                TIFFEncodeParam encodeParam = new TIFFEncodeParam();
                encodeParam.setCompression(this.compressMethod);
                ImageEncoder encoder = ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)out, (ImageEncodeParam)encodeParam);
                ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
                int i = 1;
                while (i < image.length) {
                    arrayList.add(image[i]);
                    ++i;
                }
                encodeParam.setExtraImages(arrayList.iterator());
                encoder.encode((RenderedImage)image[0]);
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
            }
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void saveBufferedImage(String fname, BufferedImage image) throws ImageGSException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(fname);
                TIFFEncodeParam encodeParam = new TIFFEncodeParam();
                encodeParam.setCompression(this.compressMethod);
                ImageEncoder encoder = ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)out, (ImageEncodeParam)encodeParam);
                encoder.encode((RenderedImage)image);
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
            }
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void saveMultiRenderedImage(String fname, RenderedImage[] image) throws ImageGSException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(fname);
                TIFFEncodeParam encodeParam = new TIFFEncodeParam();
                encodeParam.setCompression(this.compressMethod);
                ImageEncoder encoder = ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)out, (ImageEncodeParam)encodeParam);
                ArrayList<RenderedImage> arrayList = new ArrayList<RenderedImage>();
                int i = 1;
                while (i < image.length) {
                    arrayList.add(image[i]);
                    ++i;
                }
                encodeParam.setExtraImages(arrayList.iterator());
                encoder.encode(image[0]);
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
            }
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void saveRenderedImage(String fname, RenderedImage image) throws ImageGSException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(fname);
                TIFFEncodeParam encodeParam = new TIFFEncodeParam();
                encodeParam.setCompression(this.compressMethod);
                ImageEncoder encoder = ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)out, (ImageEncodeParam)encodeParam);
                encoder.encode(image);
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
            }
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setCompressTIFF() {
        this.setCompressTIFF(7);
    }

    public void setCompressTIFF(int method) {
        switch (method) {
            case 0: {
                this.compressMethod = 1;
                break;
            }
            case 1: {
                this.compressMethod = 32773;
                break;
            }
            case 2: {
                this.compressMethod = 2;
                break;
            }
            case 3: {
                this.compressMethod = 3;
                break;
            }
            case 4: {
                this.compressMethod = 4;
                break;
            }
            case 5: {
                this.compressMethod = 7;
                break;
            }
            case 6: {
                this.compressMethod = 32946;
                break;
            }
            default: {
                this.compressMethod = 1;
            }
        }
    }

    public String printCompressTIFFMethod() {
        StringBuffer sb = new StringBuffer();
        sb.append("0 : No compression");
        sb.append("1 : Byte-oriented run-length encoding \"PackBits\" compression");
        sb.append("2 : Modified Huffman Compression (CCITT Run Length Encoding (RLE))");
        sb.append("3 : CCITT T.6 bilevel compression (Group 3 facsimile compression)");
        sb.append("4 : CCITT T.6 bilevel compression (Group 4 facsimile compression)");
        sb.append("5 : JPEG-in-TIFF compression");
        sb.append("6 : DEFLATE lossless compression (also known as \"Zip-in-TIFF\")");
        return sb.toString();
    }

    private void searchBinaryGrayImage(Raster raster, int[] rgba) {
        int tmpHeight = this.width;
        int tmpWidth = this.height;
        this.rotateType = tmpHeight == this.width && tmpWidth == this.height ? 1 : 0;
        if (this.rotateType == 1) {
            int tmp = this.height;
            this.height = this.width;
            this.width = tmp;
        }
        this.grayChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
        this.imageType = 1;
        int[] histogram = new int[256];
        int i = 0;
        while (i < this.height) {
            int j = 0;
            while (j < this.width) {
                rgba = raster.getPixel(i, j, (int[])null);
                this.grayChannel[i][j] = (short)rgba[0];
                short s = this.grayChannel[i][j];
                histogram[s] = histogram[s] + 1;
                ++j;
            }
            ++i;
        }
        int pixels = 0;
        int i2 = 2;
        while (i2 < 256) {
            if (histogram[i2] != 0) {
                ++pixels;
            }
            ++i2;
        }
        if (pixels == 0) {
            this.imageType = 0;
        }
        if (this.rotateType == 1) {
            int tmp = this.width;
            this.width = this.height;
            this.height = tmp;
        }
    }
}

