/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.Util.GetSizeIMG;
import com.conv2.imageGS.Util.InitMaskBuf;

public class ReplaceIMGBuf {
    private ReplaceIMGBuf() {
    }

    public static short[][] ReplaceShortGrayIMGBuf(short[][] Image, short oldConstant, short newConstant) throws ImageGSException {
        short[][] TargetGrayIMGBuf = null;
        if (Image == null) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf() >> Unknown size of GrayIMG or GrayIMG is null");
        }
        if (oldConstant < 0 || oldConstant > 255) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf() >> The range of the value don't satisify (0~255)");
        }
        if (newConstant < 0 || newConstant > 255) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf() >>The range of the value don't satisify (0~255)");
        }
        try {
            int height = GetSizeIMG.getHeight(Image);
            int width = GetSizeIMG.getWidth(Image);
            TargetGrayIMGBuf = InitMaskBuf.ShortInitMask(height, width);
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    TargetGrayIMGBuf[i][j] = Image[i][j] == oldConstant ? newConstant : Image[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ImageGSException e) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf()  >> " + e.getMessage());
        }
        return TargetGrayIMGBuf;
    }

    public static int[][] ReplaceIntegerGrayIMGBuf(int[][] Image, int oldConstant, int newConstant) throws ImageGSException {
        int[][] TargetGrayIMGBuf = null;
        if (Image == null) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf() >> Unknown size of GrayIMG or GrayIMG is null");
        }
        if (oldConstant < 0 || oldConstant > 255) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf() >> The range of the value don't satisify (0~255)");
        }
        if (newConstant < 0 || newConstant > 255) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf() >>The range of the value don't satisify (0~255)");
        }
        try {
            int height = GetSizeIMG.getHeight(Image);
            int width = GetSizeIMG.getWidth(Image);
            TargetGrayIMGBuf = InitMaskBuf.IntegerInitMask(height, width);
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    TargetGrayIMGBuf[i][j] = Image[i][j] == oldConstant ? newConstant : Image[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ImageGSException e) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf()  >> " + e.getMessage());
        }
        return TargetGrayIMGBuf;
    }

    public static double[][] ReplaceDoubleGrayIMGBuf(double[][] Image, double oldConstant, double newConstant) throws ImageGSException {
        double[][] TargetGrayIMGBuf = null;
        if (Image == null) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceDoubleGrayIMGBuf() >> Unknown size of GrayIMG or GrayIMG is null");
        }
        if (oldConstant < 0.0 || oldConstant > 255.0) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceDoubleGrayIMGBuf() >> The range of the value don't satisify (0~255)");
        }
        if (newConstant < 0.0 || newConstant > 255.0) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceDoubleGrayIMGBuf() >>The range of the value don't satisify (0~255)");
        }
        try {
            int height = GetSizeIMG.getHeight(Image);
            int width = GetSizeIMG.getWidth(Image);
            TargetGrayIMGBuf = InitMaskBuf.DoubleInitMask(height, width);
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    TargetGrayIMGBuf[i][j] = Image[i][j] == oldConstant ? newConstant : Image[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ImageGSException e) {
            throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf()  >> " + e.getMessage());
        }
        return TargetGrayIMGBuf;
    }
}

