/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.Util.Clamping;
import com.conv2.imageGS.Util.CopyIMGBuf;
import com.conv2.imageGS.Util.GetSizeIMG;
import com.conv2.imageGS.Util.InitIMGBuf;

public final class Conv2 {
    private Conv2() {
    }

    public static short[][] Conv2OP(short[][] GrayIMG, int[][] Mask) throws ImageGSException {
        short[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2OP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height, GrayIMG_width);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += (double)GrayIMG[i + m][j + n] * (double)Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i][j] = Clamping.ShortSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static short[][] Conv2OP(short[][] GrayIMG, double[][] Mask) throws ImageGSException {
        short[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2OP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height, GrayIMG_width);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += (double)GrayIMG[i + m][j + n] * Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i][j] = Clamping.ShortSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static double[][] Conv2OP(double[][] GrayIMG, double[][] Mask) throws ImageGSException {
        double[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2OP() >>  Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = InitIMGBuf.DoubleIMGBuf(GrayIMG_height, GrayIMG_width);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += GrayIMG[i + m][j + n] * Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i][j] = Clamping.DoubleSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static short[][] Conv2CopyOP(short[][] GrayIMG, int[][] Mask) throws ImageGSException {
        short[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2CopyOP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = CopyIMGBuf.CopyShortGrayIMGBuf(GrayIMG);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += (double)GrayIMG[i + m][j + n] * (double)Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i][j] = Clamping.ShortSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static short[][] Conv2CopyOP(short[][] GrayIMG, double[][] Mask) throws ImageGSException {
        short[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2CopyOP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = CopyIMGBuf.CopyShortGrayIMGBuf(GrayIMG);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += (double)GrayIMG[i + m][j + n] * Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i][j] = Clamping.ShortSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static double[][] Conv2CopyOP(double[][] GrayIMG, double[][] Mask) throws ImageGSException {
        double[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2CopyOP() >>  Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = CopyIMGBuf.CopyDoubleGrayIMGBuf(GrayIMG);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += GrayIMG[i + m][j + n] * Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i][j] = Clamping.DoubleSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static short[][] Conv2CenterOP(short[][] GrayIMG, int[][] Mask) throws ImageGSException {
        short[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2CenterOP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int half_height = (int)Math.round((double)Mask_height / 2.0);
        int half_width = (int)Math.round((double)Mask_width / 2.0);
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height, GrayIMG_width);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += (double)(GrayIMG[i + m][j + n] * Mask[m][n]);
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i + half_height][j + half_width] = Clamping.ShortSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static short[][] Conv2CenterOP(short[][] GrayIMG, double[][] Mask) throws ImageGSException {
        short[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2CenterOP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int half_height = (int)Math.round((double)Mask_height / 2.0);
        int half_width = (int)Math.round((double)Mask_width / 2.0);
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height, GrayIMG_width);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += (double)GrayIMG[i + m][j + n] * Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i + half_height][j + half_width] = Clamping.ShortSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static double[][] Conv2CenterOP(double[][] GrayIMG, double[][] Mask) throws ImageGSException {
        double[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2CenterOP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int half_height = (int)Math.round((double)Mask_height / 2.0);
        int half_width = (int)Math.round((double)Mask_width / 2.0);
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = InitIMGBuf.DoubleIMGBuf(GrayIMG_height, GrayIMG_width);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += GrayIMG[i + m][j + n] * Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i + half_height][j + half_width] = Clamping.DoubleSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static short[][] Conv2CenterCopyOP(short[][] GrayIMG, int[][] Mask) throws ImageGSException {
        short[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2CenterCopyOP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int half_height = (int)Math.round((double)Mask_height / 2.0);
        int half_width = (int)Math.round((double)Mask_width / 2.0);
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = CopyIMGBuf.CopyShortGrayIMGBuf(GrayIMG);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += (double)(GrayIMG[i + m][j + n] * Mask[m][n]);
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i + half_height][j + half_width] = Clamping.ShortSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static short[][] Conv2CenterCopyOP(short[][] GrayIMG, double[][] Mask) throws ImageGSException {
        short[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2CenterCopyOP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int half_height = (int)Math.round((double)Mask_height / 2.0);
        int half_width = (int)Math.round((double)Mask_width / 2.0);
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = CopyIMGBuf.CopyShortGrayIMGBuf(GrayIMG);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += (double)GrayIMG[i + m][j + n] * Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i + half_height][j + half_width] = Clamping.ShortSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static double[][] Conv2CenterCopyOP(double[][] GrayIMG, double[][] Mask) throws ImageGSException {
        double[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2CenterCopyOP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int half_height = (int)Math.round((double)Mask_height / 2.0);
        int half_width = (int)Math.round((double)Mask_width / 2.0);
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        ResultIMG = CopyIMGBuf.CopyDoubleGrayIMGBuf(GrayIMG);
        i = 0;
        while (i < GrayIMG_height - Mask_height) {
            j = 0;
            while (j < GrayIMG_width - Mask_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += GrayIMG[i + m][j + n] * Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i + half_height][j + half_width] = Clamping.DoubleSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static short[][] Conv2DeleteOP(short[][] GrayIMG, int[][] Mask) throws ImageGSException {
        short[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2OP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        short[][] tmpIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height + Mask_height, GrayIMG_width + Mask_width);
        i = 0;
        while (i < GrayIMG_height) {
            j = 0;
            while (j < GrayIMG_width) {
                tmpIMG[i][j] = GrayIMG[i][j];
                ++j;
            }
            ++i;
        }
        ResultIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height, GrayIMG_width);
        i = 0;
        while (i < GrayIMG_height) {
            j = 0;
            while (j < GrayIMG_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += (double)tmpIMG[i + m][j + n] * (double)Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i][j] = Clamping.ShortSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static short[][] Conv2DeleteOP(short[][] GrayIMG, double[][] Mask) throws ImageGSException {
        short[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2OP() : Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        short[][] tmpIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height + Mask_height, GrayIMG_width + Mask_width);
        i = 0;
        while (i < GrayIMG_height) {
            j = 0;
            while (j < GrayIMG_width) {
                tmpIMG[i][j] = GrayIMG[i][j];
                ++j;
            }
            ++i;
        }
        ResultIMG = InitIMGBuf.ShortIMGBuf(GrayIMG_height, GrayIMG_width);
        i = 0;
        while (i < GrayIMG_height) {
            j = 0;
            while (j < GrayIMG_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += (double)tmpIMG[i + m][j + n] * Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i][j] = Clamping.ShortSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }

    public static double[][] Conv2DeleteOP(double[][] GrayIMG, double[][] Mask) throws ImageGSException {
        double[][] ResultIMG = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (GrayIMG == null || Mask == null) {
            throw new ImageGSException("Conv2.Conv2OP() >>  Unknown size of GrayIMG or Mask");
        }
        int Mask_height = Mask.length;
        int Mask_width = Mask[Mask_height - 1].length;
        int GrayIMG_height = GetSizeIMG.HeightFromGrayIMG(GrayIMG);
        int GrayIMG_width = GetSizeIMG.WidthFromGrayIMG(GrayIMG);
        double[][] tmpIMG = InitIMGBuf.DoubleIMGBuf(GrayIMG_height + Mask_height, GrayIMG_width + Mask_width);
        i = 0;
        while (i < GrayIMG_height) {
            j = 0;
            while (j < GrayIMG_width) {
                tmpIMG[i][j] = GrayIMG[i][j];
                ++j;
            }
            ++i;
        }
        ResultIMG = InitIMGBuf.DoubleIMGBuf(GrayIMG_height, GrayIMG_width);
        i = 0;
        while (i < GrayIMG_height) {
            j = 0;
            while (j < GrayIMG_width) {
                var = 0.0;
                m = 0;
                while (m < Mask_height) {
                    n = 0;
                    while (n < Mask_width) {
                        var += tmpIMG[i + m][j + n] * Mask[m][n];
                        ++n;
                    }
                    ++m;
                }
                ResultIMG[i][j] = Clamping.DoubleSaturation(var);
                ++j;
            }
            ++i;
        }
        return ResultIMG;
    }
}

