/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.Channel2BufferedImage;
import com.conv2.imageGS.IMGFileIO.ImagePanel;
import com.conv2.imageGS.Util.InitIMGBuf;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import javax.swing.JPanel;

public class PGMImage {
    public static final int PGM = 1;
    private int type;
    private String fname;
    private BufferedImage myBufferedImage = null;
    private short[][] GrayChannel = null;
    private int height = 0;
    private int width = 0;
    protected ImagePanel panel;

    public PGMImage(String fname) throws ImageGSException {
        this.fname = fname;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public short[][] getGrayChannel() {
        return this.GrayChannel;
    }

    private void setType(int type) throws ImageGSException {
        if (type != 1) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + "No such image type");
        }
        this.type = type;
    }

    private String readHeader(FileInputStream in) throws IOException {
        char ch;
        StringBuffer result = new StringBuffer("");
        while ((ch = (char)in.read()) != '\n') {
            result.append(ch);
        }
        result.append('\n');
        while ((ch = (char)in.read()) == '#') {
            while (in.read() != 10) {
            }
        }
        do {
            result.append(ch);
        } while ((ch = (char)in.read()) != '\n');
        do {
            result.append(ch);
        } while ((ch = (char)in.read()) != '\n');
        result.append('\n');
        return result.toString();
    }

    private void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    private void setup(String hdr) throws IOException, ImageGSException {
        StreamTokenizer st = new StreamTokenizer(new StringReader(hdr));
        st.eolIsSignificant(false);
        st.commentChar(35);
        st.whitespaceChars(0, 32);
        if (st.nextToken() != -3) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Wrong file format");
        }
        if (!st.sval.equals("P5")) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad magic number");
        }
        int type = 1;
        if (st.nextToken() != -2) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad image width 1");
        }
        int w = (int)st.nval;
        if (w <= 0) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad image width 2");
        }
        if (st.nextToken() != -2) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad image height");
        }
        int h = (int)st.nval;
        if (h <= 0) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad image height");
        }
        if (st.nextToken() != -2) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad image depth");
        }
        st.eolIsSignificant(true);
        if (st.nextToken() != 10) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad end of header");
        }
        this.setSize(w, h);
        this.setType(type);
    }

    public void load() throws ImageGSException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.fname);
            String header = this.readHeader(in);
            this.setup(header);
            int total = this.width * this.height;
            this.GrayChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            int i = 0;
            while (i < this.height) {
                int j = 0;
                while (j < this.width) {
                    this.GrayChannel[i][j] = (short)in.read();
                    ++j;
                }
                ++i;
            }
            in.close();
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">>" + e.getMessage());
        }
        catch (ImageGSException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public JPanel getImagePanel() {
        this.panel = new ImagePanel(this.getBufferedImage());
        return this.panel;
    }

    public BufferedImage getBufferedImage() {
        try {
            Channel2BufferedImage cb = new Channel2BufferedImage();
            cb.gray(this.GrayChannel, this.height, this.width);
            this.myBufferedImage = cb.getBufferedImage();
        }
        catch (ImageGSException imageGSException) {
            // empty catch block
        }
        return this.myBufferedImage;
    }

    public void save(String OutFname, short[][] OutGrayChannel) throws ImageGSException {
        this.fname = OutFname;
        this.save(OutGrayChannel, this.getHeight(), this.getWidth());
    }

    public void save(String OutFname, short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException {
        this.fname = OutFname;
        this.save(OutGrayChannel, OutHeight, OutWidth);
    }

    public void save(short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException {
        FileOutputStream out = null;
        PrintWriter pw = null;
        try {
            out = new FileOutputStream(this.fname);
            pw = new PrintWriter(out);
            pw.println("P5");
            pw.println("#imageGS API, Lee, Moon-Ho, 2003");
            pw.print(OutWidth);
            pw.print(" ");
            pw.println(OutHeight);
            pw.println("255");
            pw.flush();
            int i = 0;
            while (i < OutHeight) {
                int j = 0;
                while (j < OutWidth) {
                    out.write((byte)OutGrayChannel[i][j]);
                    ++j;
                }
                ++i;
            }
            pw.close();
            out.close();
        }
        catch (Exception e) {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }
}

