/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.BMPImagePanel;
import com.conv2.imageGS.Util.InitIMGBuf;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JPanel;

public class BMPImage {
    private String fname;
    private BufferedImage myBufferedImage = null;
    private short[][] RedChannel = null;
    private short[][] GreenChannel = null;
    private short[][] BlueChannel = null;
    private short[][] GrayChannel = null;
    private int alpha = -16777216;
    protected BMPImagePanel panel;
    private byte[] bytebuffer;
    private int i;
    private int j;
    private int windowLong;
    private short windowInt;
    private DataInputStream d;
    private int BMPsize;
    private int BMPreserved;
    private int BMPimageoffset;
    private int BMPheadersize;
    private int BMPwidth;
    private int BMPheight;
    private short BMPplanes;
    private short BMPbitsPerPixel;
    private int BMPcompression;
    private int BMPsizeOfBitmap;
    private int BMPhorzResolution;
    private int BMPvertResolution;
    private int BMPcolorsUsed;
    private int BMPcolorsImportant;
    private Color[] colorTable;
    private int[] pixels;
    private int colorIndex;
    private int bytesPerLine;
    private byte[] scanline;
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bitmapFileHeader = new byte[14];
    private byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private int bfReserved1 = 0;
    private int bfReserved2 = 0;
    private int bfOffBits = 54;
    private byte[] bitmapInfoHeader = new byte[40];
    private int biSize = 40;
    private int biWidth = 0;
    private int biHeight = 0;
    private int biPlanes = 1;
    private int biBitCount = 24;
    private int biCompression = 0;
    private int biSizeImage = 196608;
    private int biXPelsPerMeter = 0;
    private int biYPelsPerMeter = 0;
    private int biClrUsed = 0;
    private int biClrImportant = 0;
    private FileOutputStream fout_stream = null;
    int[] save_bmpdata = null;

    public BMPImage(String fname) throws ImageGSException {
        this.fname = fname;
    }

    public int getHeight() {
        return this.BMPheight;
    }

    public int getWidth() {
        return this.BMPwidth;
    }

    public short[][] getRedChannel() {
        return this.RedChannel;
    }

    public short[][] getGreenChannel() {
        return this.GreenChannel;
    }

    public short[][] getBlueChannel() {
        return this.BlueChannel;
    }

    public short[][] getGrayChannel() {
        return this.GrayChannel;
    }

    public void load() throws ImageGSException {
        FileInputStream fstream = null;
        boolean colortype = true;
        try {
            fstream = new FileInputStream(this.fname);
            this.d = new DataInputStream(fstream);
            this.parseit();
            if (this.BMPbitsPerPixel != 24) {
                this.RedChannel = InitIMGBuf.ShortIMGBuf(this.BMPheight, this.BMPwidth);
                this.GreenChannel = InitIMGBuf.ShortIMGBuf(this.BMPheight, this.BMPwidth);
                this.BlueChannel = InitIMGBuf.ShortIMGBuf(this.BMPheight, this.BMPwidth);
                this.GrayChannel = InitIMGBuf.ShortIMGBuf(this.BMPheight, this.BMPwidth);
                int length = this.BMPwidth * this.BMPheight;
                int tmp_width = 0;
                int tmp_height = 0;
                this.myBufferedImage = new BufferedImage(this.BMPwidth, this.BMPheight, 1);
                int[] three_pixels = new int[this.pixels.length * 3];
                this.i = 0;
                while (this.i < this.pixels.length) {
                    three_pixels[this.i] = this.pixels[this.i];
                    three_pixels[this.i + 1] = this.pixels[this.i];
                    three_pixels[this.i + 2] = this.pixels[this.i];
                    ++this.i;
                }
                this.i = 0;
                while (this.i < length) {
                    if (tmp_width == this.BMPwidth) {
                        ++tmp_height;
                        tmp_width = 0;
                    }
                    this.setPixel(tmp_width, tmp_height, three_pixels[this.i]);
                    this.RedChannel[tmp_height][tmp_width] = this.getR(tmp_width, tmp_height);
                    this.GreenChannel[tmp_height][tmp_width] = this.getG(tmp_width, tmp_height);
                    this.BlueChannel[tmp_height][tmp_width] = this.getB(tmp_width, tmp_height);
                    this.GrayChannel[tmp_height][tmp_width] = (short)((double)this.RedChannel[tmp_height][tmp_width] * 0.299 + (double)this.GreenChannel[tmp_height][tmp_width] * 0.587 + (double)this.BlueChannel[tmp_height][tmp_width] * 0.114);
                    ++tmp_width;
                    ++this.i;
                }
            } else {
                this.RedChannel = InitIMGBuf.ShortIMGBuf(this.BMPheight, this.BMPwidth);
                this.GreenChannel = InitIMGBuf.ShortIMGBuf(this.BMPheight, this.BMPwidth);
                this.BlueChannel = InitIMGBuf.ShortIMGBuf(this.BMPheight, this.BMPwidth);
                this.GrayChannel = InitIMGBuf.ShortIMGBuf(this.BMPheight, this.BMPwidth);
                int length = this.BMPwidth * this.BMPheight;
                int tmp_width = 0;
                int tmp_height = 0;
                this.myBufferedImage = new BufferedImage(this.BMPwidth, this.BMPheight, 1);
                this.i = 0;
                while (this.i < length) {
                    if (tmp_width == this.BMPwidth) {
                        ++tmp_height;
                        tmp_width = 0;
                    }
                    this.setPixel(tmp_width, tmp_height, this.pixels[this.i]);
                    this.RedChannel[tmp_height][tmp_width] = this.getR(tmp_width, tmp_height);
                    this.GreenChannel[tmp_height][tmp_width] = this.getG(tmp_width, tmp_height);
                    this.BlueChannel[tmp_height][tmp_width] = this.getB(tmp_width, tmp_height);
                    this.GrayChannel[tmp_height][tmp_width] = (short)((double)this.RedChannel[tmp_height][tmp_width] * 0.299 + (double)this.GreenChannel[tmp_height][tmp_width] * 0.587 + (double)this.BlueChannel[tmp_height][tmp_width] * 0.114);
                    ++tmp_width;
                    ++this.i;
                }
            }
            fstream.close();
        }
        catch (IOException e) {
            if (fstream != null) {
                try {
                    fstream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
        if (!colortype) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "This image data don't have color type");
        }
    }

    public BufferedImage getBufferedImage() throws ImageGSException {
        if (this.myBufferedImage == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "BufferedImage is null");
        }
        this.panel = new BMPImagePanel(this.myBufferedImage);
        return this.myBufferedImage;
    }

    public JPanel getImagePanel() {
        return this.panel;
    }

    private short getR(int x, int y) {
        return (short)this.myBufferedImage.getColorModel().getRed(this.myBufferedImage.getRGB(x, y));
    }

    private short getG(int x, int y) {
        return (short)this.myBufferedImage.getColorModel().getGreen(this.myBufferedImage.getRGB(x, y));
    }

    private short getB(int x, int y) {
        return (short)this.myBufferedImage.getColorModel().getBlue(this.myBufferedImage.getRGB(x, y));
    }

    private void setPixel(int x, int y, int rgb) {
        this.myBufferedImage.setRGB(x, y, rgb);
    }

    private void setPixel(int x, int y, short r, short g, short b) {
        this.setPixel(x, y, this.packRGB(r, g, b));
    }

    private int packRGB(short r, short g, short b) {
        return this.alpha + 65536 * r + 256 * g + b;
    }

    private synchronized void parseit() throws IOException {
        this.parseit(0);
    }

    private synchronized void parseit(int typeFlag) throws IOException {
        byte[] f_long = new byte[4];
        byte[] f_int = new byte[2];
        boolean count = false;
        if (typeFlag == 0) {
            byte[] tempBuffer = null;
            tempBuffer = new byte[2];
            this.d.read(tempBuffer);
            this.BMPsize = this.readLong(this.d);
            this.BMPreserved = this.readLong(this.d);
            this.BMPimageoffset = this.readLong(this.d);
        }
        this.BMPheadersize = this.readLong(this.d);
        this.BMPwidth = this.readLong(this.d);
        this.BMPheight = this.readLong(this.d);
        this.BMPplanes = this.readInt(this.d);
        this.BMPbitsPerPixel = this.readInt(this.d);
        this.BMPcompression = this.readLong(this.d);
        this.BMPsizeOfBitmap = this.readLong(this.d);
        this.BMPhorzResolution = this.readLong(this.d);
        this.BMPvertResolution = this.readLong(this.d);
        this.BMPcolorsUsed = this.readLong(this.d);
        this.BMPcolorsImportant = this.readLong(this.d);
        this.pixels = new int[this.BMPwidth * (this.BMPheight + 1)];
        if (this.BMPbitsPerPixel == 1) {
            this.colorTable = new Color[2];
            this.i = 0;
            while (this.i < 2) {
                this.colorTable[this.i] = this.win2Color(this.readLong(this.d));
                ++this.i;
            }
            this.bytesPerLine = this.BMPwidth / 8;
            if (this.bytesPerLine * 8 < this.BMPwidth) {
                ++this.bytesPerLine;
            }
            while (this.bytesPerLine % 4 != 0) {
                ++this.bytesPerLine;
            }
            this.scanline = new byte[this.bytesPerLine];
            this.i = this.BMPheight - 1;
            while (this.i >= 0) {
                this.d.readFully(this.scanline, 0, this.bytesPerLine);
                this.j = 0;
                while (this.j < this.BMPwidth) {
                    this.colorIndex = this.scanline[this.j / 8] >> 7 & 1;
                    this.pixels[this.i * this.BMPwidth + this.j] = this.colorTable[this.colorIndex].getRGB();
                    this.colorIndex = this.scanline[this.j / 8] >> 6 & 1;
                    this.pixels[this.i * this.BMPwidth + this.j + 1] = this.colorTable[this.colorIndex].getRGB();
                    this.colorIndex = this.scanline[this.j / 8] >> 5 & 1;
                    this.pixels[this.i * this.BMPwidth + this.j + 2] = this.colorTable[this.colorIndex].getRGB();
                    this.colorIndex = this.scanline[this.j / 8] >> 4 & 1;
                    this.pixels[this.i * this.BMPwidth + this.j + 3] = this.colorTable[this.colorIndex].getRGB();
                    this.colorIndex = this.scanline[this.j / 8] >> 3 & 1;
                    this.pixels[this.i * this.BMPwidth + this.j + 4] = this.colorTable[this.colorIndex].getRGB();
                    this.colorIndex = this.scanline[this.j / 8] >> 2 & 1;
                    this.pixels[this.i * this.BMPwidth + this.j + 5] = this.colorTable[this.colorIndex].getRGB();
                    this.colorIndex = this.scanline[this.j / 8] >> 1 & 1;
                    this.pixels[this.i * this.BMPwidth + this.j + 6] = this.colorTable[this.colorIndex].getRGB();
                    this.colorIndex = this.scanline[this.j / 8] & 1;
                    this.pixels[this.i * this.BMPwidth + this.j + 7] = this.colorTable[this.colorIndex].getRGB();
                    this.j += 8;
                }
                --this.i;
            }
        }
        if (this.BMPbitsPerPixel == 4) {
            this.colorTable = new Color[16];
            this.i = 0;
            while (this.i < 16) {
                this.colorTable[this.i] = this.win2Color(this.readLong(this.d));
                ++this.i;
            }
            this.bytesPerLine = this.BMPwidth / 2;
            if (this.bytesPerLine * 2 < this.BMPwidth) {
                ++this.bytesPerLine;
            }
            while (this.bytesPerLine % 4 != 0) {
                ++this.bytesPerLine;
            }
            this.scanline = new byte[this.bytesPerLine];
            this.i = this.BMPheight - 1;
            while (this.i >= 0) {
                this.d.readFully(this.scanline, 0, this.bytesPerLine);
                this.j = 0;
                while (this.j < this.BMPwidth) {
                    this.colorIndex = this.scanline[this.j / 2] >> 4 & 0xF;
                    this.pixels[this.i * this.BMPwidth + this.j] = this.colorTable[this.colorIndex].getRGB();
                    this.colorIndex = this.scanline[this.j / 2] & 0xF;
                    this.pixels[this.i * this.BMPwidth + this.j + 1] = this.colorTable[this.colorIndex].getRGB();
                    this.j += 2;
                }
                --this.i;
            }
        }
        if (this.BMPbitsPerPixel == 8) {
            this.colorTable = new Color[256];
            this.i = 0;
            while (this.i < 256) {
                this.colorTable[this.i] = this.win2Color(this.readLong(this.d));
                ++this.i;
            }
            this.bytesPerLine = this.BMPwidth;
            while (this.bytesPerLine % 4 != 0) {
                ++this.bytesPerLine;
            }
            this.scanline = new byte[this.bytesPerLine];
            this.i = this.BMPheight - 1;
            while (this.i >= 0) {
                this.d.readFully(this.scanline);
                this.j = 0;
                while (this.j < this.BMPwidth) {
                    this.colorIndex = this.scanline[this.j];
                    if (this.colorIndex < 0) {
                        this.colorIndex += 256;
                    }
                    this.pixels[this.i * this.BMPwidth + this.j] = this.colorTable[this.colorIndex].getRGB();
                    ++this.j;
                }
                --this.i;
            }
        }
        if (this.BMPbitsPerPixel == 24) {
            this.bytesPerLine = 3 * this.BMPwidth;
            while (this.bytesPerLine % 4 != 0) {
                ++this.bytesPerLine;
            }
            this.scanline = new byte[this.bytesPerLine + 4];
            this.i = this.BMPheight - 1;
            while (this.i >= 0) {
                this.d.readFully(this.scanline, 0, this.bytesPerLine);
                this.j = 0;
                while (this.j < this.bytesPerLine) {
                    int winBlue = this.scanline[this.j] & 0xFF;
                    int winGreen = (this.scanline[this.j + 1] & 0xFF) << 8;
                    int winRed = (this.scanline[this.j + 2] & 0xFF) << 16;
                    this.pixels[this.i * this.BMPwidth + this.j / 3] = -16777216;
                    int n = this.i * this.BMPwidth + this.j / 3;
                    this.pixels[n] = this.pixels[n] | winRed;
                    int n2 = this.i * this.BMPwidth + this.j / 3;
                    this.pixels[n2] = this.pixels[n2] | winGreen;
                    int n3 = this.i * this.BMPwidth + this.j / 3;
                    this.pixels[n3] = this.pixels[n3] | winBlue;
                    this.j += 3;
                }
                --this.i;
            }
        }
    }

    private Color win2Color(int colorValue) {
        int rgbBlue = 0xFF0000;
        int rgbGreen = 65280;
        int rgbRed = 255;
        int javaRed = (colorValue & rgbBlue) / 65536;
        int javaGreen = (colorValue & rgbGreen) / 256;
        int javaBlue = colorValue & rgbRed;
        return new Color(javaRed, javaGreen, javaBlue);
    }

    private int readLong(DataInputStream d) {
        byte[] longBuf = new byte[4];
        try {
            d.readFully(longBuf);
            return this.flipLong(longBuf);
        }
        catch (IOException e) {
            return 99;
        }
    }

    private short readInt(DataInputStream d) {
        byte[] intBuf = new byte[2];
        try {
            d.readFully(intBuf);
            return this.flipInt(intBuf);
        }
        catch (IOException e) {
            return 99;
        }
    }

    private int flipLong(byte[] byteFlip) {
        byte[] bytebuffer = new byte[]{byteFlip[3], byteFlip[2], byteFlip[1], byteFlip[0]};
        ByteArrayInputStream b_in = new ByteArrayInputStream(bytebuffer);
        DataInputStream dl = new DataInputStream(b_in);
        try {
            return dl.readInt();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    private short flipInt(byte[] byteFlip) {
        byte[] bytebuffer = new byte[]{byteFlip[1], byteFlip[0]};
        ByteArrayInputStream b_in = new ByteArrayInputStream(bytebuffer);
        DataInputStream d = new DataInputStream(b_in);
        try {
            return d.readShort();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void save(String OutFname, short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException {
        this.fname = OutFname;
        this.save(OutGrayChannel, OutHeight, OutWidth);
    }

    public void save(short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException {
        this.save(OutGrayChannel, OutGrayChannel, OutGrayChannel, OutHeight, OutWidth);
    }

    public void save(String OutFname, short[][] OutRedChannel, short[][] OutGreenChannel, short[][] OutBlueChannel, int OutHeight, int OutWidth) throws ImageGSException {
        this.fname = OutFname;
        this.save(OutRedChannel, OutGreenChannel, OutBlueChannel, OutHeight, OutWidth);
    }

    public void save(short[][] OutRedChannel, short[][] OutGreenChannel, short[][] OutBlueChannel, int OutHeight, int OutWidth) throws ImageGSException {
        BufferedImage outputBufferedImage = null;
        int count = 0;
        try {
            outputBufferedImage = new BufferedImage(OutWidth, OutHeight, 1);
            this.fout_stream = new FileOutputStream(this.fname);
            this.save_bmpdata = new int[OutHeight * OutWidth];
            this.i = 0;
            while (this.i < OutHeight) {
                this.j = 0;
                while (this.j < OutWidth) {
                    short r = OutRedChannel[this.i][this.j];
                    short g = OutGreenChannel[this.i][this.j];
                    short b = OutBlueChannel[this.i][this.j];
                    outputBufferedImage.setRGB(this.j, this.i, this.packRGB(r, g, b));
                    this.save_bmpdata[count] = outputBufferedImage.getRGB(this.j, this.i);
                    ++count;
                    ++this.j;
                }
                ++this.i;
            }
            int pad = (4 - OutWidth * 3 % 4) * OutHeight;
            this.biSizeImage = OutWidth * OutHeight * 3 + pad;
            this.bfSize = this.biSizeImage + 14 + 40;
            this.biWidth = OutWidth;
            this.biHeight = OutHeight;
            this.writeBitmapFileHeader();
            this.writeBitmapInfoHeader();
            this.writeBitmap();
            this.fout_stream.close();
        }
        catch (Exception e) {
            if (this.fout_stream != null) {
                try {
                    this.fout_stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }

    private void writeBitmap() throws Exception {
        int rowIndex;
        byte[] rgb = new byte[3];
        int size = this.biWidth * this.biHeight - 1;
        int pad = 4 - this.biWidth * 3 % 4;
        if (pad == 4) {
            pad = 0;
        }
        int rowCount = 1;
        int padCount = 0;
        int lastRowIndex = rowIndex = size - this.biWidth;
        int j = 0;
        while (j < size) {
            int value = this.save_bmpdata[rowIndex];
            rgb[0] = (byte)(value & 0xFF);
            rgb[1] = (byte)(value >> 8 & 0xFF);
            rgb[2] = (byte)(value >> 16 & 0xFF);
            this.fout_stream.write(rgb);
            if (rowCount == this.biWidth) {
                padCount += pad;
                int i = 1;
                while (i <= pad) {
                    this.fout_stream.write(0);
                    ++i;
                }
                rowCount = 1;
                lastRowIndex = rowIndex = lastRowIndex - this.biWidth;
            } else {
                ++rowCount;
            }
            ++rowIndex;
            ++j;
        }
        this.bfSize += padCount - pad;
        this.biSizeImage += padCount - pad;
    }

    private void writeBitmapFileHeader() throws Exception {
        this.fout_stream.write(this.bfType);
        this.fout_stream.write(this.intToDWord(this.bfSize));
        this.fout_stream.write(this.intToWord(this.bfReserved1));
        this.fout_stream.write(this.intToWord(this.bfReserved2));
        this.fout_stream.write(this.intToDWord(this.bfOffBits));
    }

    private void writeBitmapInfoHeader() throws Exception {
        this.fout_stream.write(this.intToDWord(this.biSize));
        this.fout_stream.write(this.intToDWord(this.biWidth));
        this.fout_stream.write(this.intToDWord(this.biHeight));
        this.fout_stream.write(this.intToWord(this.biPlanes));
        this.fout_stream.write(this.intToWord(this.biBitCount));
        this.fout_stream.write(this.intToDWord(this.biCompression));
        this.fout_stream.write(this.intToDWord(this.biSizeImage));
        this.fout_stream.write(this.intToDWord(this.biXPelsPerMeter));
        this.fout_stream.write(this.intToDWord(this.biYPelsPerMeter));
        this.fout_stream.write(this.intToDWord(this.biClrUsed));
        this.fout_stream.write(this.intToDWord(this.biClrImportant));
    }

    private byte[] intToWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF)};
        return retValue;
    }

    private byte[] intToDWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF), (byte)(parValue >> 16 & 0xFF), (byte)(parValue >> 24 & 0xFF)};
        return retValue;
    }
}

