/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.doclets;

import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.IndexBuilder;
import com.wgshim.doclets.AbstractIndexWriter;
import com.wgshim.doclets.ConfigurationStandard;
import com.wgshim.doclets.Standard;
import java.io.IOException;
import java.io.PrintWriter;

public class SplitIndexWriter
extends AbstractIndexWriter {
    protected int prev;
    protected int next;

    public SplitIndexWriter(String path, String filename, String relpath, IndexBuilder indexbuilder, int prev, int next) throws IOException {
        super(path, filename, relpath, indexbuilder);
        this.prev = prev;
        this.next = next;
    }

    public static void generate(IndexBuilder indexbuilder) throws DocletAbortException {
        String filename = "";
        String path = DirectoryManager.getPath((String)"index-files");
        String relpath = DirectoryManager.getRelativePath((String)"index-files");
        try {
            int i = 0;
            while (i < indexbuilder.elements().length) {
                int j = i + 1;
                int prev = j == 1 ? -1 : i;
                int next = j == indexbuilder.elements().length ? -1 : j + 1;
                filename = "index-" + j + ".html";
                SplitIndexWriter indexgen = new SplitIndexWriter(path, filename, relpath, indexbuilder, prev, next);
                indexgen.generateIndexFile((Character)indexbuilder.elements()[i]);
                ((PrintWriter)((Object)indexgen)).close();
                ++i;
            }
        }
        catch (IOException exc) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateIndexFile(Character unicode) throws IOException {
        this.printHeader(this.getText("doclet.Window_Split_Index", Standard.configuration().windowtitle, unicode.toString()));
        this.navLinks(true);
        this.printLinksForIndexes();
        this.hr();
        this.generateContents(unicode, this.indexbuilder.getMemberList(unicode));
        this.navLinks(false);
        this.printLinksForIndexes();
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printLinksForIndexes() {
        int i = 0;
        while (i < this.indexbuilder.elements().length) {
            int j = i + 1;
            this.printHyperLink("index-" + j + ".html", this.indexbuilder.elements()[i].toString());
            ((PrintWriter)((Object)this)).print(' ');
            ++i;
        }
    }

    protected void navLinkPrevious() {
        if (this.prev == -1) {
            this.printText("doclet.Prev_Letter");
        } else {
            this.printHyperLink("index-" + this.prev + ".html", "", this.getText("doclet.Prev_Letter"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == -1) {
            this.printText("doclet.Next_Letter");
        } else {
            this.printHyperLink("index-" + this.next + ".html", "", this.getText("doclet.Next_Letter"), true);
        }
    }
}

