/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.IndexBuilder;
import com.wgshim.doclets.HtmlStandardWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class AbstractIndexWriter
extends HtmlStandardWriter {
    protected IndexBuilder indexbuilder;

    protected AbstractIndexWriter(String path, String filename, String relpath, IndexBuilder indexbuilder) throws IOException {
        super(path, filename, relpath);
        this.indexbuilder = indexbuilder;
    }

    protected AbstractIndexWriter(String filename, IndexBuilder indexbuilder) throws IOException {
        super(filename);
        this.indexbuilder = indexbuilder;
    }

    protected void navLinkIndex() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Index");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void generateContents(Character unicode, List memberlist) {
        this.anchor("_" + unicode + "_");
        this.h2();
        this.bold(unicode.toString());
        this.h2End();
        this.dl();
        int i = 0;
        while (i < memberlist.size()) {
            Doc element = (Doc)memberlist.get(i);
            if (element instanceof MemberDoc) {
                this.printDescription((MemberDoc)element);
            } else if (element instanceof ClassDoc) {
                this.printDescription((ClassDoc)element);
            } else if (element instanceof PackageDoc) {
                this.printDescription((PackageDoc)element);
            }
            ++i;
        }
        this.dlEnd();
        this.hr();
    }

    protected void printDescription(PackageDoc pd) {
        this.dt();
        this.printPackageLink(pd, true);
        ((PrintWriter)((Object)this)).print(" - ");
        ((PrintWriter)((Object)this)).print("package " + pd.name());
        this.dd();
        this.printSummaryComment((Doc)pd);
    }

    protected void printDescription(ClassDoc cd) {
        this.dt();
        this.printClassLink(cd, true);
        ((PrintWriter)((Object)this)).print(" - ");
        this.printClassInfo(cd);
        this.dd();
        this.printComment((ProgramElementDoc)cd);
    }

    protected void printClassInfo(ClassDoc cd) {
        if (cd.isOrdinaryClass()) {
            ((PrintWriter)((Object)this)).print("class ");
        } else if (cd.isInterface()) {
            ((PrintWriter)((Object)this)).print("interface ");
        } else if (cd.isException()) {
            ((PrintWriter)((Object)this)).print("exception ");
        } else {
            ((PrintWriter)((Object)this)).print("error ");
        }
        this.printPreQualifiedClassLink(cd);
        ((PrintWriter)((Object)this)).print('.');
    }

    protected void printDescription(MemberDoc element) {
        String name = element instanceof ExecutableMemberDoc ? String.valueOf(element.name()) + ((ExecutableMemberDoc)element).flatSignature() : element.name();
        ClassDoc containing = element.containingClass();
        String qualname = containing.qualifiedName();
        String baseClassName = containing.name();
        this.dt();
        this.printDocLink((Doc)element, name, true);
        ((PrintWriter)((Object)this)).println(" - ");
        this.printMemberDesc(element);
        ((PrintWriter)((Object)this)).println();
        this.dd();
        this.printComment((ProgramElementDoc)element);
        ((PrintWriter)((Object)this)).println();
    }

    protected void printComment(ProgramElementDoc element) {
        Tag[] tags = element.tags("deprecated");
        if (tags.length > 0) {
            this.boldText("doclet.Deprecated");
            this.space();
            this.printInlineDeprecatedComment(tags[0]);
        } else {
            ClassDoc cont = element.containingClass();
            while (cont != null) {
                if (cont.tags("deprecated").length > 0) {
                    this.boldText("doclet.Deprecated");
                    this.space();
                    break;
                }
                cont = cont.containingClass();
            }
            this.printSummaryComment((Doc)element);
        }
    }

    protected void printMemberDesc(MemberDoc member) {
        ClassDoc containing = member.containingClass();
        String classdesc = String.valueOf(containing.isInterface() ? "interface " : "class ") + this.getPreQualifiedClassLink(containing);
        if (member.isField()) {
            if (member.isStatic()) {
                this.printText("doclet.Static_variable_in", classdesc);
            } else {
                this.printText("doclet.Variable_in", classdesc);
            }
        } else if (member.isConstructor()) {
            this.printText("doclet.Constructor_for", classdesc);
        } else if (member.isMethod()) {
            if (member.isStatic()) {
                this.printText("doclet.Static_method_in", classdesc);
            } else {
                this.printText("doclet.Method_in", classdesc);
            }
        }
    }
}

