/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.bugzilla.doc;

import com.wgshim.bugzilla.doc.LinkedHashMap;
import com.wgshim.bugzilla.doc.WGResource;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class CachedBugShortDescPool {
    private static final int MAX_ENTRIES = Integer.parseInt(WGResource.getInstance().getMessage("bug.short_desccache.size"));
    private static final boolean isCached = MAX_ENTRIES > 0;
    private static Map cache = new LinkedHashMap(MAX_ENTRIES, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > MAX_ENTRIES;
        }
    };

    private CachedBugShortDescPool() {
    }

    public static CachedBugShortDescPool getInstance() {
        return SingletonHolder.singleton;
    }

    public Object add(String bugnum, String szShortDesc) {
        if (isCached) {
            return cache.put(bugnum, szShortDesc);
        }
        return null;
    }

    public Object remove(String bugnum) {
        if (isCached) {
            cache = Collections.synchronizedMap(cache);
            return cache.remove(bugnum);
        }
        return null;
    }

    public void clear() {
        cache.clear();
    }

    public Object get(String bugnum) {
        return cache.get(bugnum);
    }

    public boolean containsKey(String bugnum) {
        if (isCached) {
            return cache.containsKey(bugnum);
        }
        return false;
    }

    public boolean containsValue(String szShortDesc) {
        return cache.containsValue(szShortDesc);
    }

    public void printKeyList() {
        Set set = cache.keySet();
        System.out.println("##### \ud604\uc7ac \ud0a4 \ubaa9\ub85d \ubcf4\uae30[size:" + cache.size() + "]  #####");
        Iterator it = set.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    /* synthetic */ CachedBugShortDescPool(CachedBugShortDescPool cachedBugShortDescPool) {
        this();
    }

    private static final class SingletonHolder {
        static final CachedBugShortDescPool singleton = new CachedBugShortDescPool(null);

        SingletonHolder() {
        }
    }
}

