/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.bugzilla.doc;

import com.sun.javadoc.Tag;
import com.wgshim.bugzilla.doc.BugzillaShortDescHandler;
import com.wgshim.bugzilla.doc.CachedBugShortDescPool;
import com.wgshim.bugzilla.doc.WGResource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class BugzillaBugHTML {
    private static String bugzillaBaseURL = System.getProperty("bugzilla.base.url");
    private static String bugzillaShowBugURL;
    private static String bugzillaXMLBugURL;

    static {
        if (bugzillaBaseURL == null || bugzillaBaseURL.length() == 0) {
            bugzillaBaseURL = WGResource.getInstance().getMessage("bugzilla.base.url");
        }
        if (bugzillaBaseURL.charAt(bugzillaBaseURL.length() - 1) != '/') {
            bugzillaBaseURL = bugzillaBaseURL.concat("/");
        }
        bugzillaShowBugURL = String.valueOf(bugzillaBaseURL) + WGResource.getInstance().getMessage("bugzilla.showbug.query");
        bugzillaXMLBugURL = String.valueOf(bugzillaBaseURL) + WGResource.getInstance().getMessage("bugzilla.xmlbug.query");
    }

    private static String getBugShortDesc(String bugnum) {
        if (CachedBugShortDescPool.getInstance().containsKey(bugnum)) {
            return String.valueOf(CachedBugShortDescPool.getInstance().get(bugnum));
        }
        try {
            URL xmlBugURL = new URL(BugzillaBugHTML.replace(bugzillaXMLBugURL, "{bug_id}", bugnum));
            InputStream is = xmlBugURL.openStream();
            StringBuffer szXMLDoc = new StringBuffer();
            String temp = null;
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(is));
            while ((temp = buffReader.readLine()) != null) {
                szXMLDoc.append(temp);
            }
            String shortDesc = null;
            BugzillaShortDescHandler handler = new BugzillaShortDescHandler();
            handler.parseBugzillaXMLData(szXMLDoc.toString());
            shortDesc = handler.getResult();
            if (CachedBugShortDescPool.getInstance().containsKey(bugnum)) {
                CachedBugShortDescPool.getInstance().add(bugnum, shortDesc);
            }
            return shortDesc;
        }
        catch (Exception e) {
            if (CachedBugShortDescPool.getInstance().containsKey(bugnum)) {
                CachedBugShortDescPool.getInstance().add(bugnum, "");
            }
            return "";
        }
    }

    private static String replace(String text, String tobe, String by) {
        int startindex;
        while ((startindex = text.indexOf(tobe)) >= 0) {
            int endindex = startindex + tobe.length();
            StringBuffer replaced = new StringBuffer();
            if (startindex > 0) {
                replaced.append(text.substring(0, startindex));
            }
            replaced.append(by);
            if (text.length() > endindex) {
                replaced.append(text.substring(endindex));
            }
            text = replaced.toString();
        }
        return text;
    }

    public static String buildBugTags(Tag[] bugs) {
        if (bugs.length > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("<DT>").append("<B>").append(WGResource.getInstance().getMessage("related.bug")).append("</B>").append("<DD>").append(BugzillaBugHTML.makeBugTagsOnly(bugs)).append("</DD>");
            return sb.toString();
        }
        return null;
    }

    private static String makeBugTagsOnly(Tag[] bugs) {
        int count = 0;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < bugs.length) {
            Tag buglem = bugs[i];
            String[] bugdata = BugzillaBugHTML.splitBugNumber(buglem.text());
            if (buglem.text() != null) {
                if (count > 0) {
                    result.append(", ");
                }
                StringBuffer sb = new StringBuffer();
                String bugShortDesc = BugzillaBugHTML.getBugShortDesc(bugdata[0]);
                sb.append("<A HREF=\"").append(BugzillaBugHTML.replace(bugzillaShowBugURL, "{bug_id}", bugdata[0])).append("\" TITLE=\"").append(bugShortDesc).append("\" TARGET=\"_blank\">").append(bugdata[0]).append("</A> - ");
                if (bugdata[1].equals("")) {
                    sb.append(BugzillaBugHTML.escapeHTML(bugShortDesc));
                } else {
                    sb.append(bugdata[1]);
                }
                result.append(sb.toString());
                ++count;
            }
            ++i;
        }
        return result.toString();
    }

    private static String[] splitBugNumber(String text) {
        if (text.indexOf(" ") < 0) {
            return new String[]{text, ""};
        }
        int index = 0;
        while (index < text.length()) {
            if (text.charAt(index) == ' ') break;
            ++index;
        }
        String[] result = new String[]{text.substring(0, index), text.substring(index)};
        return result;
    }

    private static String escapeHTML(String src) {
        return BugzillaBugHTML.replace(BugzillaBugHTML.replace(BugzillaBugHTML.replace(BugzillaBugHTML.replace(BugzillaBugHTML.replace(src, "&", "&amp;"), "<", "&lt;"), ">", "&gt;"), "\"", "&quot;"), "'", "&apos;");
    }

    public static String buildBugTag(Tag buglem) {
        if (buglem != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<DT>").append("<B>").append(WGResource.getInstance().getMessage("related.bug")).append("</B>").append("<DD>").append(BugzillaBugHTML.makeBugTagOnly(buglem)).append("</DD>");
            return sb.toString();
        }
        return null;
    }

    private static String makeBugTagOnly(Tag buglem) {
        String bugnum = buglem.text();
        if (bugnum != null) {
            String[] bugdata = BugzillaBugHTML.splitBugNumber(buglem.text());
            StringBuffer sb = new StringBuffer();
            String bugShortDesc = BugzillaBugHTML.getBugShortDesc(bugdata[0]);
            sb.append("<A HREF=\"").append(BugzillaBugHTML.replace(bugzillaShowBugURL, "{bug_id}", bugdata[0])).append("\" TITLE=\"").append(bugShortDesc).append("\" TARGET=\"_blank\">").append(bugdata[0]).append("</A> - ");
            if (bugdata[1].equals("")) {
                sb.append(BugzillaBugHTML.escapeHTML(bugShortDesc));
            } else {
                sb.append(bugdata[1]);
            }
            return sb.toString();
        }
        return null;
    }

    public static String makeInlineBugTagOnly(String bugnum) {
        if (bugnum != null) {
            StringBuffer sb = new StringBuffer();
            String bugShortDesc = BugzillaBugHTML.getBugShortDesc(bugnum);
            sb.append("<A HREF=\"").append(BugzillaBugHTML.replace(bugzillaShowBugURL, "{bug_id}", bugnum)).append("\" TITLE=\"").append(bugShortDesc).append("\" TARGET=\"_blank\">").append(bugnum).append("</A>");
            return sb.toString();
        }
        return null;
    }

    private static String makeBugNumberOnly(String bugnum) {
        if (bugnum != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<A HREF=\"").append(BugzillaBugHTML.replace(bugzillaShowBugURL, "{bug_id}", bugnum)).append("\" TITLE=\"").append(BugzillaBugHTML.getBugShortDesc(bugnum)).append("\" TARGET=\"_blank\">").append(bugnum).append("</A>");
            return sb.toString();
        }
        return null;
    }

    public static String parseInlineComment(String src) {
        int index = src.indexOf("{@");
        if (index < 0) {
            return src;
        }
        String lowSrc = src.toLowerCase();
        index = lowSrc.indexOf("{@buglink", index);
        if (index < 0) {
            return src;
        }
        StringBuffer buf = new StringBuffer();
        int previndex = 0;
        while (true) {
            if ((index = lowSrc.indexOf("{@buglink", previndex)) < 0) break;
            buf.append(src.substring(previndex, index));
            previndex = index + 9;
            if (previndex >= src.length()) continue;
            int innerIndex = 0;
            int outerIndex = 0;
            while (src.charAt(previndex + innerIndex) == ' ') {
                ++innerIndex;
            }
            previndex += innerIndex;
            while (src.charAt(previndex + outerIndex) != '}') {
                ++outerIndex;
            }
            String bugnum = src.substring(previndex, previndex + outerIndex);
            buf.append(BugzillaBugHTML.makeInlineBugTagOnly(bugnum));
            previndex += outerIndex + 1;
        }
        buf.append(src.substring(previndex));
        return buf.toString();
    }
}

