/*
	BRIX: professional edition

- Original Copyrights by 1989 TAITO "PUZZNIC", cloned by 1990 Epic Megagames "BRIX"
- Developed by Minan2DJ07 (Park Byeong-uk, 2nd07@hanmail.net)
- Font Algorithm by Tokigun (http://tokigun.net)
- SDL Library Version Information

  SDL 1.2.9
  SDL_image 1.2.4
  SDL_mixer 1.2.6

- This game is use only for Not-Commerce
- Latest modified: 2006. 5.16
*/

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <SDL.h>
#include <SDL_mixer.h>
#include <SDL_image.h>
#include <SDL_endian.h>
#include "resource.h"

/******************************************************************************/
/* constants, variables */
// TitleBar Text
char version[] = "BRIX: professional edition v0.0-dev-20060516";

// is it FULLSCREEN ?
int opt_fullscreen = 0;
// Screen Size, Bitrate
int screen_width = 480;
int screen_height = 272;
int screen_bitrate = 32;

// stage array, matrix[y][x]
// size of matrix
int size_x = 22;
int size_y = 15;
int matrix[15][22]={
{-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1}, // 0
{ 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1}, // 1
{ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, // 2
{ 1, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 1}, // 3
{ 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1}, // 4
{ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, // 5
{ 1, 7, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 6, 1}, // 6
{ 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, // 7
{ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, // 8
{ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, // 9
{ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, // 10
{ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, // 11
{ 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1}, // 12
{ 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 4, 5, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1}, // 13
{-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1}  // 14
};
int mode = 6;
int score = 0;
int highscore = 50000;
char mapname[] = "BRIX: professional edition TEST MAP";
// is pressed select key (space bar) ?
int ispressed = 0;
// size of block graphic
int blocksize = 16;
// start-point of stage
int stage_x = 128;
int stage_y = 32;
// point of cursor
int cursor_point[2] = {128+32,32+32};
// time of game start
int timer_start = 0;
// remove condition
int arg[14][3][3] = {
{ {0,0,0}, {1,1,1}, {0,0,0} },
{ {0,1,0}, {0,1,0}, {0,1,0} },
{ {0,1,1}, {0,1,0}, {0,0,0} },
{ {1,1,0}, {0,1,0}, {0,0,0} },
{ {0,0,0}, {0,1,0}, {1,1,0} },
{ {0,0,0}, {0,1,0}, {0,1,1} },
{ {1,0,0}, {1,1,0}, {0,0,0} },
{ {0,0,0}, {1,1,0}, {1,0,0} },
{ {0,0,1}, {0,1,1}, {0,0,0} },
{ {0,0,0}, {0,1,1}, {0,0,1} },
{ {0,1,0}, {0,1,0}, {0,0,0} },
{ {0,0,0}, {0,1,1}, {0,0,0} },
{ {0,0,0}, {0,1,0}, {0,1,0} },
{ {0,0,0}, {1,1,0}, {0,0,0} } };
// pieces of left blocks
int left_block[8] = {0,};
// check stage clear
int isStageClear = 0;

// code by tokigun
#define ARRAYSIZE(x) (sizeof(x)/sizeof(*x))

/******************************************************************************/
/* system dependent functions */
#ifdef WIN32
	#include <windows.h>

	// Output MessageBox
	int msg(char *c,char *s)
	{
		char b[512];
		sprintf(b,c,s);
		return MessageBox(0,b,version,0);
	}

#else
	#include <dirent.h>

	// Output MessageBox
	int msg(char *c,char *s)
	{
		return fprintf(stderr,c,s);
	}

#endif

/******************************************************************************/
/* general functions */

// function by tokigun
int is_space(int n) { return!(n-9&&n-10&&n-13&&n-32); }

// return x,y point to matrix(cell) point
int x2cx(int x)
{
	return (x-stage_x)/blocksize;
}
int y2cy(int y)
{
	return (y-stage_y)/blocksize;
}

/******************************************************************************/
/* general graphic functions */
// Main Screen Object
SDL_Surface *screen;
// Main Event Object
SDL_Event event;

// Original Block BitmapData Surface
SDL_Surface *cursoroff;
SDL_Surface *cursoron;
SDL_Surface *blockdata_bg;
SDL_Surface *blockdata_blank;
SDL_Surface *blockdata_stage;
SDL_Surface *blockdata_sprite1;
SDL_Surface *blockdata_sprite2;
SDL_Surface *blockdata_sprite3;
SDL_Surface *blockdata_sprite4;
SDL_Surface *blockdata_sprite5;
SDL_Surface *blockdata_sprite6;
SDL_Surface *blockdata_sprite7;
SDL_Surface *blockdata_sprite8;

// code and functions by tokigun
SDL_Rect rect[2]; int _rect=0;
int getpixel(SDL_Surface *s, int x, int y)
	{ return((Uint32*)s->pixels)[x+y*s->pitch/4]; }
int putpixel(SDL_Surface *s, int x, int y, int c)
	{ return((Uint32*)s->pixels)[x+y*s->pitch/4]=c; }
int blend(int x, int y, int a, int b)
	{ int i=0;for(;i<24;i+=8)y+=((x>>i&255)-(y>>i&255))*a/b<<i;return y; }
void putblendedpixel(SDL_Surface *s, int x, int y, int c, int o)
	{ putpixel(s, x, y, blend(getpixel(s,x,y), c, o, 255)); }
SDL_Rect *newrect(int x, int y, int w, int h)
	{ SDL_Rect*r=rect+_rect++%2;r->x=x;r->y=y;r->w=w;r->h=h;return r; }

// end functions by tokigun

// load image graphics to SDL Surface
SDL_Surface *loadimage(const int resID, char *type)
{
	SDL_RWops *res_handle;
	HRSRC hres;
	HGLOBAL hnd;
	int rsz;

	res_handle = NULL;
	hres = FindResource(NULL, MAKEINTRESOURCE(resID), type);
	if(hres)
	{
		hnd = LoadResource(NULL, hres);
	}
	if (hnd)
	{
		hnd = LockResource(hnd);
		rsz = SizeofResource(NULL, hres);
	}

	res_handle = SDL_RWFromMem( hnd, rsz );
	if(type == "BMP") return SDL_LoadBMP_RW( res_handle, 1 );
	else return IMG_LoadTyped_RW( res_handle, 1 , type );
}

SDL_Surface *loadimagefromfile(char *file, char *type)
{
	if(type == "BMP") return SDL_LoadBMP(file);
	else return IMG_Load (file);
}

/******************************************************************************/
/* font functions */
// developed by tokigun
char*fontdata="#[RCm#a&#e#;S&e#;C$#;#e&e2Y#e#G#f:i&);V0a;*e%Y#&g7+CC2NP)=aOS=NP"
	"I2+C#fbC(Y;)S#)S/Y3&#hX[S)>OPV=Q<I>^#hh/S#&;#$mseNg#;S#hRe+g#;#&iG;O`YaDDB"
	">R0)jW;C$)a$e&mfh7jSe~a$p?hWir%;#e~C$'jpa/Y;J`YAV0Y;a#hs?S&./#g#b#lB1S$1S$"
	"YBkR&[T#&#kR1[D0I$e#b<C$htb$);C\\*mBebC\\Z;e#iRb0S#)S#)f#krF$f&mRF0Y2lb##h"
	"LkRl2S#hsepS#)/;SC$iReya$g%ibg>fFhra/Y;F$eUeyi2$X88e#A$G2hq+SD0eDb$eHineRf"
	"&F$itA/V;C$e#F0F*hr_<)f?F0I<_$hrb$e@a$fDb$q2C$mbJ0)kbf}b$gehraD$i#a$hr&#g#"
	"eHa#iRIT)AS$*AO<)iRg}f'b$irZ`ZBNP)lre}VPZ>J$k2?;&f>F0I0?#hra$fMa$fhhra#gAN"
	"`I2*/#mBlreBC\\V#&/Y;a#ib;#j#hrgafviBi2YS$%lBNPY=b<F0hr$0Y@aS$*a?Z;$$hr$1O"
	"<_#nrb0S#*[#*[#*;b$hr_#&i#_#hr##';SC$&)+#i0#S&&i#gB+SD0j{r(hrf^qBa/S#b/Y;F"
	"`&htC$);a$e0F0IBkBF0);C0Y;a#hy&#hPkRgBF`*;jB1OT);[*)f#jbgQb/#hdC$);a$gaF0)"
	"hreJgPjR&/#f&&#eQhtC$Y;IT)A[TI<iR?S#j#hb##C@bP)e#jr##CBe~f%jBa#h2gpmBa$);C"
	"$gub#hRb/S#&#jbe=i?gbC\\V#&#jb;CDB;C$)>OT)1#jrhqjBi2YS$%mBNPY=b<&jr$$e??;V"
	";$$nbV[$&;#&;htb@C&?C&?C`*gr1C$e#S$f'1#e~f/n&###h=gGhrSHbJfLu%aT&)";
Uint8 rawfont[16][96], (*zoomfont[16])[96]={rawfont,0,};

int _fontprocess(int x, int y, int z, int c, int s) {
	int i, j;
	for(i=0; i<z; i++)
		for(j=(s==1?z-i:s==3?i+1:0); j<(s==2?i:s==4?z-i-1:z); j++)
			zoomfont[z-1][(y*z+i)*z+j][c] |= 1<<(7-x);
	return z;
}

void fontprocess(int z) {
	int i, j, k, l, t[1596];
	if(z) {
		if(zoomfont[z-1]) return;
		zoomfont[z-1] = malloc(96*16*z*z);
		for(i=0; i<96; i++) {
			for(j=0; j<16*z*z; j++)
				zoomfont[z-1][j][i] = 0;
			for(j=0; j<16; j++)
				for(k=0; k<8; k++) {
					l = (j>0?rawfont[j-1][i]<<k>>6&7:0)<<6 |
						(rawfont[j][i]<<k>>6&7)<<3 |
						(j<15?rawfont[j+1][i]<<k>>6&7:0);
					if((i==3 || i==20) && k<2) l |= (l & 0222) << 1;
					if((i==3 || i==20) && k>6) l |= (l & 0222) >> 1;
					if(l & 0x10) {
						_fontprocess(k, j, z, i, 0);
					} else {
						if((l & 0xda) == 0xa || (l & 0x3f) == 0xb) /* /| */
							_fontprocess(k, j, z, i, 1);
						if((l & 0x1b2) == 0x22 || (l & 0x3f) == 0x26) /* |\ */
							_fontprocess(k, j, z, i, 2);
						if((l & 0x9b) == 0x88 || (l & 0x1f8) == 0xc8) /* \| */
							_fontprocess(k, j, z, i, 3);
						if((l & 0xb6) == 0xa0 || (l & 0x1f8) == 0x1a0) /* |/ */
							_fontprocess(k, j, z, i, 4);
					}
				}
		}
	} else {
		for(i=j=k=0; i<1536; fontdata++) {
			if(*fontdata > 98) {
				for(k=*fontdata++-97; --k; i++) t[i] = t[i-*fontdata+34];
			} else if(*fontdata > 34) {
				j |= (*fontdata - 35) << k*6%8;
				if(k++&3) { t[i++] = j & 0xff; j >>= 8; }
			}
		}
		for(i=0; i<1536; i++) rawfont[i%16][i/16] = t[i];
	}
}

void fontfinalize() {
	int i;
	for(i=1; i<ARRAYSIZE(zoomfont); i++)
		if(zoomfont[i]) free(zoomfont[i]);
}

int printchar(SDL_Surface *s, int x, int y, int z, int c, int u, int v) {
	int i, j;
	if(!is_space(c)) {
		c -= (c<0 ? -96 : c<33 || c>126 ? c : 32);
		for(i=0; i<16*z; i++)
			for(j=0; j<8*z; j++)
				if(zoomfont[z-1][i*z+j%z][c]&(1<<(7-j/z)))
					putpixel(s, x+9*j/10, y+9*i/10, blend(u, v, i, 16*z-1));
	}
	return 8*z;
}

void printstr(SDL_Surface *s, int x, int y, int z, char *c, int u, int v)
	{ while(*c)x+=printchar(s,x,y,z,(Uint8)*c++,u,v); }
// end devoloped by tokigun

// print text string to screen surface
void text(char *c, int x, int y, int u, int v)
{
	printstr(screen, x, y, 1, c, u, v);
}

/******************************************************************************/
/* main routines */

void load_blockdata()
{
	cursoroff = loadimage(IDR_CURSOROFF,"PNG");
	cursoron = loadimage(IDR_CURSORON,"PNG");
	blockdata_bg = loadimage(IDR_BGBLOCK,"PNG");
	blockdata_stage = loadimage(IDR_STAGEBLOCK,"PNG");
	blockdata_blank = loadimage(IDR_BLANK,"PNG");
	blockdata_sprite1 = loadimage(IDR_SPRITE1,"PNG");
	blockdata_sprite2 = loadimage(IDR_SPRITE2,"PNG");
	blockdata_sprite3 = loadimage(IDR_SPRITE3,"PNG");
	blockdata_sprite4 = loadimage(IDR_SPRITE4,"PNG");
	blockdata_sprite5 = loadimage(IDR_SPRITE5,"PNG");
	blockdata_sprite6 = loadimage(IDR_SPRITE6,"PNG");
	blockdata_sprite7 = loadimage(IDR_SPRITE7,"PNG");
	blockdata_sprite8 = loadimage(IDR_SPRITE8,"PNG");
}

void draw_bgsurface()
{
	int i,j;

	for(i=0;i<480/blocksize;i++)
	{
		for(j=0;j<272/blocksize;j++)
		{
			SDL_BlitSurface( blockdata_bg, newrect(0,0,blocksize,blocksize), screen, newrect(i*blocksize,j*blocksize,blocksize,blocksize) );
		}
	}
}

void draw_stagesurface()
{
	int i,j;

	for(i=0;i<size_x;i++)
	{
		for(j=0;j<size_y;j++)
		{
			if(matrix[j][i] == 0) SDL_BlitSurface( blockdata_blank, newrect(0,0,blocksize,blocksize), screen, newrect(stage_x+i*blocksize,stage_y+j*blocksize,blocksize,blocksize) );
			else if(matrix[j][i] == 1) SDL_BlitSurface( blockdata_stage, newrect(0,0,blocksize,blocksize), screen, newrect(stage_x+i*blocksize,stage_y+j*blocksize,blocksize,blocksize) );
			else if(matrix[j][i] == 2) SDL_BlitSurface( blockdata_sprite1, newrect(0,0,blocksize,blocksize), screen, newrect(stage_x+i*blocksize,stage_y+j*blocksize,blocksize,blocksize) );
			else if(matrix[j][i] == 3) SDL_BlitSurface( blockdata_sprite2, newrect(0,0,blocksize,blocksize), screen, newrect(stage_x+i*blocksize,stage_y+j*blocksize,blocksize,blocksize) );
			else if(matrix[j][i] == 4) SDL_BlitSurface( blockdata_sprite3, newrect(0,0,blocksize,blocksize), screen, newrect(stage_x+i*blocksize,stage_y+j*blocksize,blocksize,blocksize) );
			else if(matrix[j][i] == 5) SDL_BlitSurface( blockdata_sprite4, newrect(0,0,blocksize,blocksize), screen, newrect(stage_x+i*blocksize,stage_y+j*blocksize,blocksize,blocksize) );
			else if(matrix[j][i] == 6) SDL_BlitSurface( blockdata_sprite5, newrect(0,0,blocksize,blocksize), screen, newrect(stage_x+i*blocksize,stage_y+j*blocksize,blocksize,blocksize) );
			else if(matrix[j][i] == 7) SDL_BlitSurface( blockdata_sprite6, newrect(0,0,blocksize,blocksize), screen, newrect(stage_x+i*blocksize,stage_y+j*blocksize,blocksize,blocksize) );
			else if(matrix[j][i] == 8) SDL_BlitSurface( blockdata_sprite7, newrect(0,0,blocksize,blocksize), screen, newrect(stage_x+i*blocksize,stage_y+j*blocksize,blocksize,blocksize) );
			else if(matrix[j][i] == 9) SDL_BlitSurface( blockdata_sprite8, newrect(0,0,blocksize,blocksize), screen, newrect(stage_x+i*blocksize,stage_y+j*blocksize,blocksize,blocksize) );
		}
	}
}

// get return of specified cell information
int get_matrix_cell(int x, int y)
{
	return matrix[y2cy(y)][x2cx(x)];
}

// move cell, by cursor, if block selected, move with block
void move(int x, int y)
{
	int nextcell, nowcell;

	if(x < stage_x) x = stage_x;
	if(x > screen_width - blocksize) x = screen_width - blocksize;
	if(y < stage_y) y = stage_y;
	if(y > screen_height - blocksize) y = screen_height - blocksize;

	// get read of cell information
	nextcell = get_matrix_cell(x,y);
	nowcell = get_matrix_cell(cursor_point[0],cursor_point[1]);
	if(nowcell > 1 && nowcell < 10)
	{
		if(ispressed == 1 && nextcell == 0)
		{
			matrix[y2cy(y)][x2cx(x)] = nowcell;
			matrix[y2cy(cursor_point[1])][x2cx(cursor_point[0])] = 0;
		}
	}
	cursor_point[0] = x;
	cursor_point[1] = y;
}

// check matrix
void check_matrix()
{
	int i,j;
	int k,a,b;
	int isEqual;
	int cell;
	int cell_arg[3][3] = { {0,0,0}, {0,1,0}, {0,0,0} };
	int cell_arg2[5][5] = { {0,0,0,0,0}, {0,0,0,0,0}, {0,0,1,0,0}, {0,0,0,0,0}, {0,0,0,0,0} };

	for(i=0;i<size_x;i++)
	{
		for(j=0;j<size_y;j++)
		{
			cell = matrix[j][i];

			// check and block down
			// if down-cell is blank, block move down
			if(matrix[j+1][i] == 0 && matrix[j][i] > 1 && matrix[j][i] < 10)
			{
				matrix[j+1][i] = matrix[j][i];
				matrix[j][i] = 0;
			}

			// check and block remove
			// if current cell is sprite block
			if(matrix[j][i] > 1 && matrix[j][i] < 10)
			{
				// insert information
				// if(current cell is equal side cell, insert 1, else 0;
				for(a=0;a<5;a++)
				{
					for(b=0;b<5;b++)
					{
						if(matrix[j][i] == matrix[j+a-2][i+b-2]) cell_arg2[a][b] = 1;
						else cell_arg2[a][b] = 0;
					}
				}
				// if outside is all 0
				if(cell_arg2[0][0] == 0 && cell_arg2[0][1] == 0 && cell_arg2[0][2] == 0 && cell_arg2[0][3] == 0 && cell_arg2[0][4] == 0
					&& cell_arg2[1][0] == 0 && cell_arg2[1][4] == 0 && cell_arg2[2][0] == 0 && cell_arg2[2][4] == 0 && cell_arg2[3][0] == 0 && cell_arg2[3][4] == 0
					&& cell_arg2[4][0] == 0 && cell_arg2[4][1] == 0 && cell_arg2[4][2] == 0 && cell_arg2[4][3] == 0 && cell_arg2[4][4] == 0)
				{
					// insert cell information to another array
					for(a=1;a<4;a++)
					{
						for(b=1;b<4;b++)
						{
							cell_arg[a-1][b-1] = cell_arg2[a][b];
						}
					}
					// check current cell information is matching remove arguments
					for(k=0;k<14;k++)
					{
						isEqual = 0;
						// check array is all equal
						for(a=0;a<3;a++)
						{
							for(b=0;b<3;b++)
							{
								if(cell_arg[a][b] == arg[k][a][b]) isEqual += 1;
							}
						}
						// if not equal all
						if(isEqual != 9) isEqual = 0;
						// if equal all
						else
						{
							// number of removed pieces
							int piece_remove = 0;

							// remove block by arguments
							if(cell_arg[0][0] == 1)
							{
								matrix[j-1][i-1] = 0;
								piece_remove++;
							}
							if(cell_arg[0][1] == 1)
							{
								matrix[j-1][i] = 0;
								piece_remove++;
							}
							if(cell_arg[0][2] == 1)
							{
								matrix[j-1][i+1] = 0;
								piece_remove++;
							}
							if(cell_arg[1][0] == 1)
							{
								matrix[j][i-1] = 0;
								piece_remove++;
							}
							if(cell_arg[1][1] == 1)
							{
								matrix[j][i] = 0;
								piece_remove++;
							}
							if(cell_arg[1][2] == 1)
							{
								matrix[j][i+1] = 0;
								piece_remove++;
							}
							if(cell_arg[2][0] == 1)
							{
								matrix[j+1][i-1] = 0;
								piece_remove++;
							}
							if(cell_arg[2][1] == 1)
							{
								matrix[j+1][i] = 0;
								piece_remove++;
							}
							if(cell_arg[2][2] == 1)
							{
								matrix[j+1][i+1] = 0;
								piece_remove++;
							}

							// score adding
							score += piece_remove*100;
							// refrash left block
							if(cell == 2) left_block[0] -= piece_remove;
							else if(cell == 3) left_block[1] -= piece_remove;
							else if(cell == 4) left_block[2] -= piece_remove;
							else if(cell == 5) left_block[3] -= piece_remove;
							else if(cell == 6) left_block[4] -= piece_remove;
							else if(cell == 7) left_block[5] -= piece_remove;
							else if(cell == 8) left_block[6] -= piece_remove;
							else if(cell == 9) left_block[7] -= piece_remove;
						}
					}
				}
			}
		}
	}
}

void get_left_block()
{
	int i,j;

	for(i=0;i<size_x;i++)
	{
		for(j=0;j<size_y;j++)
		{
			if(matrix[j][i] == 2) left_block[0] += 1;
			if(matrix[j][i] == 3) left_block[1] += 1;
			if(matrix[j][i] == 4) left_block[2] += 1;
			if(matrix[j][i] == 5) left_block[3] += 1;
			if(matrix[j][i] == 6) left_block[4] += 1;
			if(matrix[j][i] == 7) left_block[5] += 1;
			if(matrix[j][i] == 8) left_block[6] += 1;
			if(matrix[j][i] == 9) left_block[7] += 1;
		}
	}
}

// Initialize Game
int initialize_stage()
{
	load_blockdata();
	draw_bgsurface();
	timer_start = SDL_GetTicks();
	get_left_block();
	//msg("Initialized Game",NULL);
	return 0;
}

// Main Game Stage Processor
int stageproc()
{
	char bleft[2];
	int i=0, r=0;
	int timer = 0, t_millisecond = 0, t_second = 0, t_minute = 0;
	char text_score[32], text_highscore[32], text_mapname[64], text_time[16];

	// check clear to proc
	if(isStageClear == 1)
	{
		return 0;
	}

	// check matrix
	check_matrix();

	// delete graphic memory in screen surface
	SDL_FreeSurface(screen);

	// draw stage graphic by matrix cell information
	draw_bgsurface();
	draw_stagesurface();
	// cursor off
	if(ispressed == 0)
	{
		SDL_BlitSurface( cursoroff, newrect(0,0,blocksize,blocksize), screen, newrect(cursor_point[0],cursor_point[1],blocksize,blocksize) );
	}
	// cursor on
	else if(ispressed == 1)
	{
		SDL_BlitSurface( cursoron, newrect(0,0,blocksize,blocksize), screen, newrect(cursor_point[0],cursor_point[1],blocksize,blocksize) );
	}

	// Score Panel
	sprintf(text_score,"%d",score);
	sprintf(text_highscore,"%d",highscore);
	sprintf(text_mapname, "MAP: [%s]",mapname);
	text("PLAYER 1", 2, 1, 0x000000, 0x000000);
	text("PLAYER 1", 1, 0, 0xFFCC33, 0xFFCC33);
	text(text_score, 81, 1, 0x000000, 0x000000);
	text(text_score, 80, 0, 0xffffff, 0xffffff);
	text("HIGHSCORE",241,1, 0x000000, 0x000000);
	text("HIGHSCORE",240,0, 0x339900, 0x339900);
	text(text_highscore, 321, 1, 0x000000, 0x000000);
	text(text_highscore, 320, 0, 0xffffff, 0xffffff);
	// Map Name
	text(text_mapname,6,16, 0x000000, 0x000000);
	text(text_mapname,5,15, 0x7f7f7f, 0xffffff);
	// Mode Name
	if(mode == 0)
	{
		text("[ORIGINAL MODE]",6,33, 0x000000, 0x000000);
		text("[ORIGINAL MODE]",5,32, 0x66FF00, 0x66FF00);
	}
	else if(mode == 1)
	{
		text("[MANIAC MODE]",13,33, 0x000000, 0x000000);
		text("[MANIAC MODE]",12,32, 0x66FF00, 0x66FF00);
	}
	else if(mode == 2)
	{
		text("[ULTRA MODE]",16,33, 0x000000, 0x000000);
		text("[ULTRA MODE]",15,32, 0x66FF00, 0x66FF00);
	}
	else if(mode == 3)
	{
		text("[EASY MODE]",20,33, 0x000000, 0x000000);
		text("[EASY MODE]",19,32, 0x66FF00, 0x66FF00);
	}
	else if(mode == 4)
	{
		text("[NORMAL MODE]",13,33, 0x000000, 0x000000);
		text("[NORMAL MODE]",12,32, 0x66FF00, 0x66FF00);
	}
	else if(mode == 5)
	{
		text("[HARD MODE]",20,33, 0x000000, 0x000000);
		text("[HARD MODE]",19,32, 0x66FF00, 0x66FF00);
	}
	else if(mode == 6)
	{
		text("[LUNATIC MODE]",9,33, 0x000000, 0x000000);
		text("[LUNATIC MODE]",8,32, 0x66FF00, 0x66FF00);
	}

	// Timer Setting
	timer = SDL_GetTicks() - timer_start;
	if(mode == 0) timer = 240000 - timer;
	else if(mode == 1) timer = 180000 - timer;
	else if(mode == 2) timer = 120000 - timer;
	t_millisecond = timer%1000;
	t_second = timer / 1000;
	if(t_second > 59)
	{
		t_minute = t_second / 60;
		t_second -= 60*t_minute;
	}
	if(t_second < 10) sprintf(text_time, "%d:0%d:%d",t_minute,t_second,t_millisecond);
	else sprintf(text_time, "%d:%d:%d",t_minute,t_second,t_millisecond);
	text(text_time,34,46, 0x000000, 0x000000);
	text(text_time,33,45, 0x33FFFF, 0x33FFFF);

	// draw lefted sprite panel
	SDL_FillRect(screen, newrect(5,60,118,71), 0xffffff);
	SDL_FillRect(screen, newrect(6,61,116,69), 0x000000);
	if(left_block[0] != 0)
	{
		SDL_BlitSurface( blockdata_sprite1, newrect(0,0,blocksize,blocksize), screen, newrect(7,62,blocksize,blocksize) );
		sprintf(bleft, "%d",left_block[0]);
		text(" x",19,62,0xffffff, 0xffffff);
		text(bleft,35,62,0xffffff, 0xffffff);
	}
	else SDL_FillRect(screen, newrect(7,62,55,16), 0x000000);
	if(left_block[1] != 0)
	{
		SDL_BlitSurface( blockdata_sprite2, newrect(0,0,blocksize,blocksize), screen, newrect(64,62,blocksize,blocksize) );
		sprintf(bleft, "%d",left_block[1]);
		text(" x",76,62,0xffffff, 0xffffff);
		text(bleft,92,62,0xffffff, 0xffffff);
	}
	else SDL_FillRect(screen, newrect(62,62,55,16), 0x000000);
	if(left_block[2] != 0)
	{
		SDL_BlitSurface( blockdata_sprite3, newrect(0,0,blocksize,blocksize), screen, newrect(7,79,blocksize,blocksize) );
		sprintf(bleft, "%d",left_block[2]);
		text(" x",19,79,0xffffff, 0xffffff);
		text(bleft,35,79,0xffffff, 0xffffff);
	}
	else SDL_FillRect(screen, newrect(7,79,55,16), 0x000000);
	if(left_block[3] != 0)
	{
		SDL_BlitSurface( blockdata_sprite4, newrect(0,0,blocksize,blocksize), screen, newrect(64,79,blocksize,blocksize) );
		sprintf(bleft, "%d",left_block[3]);
		text(" x",76,79,0xffffff, 0xffffff);
		text(bleft,92,79,0xffffff, 0xffffff);
	}
	else SDL_FillRect(screen, newrect(64,79,55,16), 0x000000);
	if(left_block[4] != 0)
	{
		SDL_BlitSurface( blockdata_sprite5, newrect(0,0,blocksize,blocksize), screen, newrect(7,96,blocksize,blocksize) );
		sprintf(bleft, "%d",left_block[4]);
		text(" x",19,96,0xffffff, 0xffffff);
		text(bleft,35,96,0xffffff, 0xffffff);
	}
	else SDL_FillRect(screen, newrect(7,96,55,16), 0x000000);
	if(left_block[5] != 0)
	{
		SDL_BlitSurface( blockdata_sprite6, newrect(0,0,blocksize,blocksize), screen, newrect(64,96,blocksize,blocksize) );
		sprintf(bleft, "%d",left_block[5]);
		text(" x",76,96,0xffffff, 0xffffff);
		text(bleft,92,96,0xffffff, 0xffffff);
	}
	else SDL_FillRect(screen, newrect(64,96,55,16), 0x000000);
	if(left_block[6] != 0)
	{
		SDL_BlitSurface( blockdata_sprite7, newrect(0,0,blocksize,blocksize), screen, newrect(7,114,blocksize,blocksize) );
		sprintf(bleft, "%d",left_block[6]);
		text(" x",19,114,0xffffff, 0xffffff);
		text(bleft,35,114,0xffffff, 0xffffff);
	}
	else SDL_FillRect(screen, newrect(7,114,55,16), 0x000000);
	if(left_block[7] != 0)
	{
		SDL_BlitSurface( blockdata_sprite8, newrect(0,0,blocksize,blocksize), screen, newrect(64,114,blocksize,blocksize) );
		sprintf(bleft, "%d",left_block[7]);
		text(" x",76,114,0xffffff, 0xffffff);
		text(bleft,92,114,0xffffff, 0xffffff);
	}
	else SDL_FillRect(screen, newrect(64,114,55,16), 0x000000);

	// clear check
	for(i=0;i<8;i++)
	{
		r += left_block[i];
	}
	if(r <= 0)
	{
		isStageClear = 1;
	}

	return 1;
}

// Finalize Game
void finalize()
{
	// remove from memory
	fontfinalize();
	SDL_FreeSurface(blockdata_bg);
	SDL_FreeSurface(blockdata_stage);
	SDL_FreeSurface(screen);
	// end of game
	SDL_Quit();
	msg("Finalized Game",NULL);
}

/******************************************************************************/
/* entry point */
// Procedure
BOOL procedure()
{
	while(SDL_PollEvent(&event))
	{
		switch(event.type)
		{
			case SDL_QUIT: return FALSE;
			case SDL_KEYDOWN:
				switch(event.key.keysym.sym)
				{
					case SDLK_ESCAPE: return FALSE;
					case SDLK_SPACE:
						ispressed = 1;
						break;
					case SDLK_UP:
						move(cursor_point[0], cursor_point[1]-blocksize);
						break;
					case SDLK_DOWN:
						move(cursor_point[0], cursor_point[1]+blocksize);
						break;
					case SDLK_RIGHT:
						move(cursor_point[0]+blocksize, cursor_point[1]);
						break;
					case SDLK_LEFT:
						move(cursor_point[0]-blocksize, cursor_point[1]);
						break;
				}
				break;
			case SDL_KEYUP:
				switch(event.key.keysym.sym)
				{
					case SDLK_SPACE:
						ispressed = 0;
						break;
				}
				break;
			case SDL_MOUSEMOTION: break;
			case SDL_MOUSEBUTTONDOWN: break;
			case SDL_MOUSEBUTTONUP: break;
		}
	}
	return TRUE;
}

// Entry Point
int main(int argc, char *argv[])
{
	// initialize sdl
	if(SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO)<0)
		return msg("SDL Initialization Failure: %s", SDL_GetError());
	atexit(SDL_Quit);
	// initialize sdl surface
	screen = SDL_SetVideoMode(screen_width, screen_height, screen_bitrate, opt_fullscreen ? SDL_SWSURFACE|SDL_FULLSCREEN : SDL_SWSURFACE|SDL_DOUBLEBUF);
	if(!screen) msg("SDL Video Initialization Failure: %s", SDL_GetError());
	// set titlebar caption
	SDL_WM_SetCaption(version, 0);
	// initialize font
	fontprocess(0);
	fontprocess(2);
	fontprocess(3);

	SDL_EnableKeyRepeat(100, 50);

	// initialize of game stage
	initialize_stage();
	//msg("Game Started",NULL);
	while(1)
	{
		if(!procedure()) break;
		if(stageproc() == 0) break;
		SDL_Flip(screen);
	}
	finalize();
	return 0;
}