/*
	BRIX: professional edition

- Developed by Minan2DJ07 (Park Byeong-uk, 2nd07@hanmail.net)
- SDL Library Version Information

  SDL 1.2.9
  SDL_image 1.2.4
  SDL_mixer 1.2.6
  SDL_ttf 2.0.7
- Latest modified: 2006. 5.10
*/

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <SDL.h>
#include <SDL_mixer.h>
#include <SDL_image.h>

/******************************************************************************/
/* constants, variables */
// TitleBar Text
char version[] = "BRIX: professional edition v0.0-dev-20060510";

// is it FULLSCREEN ?
int opt_fullscreen = 0;
// Screen Size, Bitrate
int screen_width = 480;
int screen_height = 272;
int screen_bitrate = 32;

// Main Screen Object
SDL_Surface *screen;
// Main Event Object
SDL_Event event;

/******************************************************************************/
/* system dependent functions */
#ifdef WIN32
	#include <windows.h>

	// Output MessageBox
	int msg(char *c,char *s)
	{
		char b[512];
		sprintf(b,c,s);
		return MessageBox(0,b,version,0);
	}

#else
	#include <dirent.h>

	// Output MessageBox
	int msg(char *c,char *s)
	{
		return fprintf(stderr,c,s);
	}

#endif

/******************************************************************************/
/* general graphic functions */

/******************************************************************************/
/* font functions */

/******************************************************************************/
/* main routines */
// Initialize Game
void initialize()
{
	msg("Initialized Game",NULL);
}

// Main Game Processor
void gameproc()
{
}

// Finalize Game
void finalize()
{
	msg("Finalized Game",NULL);
}

/******************************************************************************/
/* entry point */
// Procedure
BOOL procedure()
{
	while(SDL_PollEvent(&event))
	{
		switch(event.type)
		{
			case SDL_QUIT: return FALSE;
			case SDL_KEYDOWN:
				switch(event.key.keysym.sym)
				{
					case SDLK_ESCAPE: return FALSE;
				}
				break;
			case SDL_KEYUP: break;
			case SDL_MOUSEMOTION: break;
			case SDL_MOUSEBUTTONDOWN: break;
			case SDL_MOUSEBUTTONUP: break;
		}
	}
	return TRUE;
}

// Entry POint
int main(int argc, char *argv[])
{
	if(SDL_Init(SDL_INIT_VIDEO) < 0) return msg("SDL Initialization Failure: %s", SDL_GetError());
	screen = SDL_SetVideoMode(screen_width, screen_height, screen_bitrate,
		opt_fullscreen ? SDL_SWSURFACE|SDL_DOUBLEBUF|SDL_FULLSCREEN : SDL_SWSURFACE|SDL_DOUBLEBUF);
    if(!screen) msg("SDL Video Initialization Failure: %s", SDL_GetError());
	SDL_WM_SetCaption(version, 0);
	
	initialize();
	msg("Game Started",NULL);
	while(1)
	{
		if(!procedure()) break;
		gameproc();
	}
	finalize();
	return 0;
}