# -*- coding:utf-8 -*-
# ModCodec.py

URL_ENDECODE = 0
HEX_ENDECODE = 1
BASE64_ENDECODE = 2

import re
import urllib

import utils,  sys

try:
    from PyQt4 import QtCore
except ImportError:
    utils.printerror("Can't import QtCore")
    sys.exit(1)

    
class ModCodec():
    def __init__(self, encode=True, function=URL_ENDECODE):
        # If isEncoding is set True, the class encodes input string
        self.m_IsEncoding = encode
        self.m_Function = function
        self.m_InputStr = u''
        self.m_OutputStr = u''
        self.FUNCTION = {URL_ENDECODE:self.URLEncode, HEX_ENDECODE:self.HEXEncode, BASE64_ENDECODE:self.BASE64Encode}

    def Operation(self, input):
        self.m_InputStr = input
        self.FUNCTION[self.m_Function](self.m_IsEncoding)
        if len(self.m_OutputStr) is not 0:
            return self.m_OutputStr
        else:
            return None

    '''
        인코딩의 경우 type 값이 True일 때 이며,
        디코딩의 경우 Type값이 False일 때 이다.
       PyQt 에서 한글과의 호환성을 위해 UTF-8으로 처리를 하고 있으며 다른 문자 체계는 고려하지 않았다.
        
       In case of encoding, a selected function is passed ''True'' value for type variable.
       In case of decoding, it is passed "False" value.
       UTF-8 encoding system was applied to the program for compatibility with KOREAN. but, other encoding systems were not considered. 
    '''
    def URLEncode(self, type):
        input = self.m_InputStr.toUtf8().__str__()
        if type is True:                    
            for ch in input:
                if ch.isalnum() or ch in ['$','&','+',',','/',':',';','=','?','@']:
                    self.m_OutputStr += ch
                else:
                    self.m_OutputStr += ('%'+hex(ord(ch))[2:])
        else:
            if input.count("'") > 0:        # 디코딩 할 문자열에 single-quote가 존재하는지 검사한다.
                self.m_OutputStr = ''
                return
            temp = eval("'%s'"% urllib.unquote(input))
            utils.debugprint("URLEncode,  Decoding: temp=%s"%temp,  utils.ISDEBUG)
            self.m_OutputStr = temp


    def HEXEncode(self, type):
        if type is True:                    
            input = self.m_InputStr.toUtf8().toHex()
            utils.debugprint("toHex() string: %s"% input.__str__(),  utils.ISDEBUG)
            for idx in range(0,  input.length(),  2):
                self.m_OutputStr += '\\x'+ input[idx:idx+2]
        else:                                 
            input = self.m_InputStr.__str__()
            if self.CheckHEXEncode(input,  0) is False:      # 0은 현재 디폴트 형태(/xOO)를 나타낸다.(임시)
                self.m_OutputStr = ''
                return
            temp = eval("'%s'"%input)
            self.m_OutputStr = temp
            utils.debugprint("OutputStr_input = %s"% input, utils.ISDEBUG)
            utils.debugprint("OutputStr_temp = %s"% temp, utils.ISDEBUG)
            utils.debugprint("OutputStr= %s"% self.m_OutputStr, utils.ISDEBUG)

    def BASE64Encode(self, type):
        if type is True:           
            self.m_OutputStr = self.m_InputStr.toUtf8().toBase64()
        else:                       
            temp = QtCore.QByteArray.fromBase64(self.m_InputStr.toUtf8())
            self.m_OutputStr = temp.__str__()           # 한글처리 때문에 처리의 일관성이 떨어짐. 더 나은 방법을 찾기 전에는 이대로 시용해야 할 듯.

            
    ''' 입력된 문자열이 16진수 형태를 하고 있는지 검사한다.
        Check an input string to be formed as hexadecimal '''
    def CheckHEXEncode(self,  input,  mode):
        if mode == 0:
            if len(input)%4 != 0:
                utils.debugprint("incorrect length: %d"% len(input),  utils.ISDEBUG)
                return False
            for idx in range(0,  len(input),  4):
                try:
                    if input[idx:idx+2] == '\\x':
                        temp = int(input[idx+2:idx+4],  16)
                    else:
                        utils.debugprint("%s is not form of hexadecimal number!"%input[idx:idx+4],  utils.ISDEBUG)
                        return False
                except ValueError:
                    utils.debugprint("%s is not hexadecimal number!"%input[idx+2:idx+4],  utils.ISDEBUG)
                    return False
            return True
        else:
            return True
            
