package net.kldp.beat.system.interceptor;

import java.lang.annotation.Annotation;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.exception.fatal.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.system.aware.ServletContextAware;

/**
 * ServletContext객체를 주입합니다.
 *
 */
final class ServletContextInterceptor implements SystemInterceptor {

	@Override
	public void intercept(Object object, ActionContext context, Annotation annotation) throws InterceptorException {
		try {
			((ServletContextAware) object).setServletContext(context.getServletContext());
		} catch (ClassCastException e) {
			throw new InterceptorException(e);
		}
	}
}