package net.kldp.beat.message;

/**
 * 메세지 리소스를 정의하는 클래스입니다.
 * 
 */
public class Resource {

	private static GetResource resource;
	private Message message = new Message();
	private String key;

	private Resource() {
		synchronized (this) {
			if (resource == null)
				resource = new GetResource();
			ResourcePool.put(this);
		}
	}

	public Resource(String key) {
		this();
		if (key == null)
			throw new IllegalArgumentException("message key is null");
		this.key = key;
		message.setMessage(resource.get(key));
	}

	public Resource(String key, Object... args) {
		this(key);
		message.setArgs(args);
	}

	@Override
	public String toString() {
		return message.toString();
	}

	Message getMessage() {
		return message;
	}

	String getKey() {
		return key;
	}

	@Override
	public int hashCode() {
		return key.length();
	}

	@Override
	public boolean equals(Object obj) {
		if (this != obj)
			return false;
		if (hashCode() != obj.hashCode())
			return false;
		if (!(obj instanceof Message))
			return false;
		Resource r = (Resource) obj;
		if (!key.equals(r.key))
			return false;
		if (!message.equals(r.message))
			return false;
		return true;
	}
}