package net.kldp.beat.configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * 사용자의 요청을 액션과 뷰사이에 매핑해주는 클래스입니다.
 *
 */
public class ActionMapping {
	private String viewLocation = "";
	private String mappingLocation = "";
	private List<String> resources = new ArrayList<String>();

	/**
	 * View가 설정된 위치를 리턴합니다.
	 * @return
	 */
	public String getViewLocation() {
		if(viewLocation.charAt(0) == '/') {
			return viewLocation.substring(1);
		}
		return viewLocation;
	}

	public void setViewLocation(String viewLocation) {
		this.viewLocation = viewLocation;
	}

	/**
	 * 사용자의 요청을 매핑할 URL입니다.
	 * @return
	 */
	public String getMappingLocation() {
		return mappingLocation;
	}

	public void setMappingLocation(String mappingLocation) {
		this.mappingLocation = mappingLocation;
	}

	/**
	 * beat.xml 파일에 설정된 리소스 파일을 리턴합니다.
	 * @return
	 */
	public List<String> getResources() {
		return resources;
	}

	public void addResource(String resource) {
		resources.add(resource);
	}
}