package net.kldp.beat.action.pool;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

import net.kldp.beat.configuration.DevMode;

/**
 * 액션 클래스의 어노테이션을 저장하는 풀 클래스 입니다. 
 * 개발 모드에서 어노테이션은 항상 새롭게 리턴됩니다.
 */
public class AnnotationPool extends DevMode {
	private static Map<Class<?>, Map<Class<? extends Annotation>, Annotation>> pool = new HashMap<Class<?>, Map<Class<? extends Annotation>, Annotation>>();

	public static void put(Class<?> actionClass,
			Map<Class<? extends Annotation>, Annotation> annotations) {
		if (isDevMode)
			return;
		pool.put(actionClass, annotations);
	}

	public static Map<Class<? extends Annotation>, Annotation> get(
			Class<?> actionClass) {
		if (isDevMode)
			return null;
		return pool.get(actionClass);
	}
}