package net.kldp.beat.action.pool;

import java.util.HashMap;
import java.util.Map;

import net.kldp.beat.configuration.DevMode;
import net.kldp.beat.exception.UrlMappingException;

/**
 * 액션 클래스를 저장하는 풀 클래스 입니다. 개발 모드에서 액션 클래스는 항상 새롭게 리턴됩니다.
 */
public class ActionClassPool extends DevMode {
	private static Map<String, Class<? extends Object>> actionClasses = new HashMap<String, Class<? extends Object>>();

	public static Class<? extends Object> get(String className)
			throws ClassNotFoundException, UrlMappingException {
		if (isDevMode)
			return null;
		return actionClasses.get(className);
	}

	public static void put(String className, Class<? extends Object> clazz) {
		if (isDevMode)
			return;
		actionClasses.put(className, clazz);
	}
}