/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.message;

public class Message {
    private String message;
    private Object[] args = new Object[0];

    protected Message() {
    }

    public Message(String string) {
        this.setMessage(string);
    }

    public Message(String string, Object ... objectArray) {
        this.setMessage(string);
        this.args = objectArray;
    }

    public final void setMessage(String string) {
        if (string == null) {
            throw new IllegalArgumentException("message is null");
        }
        this.message = string;
    }

    public final void setArgs(Object ... objectArray) {
        this.args = objectArray;
    }

    public final String toString() {
        return this.parseString();
    }

    public static final String format(String string, Object ... objectArray) {
        return new Message(string, objectArray).toString();
    }

    private final String parseString() {
        if (this.args.length == 0) {
            return this.message;
        }
        String string = this.message;
        for (int i = 0; i < this.args.length; ++i) {
            string = string.replace("\\{" + i + "\\}", this.args[i].toString());
        }
        return string;
    }

    public int hashCode() {
        return this.message.length() + this.message.length() * this.args.length;
    }

    public boolean equals(Object object) {
        if (this != object) {
            return false;
        }
        if (this.hashCode() != object.hashCode()) {
            return false;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)object;
        if (!this.message.equals(message.message)) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equals(message.args[i])) continue;
            return false;
        }
        return true;
    }
}

