/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.lang.annotation.Annotation;
import java.util.Map;
import net.kldp.beat.action.ActionContext;
import net.kldp.beat.action.AnnotationFinder;
import net.kldp.beat.action.InterceptorStack;
import net.kldp.beat.exception.fatal.InterceptorException;
import net.kldp.beat.interceptor.BeforeInterceptor;
import net.kldp.beat.interceptor.DisposeableInterceptor;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.system.interceptor.InterceptorFactory;

public class InterceptorInvoker {
    private InterceptorStack stack;
    private ActionContext context;
    private Object action;

    public InterceptorInvoker(ActionContext actionContext, InterceptorStack interceptorStack, Object object) {
        this.context = actionContext;
        this.stack = interceptorStack;
        this.action = object;
    }

    public void executeSystemInterceptors() throws InterceptorException {
        InterceptorFactory.intecept(this.action, this.stack.getSystemInterceptors(), this.context);
    }

    public void initUserInterceptors() throws InterceptorException {
        this.initInterceptors(this.stack.getBeforeInterceptors());
        this.initInterceptors(this.stack.getAfterInterceptors());
    }

    public boolean executeBeforeInterceptors() throws InterceptorException {
        return this.executeInterceptors(this.action, this.stack.getBeforeInterceptors());
    }

    public boolean executeAfterInterceptors() throws InterceptorException {
        return this.executeInterceptors(this.action, this.stack.getAfterInterceptors());
    }

    public void destroyInterceptors() throws InterceptorException {
        for (UserInterceptor userInterceptor : this.stack.getBeforeInterceptors().keySet()) {
            if (!(userInterceptor instanceof DisposeableInterceptor)) continue;
            this.destroy(userInterceptor);
        }
        for (UserInterceptor userInterceptor : this.stack.getAfterInterceptors().keySet()) {
            if (!(userInterceptor instanceof DisposeableInterceptor) || userInterceptor instanceof BeforeInterceptor) continue;
            this.destroy(userInterceptor);
        }
    }

    private void destroy(UserInterceptor userInterceptor) throws InterceptorException {
        ((DisposeableInterceptor)((Object)userInterceptor)).destroy();
    }

    private void initInterceptors(Map<UserInterceptor, Annotation> map) throws InterceptorException {
        for (UserInterceptor userInterceptor : map.keySet()) {
            AnnotationFinder annotationFinder = new AnnotationFinder(userInterceptor.getClass());
            annotationFinder.find();
            for (Annotation annotation : annotationFinder.getAnnotations()) {
                InterceptorFactory.intecept(userInterceptor, this.context, annotation);
            }
        }
    }

    private boolean executeInterceptors(Object object, Map<UserInterceptor, Annotation> map) throws InterceptorException {
        boolean bl = true;
        for (UserInterceptor userInterceptor : map.keySet()) {
            if (userInterceptor.intercept(object, map.get(userInterceptor))) continue;
            bl = false;
        }
        return bl;
    }
}

