/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.lang.reflect.Method;
import net.kldp.beat.annotation.After;
import net.kldp.beat.annotation.Before;
import net.kldp.beat.annotation.BeforeResult;
import net.kldp.beat.exception.fatal.ActionExecuteException;

public class ActionInvoker {
    private Object action;
    private Method beforeMethod;
    private Method resultBeforeMethod;
    private Method afterMethod;

    public ActionInvoker(Object object) {
        this.action = object;
        this.classifyMethods(object.getClass().getMethods());
    }

    private void classifyMethods(Method[] methodArray) {
        for (Method method : methodArray) {
            Before before = method.getAnnotation(Before.class);
            After after = method.getAnnotation(After.class);
            BeforeResult beforeResult = method.getAnnotation(BeforeResult.class);
            if (before != null && this.beforeMethod == null) {
                this.beforeMethod = method;
                continue;
            }
            if (beforeResult != null && this.resultBeforeMethod == null) {
                this.resultBeforeMethod = method;
                continue;
            }
            if (after == null || this.afterMethod != null) continue;
            this.afterMethod = method;
        }
    }

    public String execute() throws ActionExecuteException {
        try {
            Method method = this.action.getClass().getMethod("execute", new Class[0]);
            return (String)method.invoke(this.action, new Object[0]);
        }
        catch (Exception exception) {
            throw new ActionExecuteException(exception);
        }
    }

    public void executeBefore() throws ActionExecuteException {
        if (this.beforeMethod != null) {
            this.invokeMethod(this.beforeMethod);
        }
    }

    public void executeAfter() throws ActionExecuteException {
        if (this.afterMethod != null) {
            this.invokeMethod(this.afterMethod);
        }
    }

    public void executeBeforeResult() throws ActionExecuteException {
        if (this.resultBeforeMethod != null) {
            this.invokeMethod(this.resultBeforeMethod);
        }
    }

    private void invokeMethod(Method method) throws ActionExecuteException {
        try {
            method.invoke(this.action, new Object[0]);
        }
        catch (Exception exception) {
            throw new ActionExecuteException(exception);
        }
    }
}

